/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.reflections8.ReflectionUtils;
import org.reflections8.Reflections;
import org.reflections8.ReflectionsException;
import org.reflections8.scanners.Scanner;
import org.reflections8.util.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Utils {
    public static String repeat(String string2, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(string2);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String s2) {
        return s2 == null || s2.length() == 0;
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static File prepareFile(String filename) {
        File file = new File(filename);
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return file;
    }

    public static Member getMemberFromDescriptor(String descriptor2, ClassLoader ... classLoaders) throws ReflectionsException {
        return Utils.getMemberFromDescriptor(descriptor2, Optional.of(classLoaders != null ? classLoaders : new ClassLoader[]{}));
    }

    public static Member getMemberFromDescriptor(String descriptor2, Optional<ClassLoader[]> classLoaders) {
        int p0 = descriptor2.lastIndexOf(40);
        String memberKey = p0 != -1 ? descriptor2.substring(0, p0) : descriptor2;
        String methodParameters = p0 != -1 ? descriptor2.substring(p0 + 1, descriptor2.lastIndexOf(41)) : "";
        int p1 = Math.max(memberKey.lastIndexOf(46), memberKey.lastIndexOf(36));
        String className = memberKey.substring(memberKey.lastIndexOf(32) + 1, p1);
        String memberName = memberKey.substring(p1 + 1);
        int endsWithLambda = memberKey.lastIndexOf(".lambda");
        if (endsWithLambda > 0) {
            memberName = memberKey.substring(endsWithLambda + 1);
            className = memberKey.substring(memberKey.lastIndexOf(32) + 1, endsWithLambda);
        }
        Class<?>[] parameterTypes = Utils.getParameterTypes(classLoaders, methodParameters);
        Class<?> aClass = ReflectionUtils.forName(className, classLoaders);
        return Utils.getMember(descriptor2, className, memberName, parameterTypes, aClass);
    }

    private static Class<?>[] getParameterTypes(Optional<ClassLoader[]> classLoaders, String methodParameters) {
        Class[] parameterTypes = null;
        if (!Utils.isEmpty(methodParameters)) {
            String[] parameterNames = methodParameters.split(",");
            ArrayList result2 = new ArrayList(parameterNames.length);
            for (String name : parameterNames) {
                result2.add(ReflectionUtils.forName(name.trim(), classLoaders));
            }
            parameterTypes = result2.toArray(new Class[result2.size()]);
        }
        return parameterTypes;
    }

    private static Member getMember(String descriptor2, String className, String memberName, Class<?>[] parameterTypes, Class<?> aClass) {
        while (aClass != null) {
            try {
                if (!descriptor2.contains("(")) {
                    return aClass.isInterface() ? aClass.getField(memberName) : aClass.getDeclaredField(memberName);
                }
                if (Utils.isConstructor(descriptor2)) {
                    return aClass.isInterface() ? aClass.getConstructor(parameterTypes) : aClass.getDeclaredConstructor(parameterTypes);
                }
                return aClass.isInterface() ? aClass.getMethod(memberName, parameterTypes) : aClass.getDeclaredMethod(memberName, parameterTypes);
            }
            catch (Exception e) {
                aClass = aClass.getSuperclass();
            }
        }
        throw new ReflectionsException("Can't resolve member named " + memberName + " for class " + className);
    }

    public static Set<Method> getMethodsFromDescriptors(Iterable<String> annotatedWith, Optional<ClassLoader[]> classLoaders) {
        HashSet<Method> result2 = new HashSet<Method>();
        for (String annotated : annotatedWith) {
            Method member;
            if (Utils.isConstructor(annotated) || (member = (Method)Utils.getMemberFromDescriptor(annotated, classLoaders)) == null) continue;
            result2.add(member);
        }
        return result2;
    }

    public static Set<Method> getMethodsFromDescriptors(Iterable<String> annotatedWith, ClassLoader ... classLoaders) {
        return Utils.getMethodsFromDescriptors(annotatedWith, Optional.of(classLoaders != null ? classLoaders : new ClassLoader[]{}));
    }

    public static Set<Constructor> getConstructorsFromDescriptors(Iterable<String> annotatedWith, Optional<ClassLoader[]> classLoaders) {
        HashSet<Constructor> result2 = new HashSet<Constructor>();
        for (String annotated : annotatedWith) {
            Constructor member;
            if (!Utils.isConstructor(annotated) || (member = (Constructor)Utils.getMemberFromDescriptor(annotated, classLoaders)) == null) continue;
            result2.add(member);
        }
        return result2;
    }

    public static Set<Constructor> getConstructorsFromDescriptors(Iterable<String> annotatedWith, ClassLoader ... classLoaders) {
        return Utils.getConstructorsFromDescriptors(annotatedWith, Optional.of(classLoaders != null ? classLoaders : new ClassLoader[]{}));
    }

    public static Set<Member> getMembersFromDescriptors(Iterable<String> values2, Optional<ClassLoader[]> classLoaders) {
        HashSet<Member> result2 = new HashSet<Member>();
        for (String value : values2) {
            try {
                result2.add(Utils.getMemberFromDescriptor(value, classLoaders));
            }
            catch (ReflectionsException e) {
                throw new ReflectionsException("Can't resolve member named " + value, e);
            }
        }
        return result2;
    }

    public static Set<Member> getMembersFromDescriptors(Iterable<String> values2, ClassLoader ... classLoaders) {
        return Utils.getMembersFromDescriptors(values2, Optional.of(classLoaders != null ? classLoaders : new ClassLoader[]{}));
    }

    public static Field getFieldFromString(String field, ClassLoader ... classLoaders) {
        return Utils.getFieldFromString(field, Optional.of(classLoaders != null ? classLoaders : new ClassLoader[]{}));
    }

    public static Field getFieldFromString(String field, Optional<ClassLoader[]> classLoaders) {
        String className = field.substring(0, field.lastIndexOf(46));
        String fieldName = field.substring(field.lastIndexOf(46) + 1);
        try {
            return ReflectionUtils.forName(className, classLoaders).getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionsException("Can't resolve field named " + fieldName, e);
        }
    }

    public static void close(InputStream closeable) {
        block3: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException e) {
                if (!Reflections.log.isPresent()) break block3;
                Reflections.log.get().warn("Could not close InputStream", e);
            }
        }
    }

    public static Optional<Logger> findLogger(Class<?> aClass) {
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            return Optional.of(LoggerFactory.getLogger(aClass));
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static boolean isConstructor(String fqn) {
        return fqn.contains("init>");
    }

    public static String name(Class type2) {
        if (!type2.isArray()) {
            return type2.getName();
        }
        int dim = 0;
        while (type2.isArray()) {
            ++dim;
            type2 = type2.getComponentType();
        }
        return type2.getName() + Utils.repeat("[]", dim);
    }

    public static List<String> names(Iterable<Class<?>> types) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (Class<?> type2 : types) {
            result2.add(Utils.name(type2));
        }
        return result2;
    }

    public static List<String> names(Class<?> ... types) {
        return Utils.names(Arrays.asList(types));
    }

    public static String name(Constructor constructor) {
        return constructor.getName() + ".<init>(" + Joiner.on(", ").join(Utils.names(constructor.getParameterTypes())) + ")";
    }

    public static String name(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(" + Joiner.on(", ").join(Utils.names(method.getParameterTypes())) + ")";
    }

    public static String name(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    public static String index(Class<? extends Scanner> scannerClass) {
        return scannerClass.getSimpleName();
    }
}

