/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.serializers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.reflections8.ReflectionUtils;
import org.reflections8.Reflections;
import org.reflections8.ReflectionsException;
import org.reflections8.scanners.TypeElementsScanner;
import org.reflections8.serializers.Serializer;
import org.reflections8.util.HashSetMultimap;
import org.reflections8.util.Joiner;
import org.reflections8.util.Utils;

public class JavaCodeSerializer
implements Serializer {
    private static final String pathSeparator = "_";
    private static final String doubleSeparator = "__";
    private static final String dotSeparator = ".";
    private static final String arrayDescriptor = "$$";
    private static final String tokenSeparator = "_";

    @Override
    public Reflections read(InputStream inputStream2) {
        throw new UnsupportedOperationException("read is not implemented on JavaCodeSerializer");
    }

    @Override
    public File save(Reflections reflections, String name) {
        String className;
        String packageName;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String filename = name.replace('.', '/').concat(".java");
        File file = Utils.prepareFile(filename);
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            packageName = "";
            className = name.substring(name.lastIndexOf(47) + 1);
        } else {
            packageName = name.substring(name.lastIndexOf(47) + 1, lastDot);
            className = name.substring(lastDot + 1);
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("//generated using Reflections JavaCodeSerializer").append(" [").append(new Date()).append("]").append("\n");
            if (packageName.length() != 0) {
                sb.append("package ").append(packageName).append(";\n");
                sb.append("\n");
            }
            sb.append("public interface ").append(className).append(" {\n\n");
            sb.append(this.toString(reflections));
            sb.append("}\n");
            Files.write(new File(filename).toPath(), sb.toString().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return file;
    }

    @Override
    public String toString(Reflections reflections8) {
        if (reflections8.getStore().get(Utils.index(TypeElementsScanner.class)).isEmpty() && Reflections.log.isPresent()) {
            Reflections.log.get().warn("JavaCodeSerializer needs TypeElementsScanner configured");
        }
        StringBuilder sb = new StringBuilder();
        List<Object> prevPaths = new ArrayList();
        int indent = 1;
        ArrayList keys2 = new ArrayList(reflections8.getStore().get(Utils.index(TypeElementsScanner.class)).keySet());
        Collections.sort(keys2);
        for (String fqn : keys2) {
            int j;
            int i;
            List<String> typePaths = Arrays.asList(fqn.split("\\."));
            for (i = 0; i < Math.min(typePaths.size(), prevPaths.size()) && typePaths.get(i).equals(prevPaths.get(i)); ++i) {
            }
            for (j = prevPaths.size(); j > i; --j) {
                sb.append(Utils.repeat("\t", --indent)).append("}\n");
            }
            for (j = i; j < typePaths.size() - 1; ++j) {
                sb.append(Utils.repeat("\t", indent++)).append("public interface ").append(this.getNonDuplicateName(typePaths.get(j), typePaths, j)).append(" {\n");
            }
            String className = typePaths.get(typePaths.size() - 1);
            ArrayList<String> annotations2 = new ArrayList<String>();
            ArrayList<String> fields2 = new ArrayList<String>();
            HashSetMultimap<String, String> methods2 = new HashSetMultimap<String, String>(new Supplier<Set<String>>(){

                @Override
                public Set<String> get() {
                    return new HashSet<String>();
                }
            });
            for (String string2 : reflections8.getStore().get(Utils.index(TypeElementsScanner.class), fqn)) {
                if (string2.startsWith("@")) {
                    annotations2.add(string2.substring(1));
                    continue;
                }
                if (string2.contains("(")) {
                    if (string2.startsWith("<")) continue;
                    int i1 = string2.indexOf(40);
                    String name = string2.substring(0, i1);
                    String params = string2.substring(i1 + 1, string2.indexOf(")"));
                    String paramsDescriptor = "";
                    if (params.length() != 0) {
                        paramsDescriptor = "_" + params.replace(dotSeparator, "_").replace(", ", doubleSeparator).replace("[]", arrayDescriptor);
                    }
                    String normalized = name + paramsDescriptor;
                    methods2.putSingle(name, normalized);
                    continue;
                }
                if (Utils.isEmpty(string2)) continue;
                fields2.add(string2);
            }
            sb.append(Utils.repeat("\t", indent++)).append("public interface ").append(this.getNonDuplicateName(className, typePaths, typePaths.size() - 1)).append(" {\n");
            if (!fields2.isEmpty()) {
                sb.append(Utils.repeat("\t", indent++)).append("public interface fields {\n");
                for (String string3 : fields2) {
                    sb.append(Utils.repeat("\t", indent)).append("public interface ").append(this.getNonDuplicateName(string3, typePaths)).append(" {}\n");
                }
                sb.append(Utils.repeat("\t", --indent)).append("}\n");
            }
            if (!methods2.isEmpty()) {
                sb.append(Utils.repeat("\t", indent++)).append("public interface methods {\n");
                for (Map.Entry entry : methods2.entrySet()) {
                    String simpleName2 = (String)entry.getKey();
                    for (String normalized : (Set)entry.getValue()) {
                        String methodName = ((Set)methods2.get(simpleName2)).size() == 1 ? simpleName2 : normalized;
                        methodName = this.getNonDuplicateName(methodName, fields2);
                        sb.append(Utils.repeat("\t", indent)).append("public interface ").append(this.getNonDuplicateName(methodName, typePaths)).append(" {}\n");
                    }
                }
                sb.append(Utils.repeat("\t", --indent)).append("}\n");
            }
            if (!annotations2.isEmpty()) {
                sb.append(Utils.repeat("\t", indent++)).append("public interface annotations {\n");
                Iterator<Object> iterator2 = annotations2.iterator();
                while (iterator2.hasNext()) {
                    String string4;
                    String nonDuplicateName = string4 = (String)iterator2.next();
                    nonDuplicateName = this.getNonDuplicateName(nonDuplicateName, typePaths);
                    sb.append(Utils.repeat("\t", indent)).append("public interface ").append(nonDuplicateName).append(" {}\n");
                }
                sb.append(Utils.repeat("\t", --indent)).append("}\n");
            }
            prevPaths = typePaths;
        }
        for (int j = prevPaths.size(); j >= 1; --j) {
            sb.append(Utils.repeat("\t", j)).append("}\n");
        }
        return sb.toString();
    }

    private String getNonDuplicateName(String candidate, List<String> prev, int offset) {
        String normalized = this.normalize(candidate);
        for (int i = 0; i < offset; ++i) {
            if (!normalized.equals(prev.get(i))) continue;
            return this.getNonDuplicateName(normalized + "_", prev, offset);
        }
        return normalized;
    }

    private String normalize(String candidate) {
        return candidate.replace(dotSeparator, "_");
    }

    private String getNonDuplicateName(String candidate, List<String> prev) {
        return this.getNonDuplicateName(candidate, prev, prev.size());
    }

    public static Class<?> resolveClassOf(Class element) throws ClassNotFoundException {
        LinkedList<String> ognl = new LinkedList<String>();
        for (Class<?> cursor = element; cursor != null; cursor = cursor.getDeclaringClass()) {
            ognl.addFirst(cursor.getSimpleName());
        }
        String classOgnl = Joiner.on(dotSeparator).join(ognl.subList(1, ognl.size())).replace(".$", "$");
        return Class.forName(classOgnl);
    }

    public static Class<?> resolveClass(Class aClass) {
        try {
            return JavaCodeSerializer.resolveClassOf(aClass);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to class " + aClass.getName(), e);
        }
    }

    public static Field resolveField(Class aField) {
        try {
            String name = aField.getSimpleName();
            Class<?> declaringClass = aField.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer.resolveClassOf(declaringClass).getDeclaredField(name);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to field " + aField.getName(), e);
        }
    }

    public static Annotation resolveAnnotation(Class annotation) {
        try {
            String name = annotation.getSimpleName().replace("_", dotSeparator);
            Class<?> declaringClass = annotation.getDeclaringClass().getDeclaringClass();
            Class<?> aClass = JavaCodeSerializer.resolveClassOf(declaringClass);
            Class<?> aClass1 = ReflectionUtils.forName(name, new ClassLoader[0]);
            Object annotation1 = aClass.getAnnotation(aClass1);
            return annotation1;
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to annotation " + annotation.getName(), e);
        }
    }

    public static Method resolveMethod(Class aMethod) {
        String methodOgnl = aMethod.getSimpleName();
        try {
            Class[] paramTypes;
            String methodName;
            if (methodOgnl.contains("_")) {
                methodName = methodOgnl.substring(0, methodOgnl.indexOf("_"));
                String[] params = methodOgnl.substring(methodOgnl.indexOf("_") + 1).split(doubleSeparator);
                paramTypes = new Class[params.length];
                for (int i = 0; i < params.length; ++i) {
                    String typeName = params[i].replace(arrayDescriptor, "[]").replace("_", dotSeparator);
                    paramTypes[i] = ReflectionUtils.forName(typeName, new ClassLoader[0]);
                }
            } else {
                methodName = methodOgnl;
                paramTypes = null;
            }
            Class<?> declaringClass = aMethod.getDeclaringClass().getDeclaringClass();
            return JavaCodeSerializer.resolveClassOf(declaringClass).getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            throw new ReflectionsException("could not resolve to method " + aMethod.getName(), e);
        }
    }
}

