/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Component;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.Set;
import org.pushingpixels.substance.api.SubstanceSlices;

public class SubstanceOutlineUtilities {
    public static GeneralPath getBaseOutline(Component comp, float radius, Set<SubstanceSlices.Side> straightSides) {
        int width = comp.getWidth();
        int height = comp.getHeight();
        return SubstanceOutlineUtilities.getBaseOutline(width, height, radius, straightSides);
    }

    public static GeneralPath getBaseOutline(float width, float height, float radius, Set<SubstanceSlices.Side> straightSides) {
        return SubstanceOutlineUtilities.getBaseOutline(width, height, radius, straightSides, 0.0f);
    }

    public static GeneralPath getBaseOutline(float width, float height, float radius, Set<SubstanceSlices.Side> straightSides, float insets) {
        boolean isTopLeftCorner = straightSides != null && (straightSides.contains((Object)SubstanceSlices.Side.LEFT) || straightSides.contains((Object)SubstanceSlices.Side.TOP));
        boolean isTopRightCorner = straightSides != null && (straightSides.contains((Object)SubstanceSlices.Side.RIGHT) || straightSides.contains((Object)SubstanceSlices.Side.TOP));
        boolean isBottomRightCorner = straightSides != null && (straightSides.contains((Object)SubstanceSlices.Side.RIGHT) || straightSides.contains((Object)SubstanceSlices.Side.BOTTOM));
        boolean isBottomLeftCorner = straightSides != null && (straightSides.contains((Object)SubstanceSlices.Side.LEFT) || straightSides.contains((Object)SubstanceSlices.Side.BOTTOM));
        float xs = insets;
        float ys = insets;
        width -= 2.0f * insets;
        height -= 2.0f * insets;
        GeneralPath result2 = new GeneralPath();
        if (isTopLeftCorner || radius <= 0.0f) {
            result2.moveTo(xs, ys);
        } else {
            result2.moveTo(xs + radius, ys);
        }
        if (isTopRightCorner || radius <= 0.0f) {
            result2.lineTo(xs + width, ys);
        } else {
            if (isTopLeftCorner || xs + width - radius >= radius) {
                result2.lineTo(xs + width - radius, ys);
            }
            result2.append(new Arc2D.Double(xs + width - 2.0f * radius, ys, 2.0f * radius, 2.0f * radius, 90.0, -90.0, 0), true);
        }
        if (isBottomRightCorner || radius <= 0.0f) {
            result2.lineTo(xs + width, ys + height);
        } else {
            if (isTopRightCorner || ys + height - radius >= radius) {
                result2.lineTo(xs + width, ys + height - radius);
            }
            result2.append(new Arc2D.Double(xs + width - 2.0f * radius, ys + height - 2.0f * radius, 2.0f * radius, 2.0f * radius, 0.0, -90.0, 0), true);
        }
        if (isBottomLeftCorner || radius <= 0.0f) {
            result2.lineTo(xs, ys + height);
        } else {
            if (isBottomRightCorner || xs + width - radius >= radius) {
                result2.lineTo(xs + radius, ys + height);
            }
            result2.append(new Arc2D.Double(xs, ys + height - 2.0f * radius, 2.0f * radius, 2.0f * radius, 270.0, -90.0, 0), true);
        }
        if (isTopLeftCorner || radius == 0.0f) {
            result2.lineTo(xs, ys);
        } else {
            if (isBottomLeftCorner || ys + height - radius >= radius) {
                result2.lineTo(xs, ys + radius);
            }
            result2.append(new Arc2D.Double(xs, ys, 2.0f * radius, 2.0f * radius, 180.0, -90.0, 0), true);
        }
        return result2;
    }

    public static GeneralPath getTriangleButtonOutline(float width, float height, float radius, float insets) {
        float xs = insets;
        float ys = insets + 1.0f;
        float xe = width - insets;
        float ye = height - insets;
        width -= 2.0f * insets;
        GeneralPath result2 = new GeneralPath();
        float radius3 = (float)((double)radius / (1.5 * Math.pow(height -= 2.0f * insets, 0.5)));
        if (Math.max(width, height) < 15.0f) {
            radius3 /= 2.0f;
        }
        result2.moveTo(radius + xs, ys);
        if (xe - radius >= radius) {
            result2.lineTo(xe - radius, ys);
        }
        result2.quadTo(xe - radius3, ys + radius3, xe, ys + radius);
        float h2 = (ye - 1.0f) / 2.0f;
        if (h2 >= radius) {
            result2.lineTo(xe, h2);
        }
        result2.lineTo((xs + xe) / 2.0f, ye - 1.0f);
        result2.lineTo(xs, h2);
        if (h2 >= radius) {
            result2.lineTo(xs, h2);
        }
        if (height - radius - 1.0f >= radius) {
            result2.lineTo(xs, radius + ys);
        }
        result2.quadTo(xs + radius3, ys + radius3, xs + radius, ys);
        return result2;
    }
}

