/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.table.JTableHeader;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.SubstanceWidgetRepository;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceTableHeaderUI;
import org.pushingpixels.substance.internal.ui.SubstanceTreeUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollPaneBorder;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class SubstanceScrollPaneUI
extends BasicScrollPaneUI {
    protected PropertyChangeListener substancePropertyChangeListener;
    protected ChangeListener substanceVerticalScrollbarChangeListener;
    protected Timeline horizontalScrollTimeline;
    private Set<SubstanceWidget> lafWidgets;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceScrollPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.lafWidgets = SubstanceWidgetRepository.getRepository().getMatchingWidgets(c);
        super.installUI(c);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
        super.uninstallUI(c);
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        if (SubstanceCoreUtilities.toDrawWatermark(scrollpane) && SubstanceCortex.ComponentScope.getCurrentSkin(scrollpane).getWatermark() != null) {
            scrollpane.setOpaque(false);
            scrollpane.getViewport().setOpaque(false);
        }
        SwingUtilities.invokeLater(() -> SubstanceScrollPaneUI.installTableHeaderCornerFiller(scrollpane));
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane c) {
        Component upperLeft;
        Component upperRight = c.getCorner("UPPER_RIGHT_CORNER");
        if (upperRight instanceof UIResource) {
            c.setCorner("UPPER_RIGHT_CORNER", null);
        }
        if ((upperLeft = c.getCorner("UPPER_LEFT_CORNER")) instanceof UIResource) {
            c.setCorner("UPPER_LEFT_CORNER", null);
        }
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
        super.uninstallDefaults(c);
    }

    @Override
    protected void installListeners(final JScrollPane c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = evt -> {
            Color newBackgr;
            if ("substancelaf.internal.watermarkVisible".equals(evt.getPropertyName())) {
                boolean toBleed = SubstanceCoreUtilities.toDrawWatermark(c);
                c.setOpaque(!toBleed);
                c.getViewport().setOpaque(!toBleed);
                Component view = c.getViewport().getView();
                if (view instanceof JComponent) {
                    ((JComponent)view).setOpaque(!toBleed);
                }
            }
            if ("background".equals(evt.getPropertyName()) && !((newBackgr = (Color)evt.getNewValue()) instanceof UIResource)) {
                JScrollBar horizontal;
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (vertical != null && vertical.getBackground() instanceof UIResource) {
                    vertical.setBackground(newBackgr);
                }
                if ((horizontal = this.scrollpane.getHorizontalScrollBar()) != null && horizontal.getBackground() instanceof UIResource) {
                    horizontal.setBackground(newBackgr);
                }
            }
            if ("columnHeader".equals(evt.getPropertyName()) || "componentOrientation".equals(evt.getPropertyName()) || "ancestor".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.scrollpane != null) {
                        SubstanceScrollPaneUI.installTableHeaderCornerFiller(this.scrollpane);
                    }
                });
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceVerticalScrollbarChangeListener = e -> {
            if (c.getHorizontalScrollBar() != null && c.getHorizontalScrollBar().isVisible() && c.getViewport().getView() instanceof JTree) {
                JTree tree = (JTree)c.getViewport().getView();
                if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.TREE_SMART_SCROLL_ANIMATION_KIND, tree)) {
                    int finalDelta;
                    int currPivotX;
                    Rectangle viewportRect;
                    SubstanceTreeUI treeUI = (SubstanceTreeUI)tree.getUI();
                    int pivotX = treeUI.getPivotRendererX(viewportRect = c.getViewport().getViewRect());
                    int delta = pivotX - (currPivotX = viewportRect.x);
                    int finalX = viewportRect.x + delta;
                    if (finalX < 0) {
                        delta -= finalX;
                    }
                    if (Math.abs(finalDelta = delta) > viewportRect.width / 6) {
                        if (this.horizontalScrollTimeline != null) {
                            this.horizontalScrollTimeline.abort();
                        }
                        this.horizontalScrollTimeline = new Timeline(tree);
                        this.horizontalScrollTimeline.addCallback(new UIThreadTimelineCallbackAdapter(){

                            @Override
                            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                                if ((double)timelinePosition >= 0.5) {
                                    int nudge = (int)((double)finalDelta * ((double)timelinePosition - 0.5));
                                    c.getViewport().setViewPosition(new Point(viewportRect.x + nudge, viewportRect.y));
                                }
                            }
                        });
                        this.horizontalScrollTimeline.setEase(durationFraction -> {
                            if ((double)durationFraction < 0.5) {
                                return 0.5f * durationFraction;
                            }
                            return 0.25f + (durationFraction - 0.5f) * 0.75f / 0.5f;
                        });
                        AnimationConfigurationManager.getInstance().configureTimeline(this.horizontalScrollTimeline);
                        this.horizontalScrollTimeline.setDuration(2L * this.horizontalScrollTimeline.getDuration());
                        this.horizontalScrollTimeline.play();
                    }
                }
            }
        };
        c.getVerticalScrollBar().getModel().addChangeListener(this.substanceVerticalScrollbarChangeListener);
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        JScrollPane jsp = (JScrollPane)c;
        jsp.getVerticalScrollBar().getModel().removeChangeListener(this.substanceVerticalScrollbarChangeListener);
        this.substanceVerticalScrollbarChangeListener = null;
        for (SubstanceWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
        super.uninstallListeners(c);
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        BackgroundPaintingUtils.updateIfOpaque(g2, c);
        JScrollPane jsp = (JScrollPane)c;
        LayoutManager lm = jsp.getLayout();
        ScrollPaneLayout scrollLm = null;
        if (lm instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)lm;
        }
        if (scrollLm != null) {
            HashSet<Component> corners = new HashSet<Component>();
            if (scrollLm.getCorner("LOWER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("LOWER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_RIGHT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_RIGHT_CORNER"));
            }
            if (SubstanceCoreUtilities.isOpaque(c)) {
                Graphics2D g2d = (Graphics2D)g2.create();
                g2d.setColor(SubstanceColorUtilities.getBackgroundFillColorScrollBar(this.scrollpane.getVerticalScrollBar()));
                for (Component corner : corners) {
                    g2d.fill(corner.getBounds());
                }
                JScrollBar horizontal = this.scrollpane.getHorizontalScrollBar();
                JScrollBar vertical = this.scrollpane.getVerticalScrollBar();
                if (horizontal != null && vertical != null) {
                    if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
                        if (scrollLm.getCorner("LOWER_RIGHT_CORNER") == null) {
                            g2d.fillRect(horizontal.getX() + horizontal.getWidth(), horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                        }
                    } else if (scrollLm.getCorner("LOWER_LEFT_CORNER") == null) {
                        g2d.fillRect(0, horizontal.getY(), vertical.getWidth(), horizontal.getHeight());
                    }
                }
            }
        }
        super.paint(g2, c);
    }

    protected static void installTableHeaderCornerFiller(JScrollPane scrollpane) {
        boolean canReplace;
        JViewport columnHeader = scrollpane.getColumnHeader();
        if (columnHeader == null) {
            return;
        }
        Component columnHeaderComp = columnHeader.getView();
        if (!(columnHeaderComp instanceof JTableHeader)) {
            return;
        }
        JTableHeader tableHeader = (JTableHeader)columnHeaderComp;
        TableHeaderUI tableHeaderUI = tableHeader.getUI();
        if (!(tableHeaderUI instanceof SubstanceTableHeaderUI)) {
            return;
        }
        SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)tableHeaderUI;
        JComponent scrollPaneCornerFiller = ui.getScrollPaneCornerFiller();
        String cornerKey = scrollpane.getComponentOrientation().isLeftToRight() ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        Component cornerComp = scrollpane.getCorner(cornerKey);
        boolean bl = canReplace = cornerComp == null || cornerComp instanceof UIResource;
        if (canReplace) {
            scrollpane.setCorner(cornerKey, scrollPaneCornerFiller);
        }
    }

    protected static class AdjustedLayout
    extends ScrollPaneLayout
    implements UIResource {
        protected ScrollPaneLayout delegate;

        public AdjustedLayout(ScrollPaneLayout delegate) {
            this.delegate = delegate;
        }

        @Override
        public void addLayoutComponent(String s2, Component c) {
            this.delegate.addLayoutComponent(s2, c);
        }

        public boolean equals(Object obj2) {
            return this.delegate.equals(obj2);
        }

        @Override
        public JViewport getColumnHeader() {
            return this.delegate.getColumnHeader();
        }

        @Override
        public Component getCorner(String key) {
            return this.delegate.getCorner(key);
        }

        @Override
        public JScrollBar getHorizontalScrollBar() {
            return this.delegate.getHorizontalScrollBar();
        }

        @Override
        public int getHorizontalScrollBarPolicy() {
            return this.delegate.getHorizontalScrollBarPolicy();
        }

        @Override
        public JViewport getRowHeader() {
            return this.delegate.getRowHeader();
        }

        @Override
        public JScrollBar getVerticalScrollBar() {
            return this.delegate.getVerticalScrollBar();
        }

        @Override
        public int getVerticalScrollBarPolicy() {
            return this.delegate.getVerticalScrollBarPolicy();
        }

        @Override
        public JViewport getViewport() {
            return this.delegate.getViewport();
        }

        @Override
        public Rectangle getViewportBorderBounds(JScrollPane scrollpane) {
            return this.delegate.getViewportBorderBounds(scrollpane);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.delegate.minimumLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.delegate.preferredLayoutSize(parent);
        }

        @Override
        public void removeLayoutComponent(Component c) {
            this.delegate.removeLayoutComponent(c);
        }

        @Override
        public void setHorizontalScrollBarPolicy(int x) {
            this.delegate.setHorizontalScrollBarPolicy(x);
        }

        @Override
        public void setVerticalScrollBarPolicy(int x) {
            this.delegate.setVerticalScrollBarPolicy(x);
        }

        @Override
        public void syncWithScrollPane(JScrollPane sp) {
            this.delegate.syncWithScrollPane(sp);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void layoutContainer(Container parent) {
            this.delegate.layoutContainer(parent);
            JScrollPane scrollPane = (JScrollPane)parent;
            Border border = scrollPane.getBorder();
            boolean toAdjust = border instanceof SubstanceScrollPaneBorder;
            if (toAdjust) {
                Rectangle hBounds;
                Rectangle vBounds;
                JScrollBar vertical = scrollPane.getVerticalScrollBar();
                JScrollBar horizontal = scrollPane.getHorizontalScrollBar();
                int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth() / 2.0);
                int borderWidth = (int)SubstanceSizeUtils.getBorderStrokeWidth();
                int dx = 0;
                int dy = 0;
                int dw = 0;
                int dh = 0;
                if (scrollPane.getComponentOrientation().isLeftToRight()) {
                    if (vertical != null && vertical.isVisible()) {
                        vBounds = vertical.getBounds();
                        dw += 1 + borderDelta;
                        vertical.setBounds(vBounds.x + 1 + borderDelta, vBounds.y + 1 - 2 * borderWidth, vBounds.width, vBounds.height + 2 * borderWidth);
                    }
                    if (horizontal != null && horizontal.isVisible()) {
                        dh += 1 + borderDelta;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x + (scrollPane.getRowHeader() == null ? 1 : 2) - 2 * borderWidth, hBounds.y + 1, hBounds.width + 2 * borderWidth, hBounds.height);
                    }
                    if (this.delegate.getCorner("LOWER_RIGHT_CORNER") != null) {
                        Rectangle lrBounds = this.delegate.getCorner("LOWER_RIGHT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_RIGHT_CORNER").setBounds(lrBounds.x + 1 + borderDelta, lrBounds.y + 1 + borderDelta, lrBounds.width, lrBounds.height);
                    }
                    if (this.delegate.getCorner("UPPER_RIGHT_CORNER") != null) {
                        Rectangle urBounds = this.delegate.getCorner("UPPER_RIGHT_CORNER").getBounds();
                        this.delegate.getCorner("UPPER_RIGHT_CORNER").setBounds(urBounds.x + 1 + borderDelta, urBounds.y + borderDelta, urBounds.width - 1, urBounds.height);
                    }
                } else {
                    if (vertical != null && vertical.isVisible()) {
                        dx -= 1 + borderDelta;
                        dw += 1 + borderDelta;
                        vBounds = vertical.getBounds();
                        vertical.setBounds(vBounds.x - 1 - borderDelta, vBounds.y - 1 - borderDelta, vBounds.width, vBounds.height + 2 * borderWidth);
                    }
                    if (horizontal != null && horizontal.isVisible()) {
                        dh += 1 + borderDelta;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x - (scrollPane.getRowHeader() == null ? 1 : 2) - borderDelta, hBounds.y + 1 + borderDelta, hBounds.width + 2 * borderWidth, hBounds.height);
                    }
                    if (this.delegate.getCorner("LOWER_LEFT_CORNER") != null) {
                        Rectangle llBounds = this.delegate.getCorner("LOWER_LEFT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_LEFT_CORNER").setBounds(llBounds.x - 1 - borderDelta, llBounds.y - 1 - borderDelta, llBounds.width, llBounds.height);
                    }
                    if (this.delegate.getCorner("UPPER_LEFT_CORNER") != null) {
                        Rectangle ulBounds = this.delegate.getCorner("UPPER_LEFT_CORNER").getBounds();
                        this.delegate.getCorner("UPPER_LEFT_CORNER").setBounds(ulBounds.x - borderDelta, ulBounds.y - borderDelta, ulBounds.width - 1, ulBounds.height);
                    }
                }
                if (this.delegate.getViewport() != null) {
                    Rectangle vpBounds = this.delegate.getViewport().getBounds();
                    this.delegate.getViewport().setBounds(new Rectangle(vpBounds.x + dx, vpBounds.y + dy, vpBounds.width + dw, vpBounds.height + dh));
                }
                if (this.delegate.getColumnHeader() != null) {
                    Rectangle columnHeaderBounds = this.delegate.getColumnHeader().getBounds();
                    this.delegate.getColumnHeader().setBounds(new Rectangle(columnHeaderBounds.x + dx, columnHeaderBounds.y + dy, columnHeaderBounds.width + dw, columnHeaderBounds.height));
                }
            }
        }
    }
}

