/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.IsHiDpiAware;
import org.pushingpixels.substance.api.icon.IsResizable;
import org.pushingpixels.substance.internal.contrib.intellij.JBHiDPIScaledImage;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.filters.ColorFilter;

public class SubstanceIcon
implements Icon,
IsResizable,
IsHiDpiAware {
    private final double factor;
    private final boolean isHiDpiAwareSource;
    private BufferedImage imageSource;
    private Icon iconSource;
    private int width;
    private int height;

    public SubstanceIcon(BufferedImage image) {
        this.imageSource = image;
        this.factor = UIUtil.getScaleFactor();
        this.isHiDpiAwareSource = image instanceof JBHiDPIScaledImage;
        this.width = this.getInternalWidth();
        this.height = this.getInternalHeight();
    }

    public SubstanceIcon(Icon icon) {
        if (icon instanceof SubstanceIcon) {
            throw new IllegalArgumentException("Can't wrap another instance of SubstanceIcon");
        }
        this.iconSource = icon;
        this.factor = UIUtil.getScaleFactor();
        this.isHiDpiAwareSource = icon instanceof IsHiDpiAware && ((IsHiDpiAware)((Object)icon)).isHiDpiAware();
        this.width = this.getInternalWidth();
        this.height = this.getInternalHeight();
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public boolean isHiDpiAware() {
        return this.isHiDpiAwareSource;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g2, int x, int y) {
        Graphics2D g2d = (Graphics2D)g2.create();
        int dx = (this.width - this.getInternalWidth()) / 2;
        int dy = (this.height - this.getInternalHeight()) / 2;
        g2d.translate(x + dx, y + dy);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (this.imageSource != null) {
            g2d.drawImage(this.imageSource, 0, 0, (int)((double)this.imageSource.getWidth() / this.factor), (int)((double)this.imageSource.getHeight() / this.factor), null);
        } else if (this.iconSource != null) {
            this.iconSource.paintIcon(c, g2d, 0, 0);
        }
        g2d.dispose();
    }

    private int getInternalWidth() {
        if (this.imageSource != null) {
            return (int)((double)this.imageSource.getWidth() / this.factor);
        }
        if (this.iconSource != null) {
            return (int)((double)this.iconSource.getIconWidth() / (this.isHiDpiAwareSource ? 1.0 : this.factor));
        }
        return 0;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    private int getInternalHeight() {
        if (this.imageSource != null) {
            return (int)((double)this.imageSource.getHeight() / this.factor);
        }
        if (this.iconSource != null) {
            return (int)((double)this.iconSource.getIconHeight() / (this.isHiDpiAwareSource ? 1.0 : this.factor));
        }
        return 0;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public BufferedImage toImage() {
        BufferedImage result2 = SubstanceCoreUtilities.getBlankImage(this.getIconWidth(), this.getIconHeight());
        this.paintIcon(null, result2.getGraphics(), 0, 0);
        return result2;
    }

    public SubstanceIcon colorize(Color color) {
        return new SubstanceIcon(new ColorFilter(color).filter(this.toImage(), null));
    }

    public SubstanceIcon colorize(Color color, float alpha) {
        return new SubstanceIcon(new ColorFilter(SubstanceColorUtilities.getAlphaColor(color, (int)(alpha * 255.0f))).filter(this.toImage(), null));
    }

    public SubstanceIcon colorize(SubstanceColorScheme colorScheme) {
        float brightnessFactor = colorScheme.isDark() ? 0.2f : 0.8f;
        return new SubstanceIcon(SubstanceImageCreator.getColorSchemeImage(null, this, colorScheme, brightnessFactor));
    }

    public SubstanceIcon colorize(SubstanceColorScheme colorScheme, float brightnessFactor) {
        return new SubstanceIcon(SubstanceImageCreator.getColorSchemeImage(null, this, colorScheme, brightnessFactor));
    }
}

