/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.CondVar;

public class Promise<T> {
    protected final Lock lock = new ReentrantLock();
    protected final CondVar cond = new CondVar(this.lock);
    protected T result;
    protected volatile boolean hasResult = false;

    public T getResultWithTimeout(long timeout2) throws TimeoutException {
        return this._getResultWithTimeout(timeout2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResultWithTimeout(long timeout2, boolean reset) throws TimeoutException {
        if (!reset) {
            return this._getResultWithTimeout(timeout2);
        }
        this.lock.lock();
        try {
            T t = this._getResultWithTimeout(timeout2);
            return t;
        }
        finally {
            this.reset();
            this.lock.unlock();
        }
    }

    public T getResult() {
        try {
            return this.getResultWithTimeout(0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public T getResult(long timeout2) {
        return this.getResult(timeout2, false);
    }

    public T getResult(long timeout2, boolean reset) {
        try {
            return this.getResultWithTimeout(timeout2, reset);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public boolean hasResult() {
        this.lock.lock();
        try {
            boolean bl = this.hasResult;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setResult(T obj2) {
        this.lock.lock();
        try {
            this.result = obj2;
            this.hasResult = true;
            this.cond.signal(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean signal) {
        this.lock.lock();
        try {
            this.result = null;
            this.hasResult = false;
            if (signal) {
                this.cond.signal(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("hasResult=%b, result=%s", this.hasResult, this.result);
    }

    protected T _getResultWithTimeout(long timeout2) throws TimeoutException {
        if (timeout2 <= 0L) {
            this.cond.waitFor(this::hasResult);
        } else if (!this.cond.waitFor(this::hasResult, timeout2, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
        return this.result;
    }
}

