/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.Log;
import org.jgroups.util.Runner;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class DiagnosticsHandler
extends ReceiverAdapter
implements Closeable {
    public static final String UDP_THREAD_NAME = "UdpDiagHandler";
    public static final String TCP_THREAD_NAME = "TcpDiagHandler";
    @Property(description="Switch to enable diagnostic probing")
    protected boolean enabled = true;
    @Property(description="Use a multicast socket to listen for probe requests (ignored if diag.enabled is false)")
    protected volatile boolean enable_udp = true;
    @Property(description="Use a TCP socket to listen for probe requests (ignored if diag.enabled is false)")
    protected volatile boolean enable_tcp;
    @Property(description="Multicast address for diagnostic probing (UDP MulticastSocket). Used when enable_udp is true", defaultValueIPv4="224.0.75.75", defaultValueIPv6="ff0e::0:75:75")
    protected InetAddress mcast_addr;
    @Property(description="Port for diagnostic probing. Default is 7500")
    protected int port = 7500;
    @Property(description="Bind address for diagnostic probing, to bind the TCP socket. Used when enable_tcp is true")
    protected InetAddress bind_addr;
    @Property(description="The number of ports to be probed for an available port (TCP)")
    protected int port_range = 50;
    @Property(description="TTL of the diagnostics multicast socket")
    protected int ttl = 8;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addrs or interface names) that the multicast socket should bind to")
    protected List<NetworkInterface> bind_interfaces;
    @Property(description="Authorization passcode for diagnostics. If specified every probe query will be authorized")
    protected String passcode;
    protected ServerSocket srv_sock;
    protected Runner udp_runner;
    protected Runner tcp_runner;
    protected MulticastSocket udp_mcast_sock;
    protected DatagramSocket udp_ucast_sock;
    protected final Set<ProbeHandler> handlers = new CopyOnWriteArraySet<ProbeHandler>();
    protected final Log log;
    protected final SocketFactory socket_factory;
    protected final ThreadFactory thread_factory;
    protected Function<Boolean, String> print_headers = b -> "";
    protected Function<String, Boolean> same_cluster = b -> true;
    protected final BiConsumer<SocketAddress, String> udp_response_sender = (sender, response) -> this.sendResponse(this.udp_ucast_sock, (SocketAddress)sender, response.getBytes());

    public DiagnosticsHandler printHeaders(Function<Boolean, String> f) {
        this.print_headers = Objects.requireNonNull(f);
        return this;
    }

    public DiagnosticsHandler sameCluster(Function<String, Boolean> f) {
        this.same_cluster = Objects.requireNonNull(f);
        return this;
    }

    public DiagnosticsHandler(Log log, SocketFactory socket_factory, ThreadFactory thread_factory) {
        this.log = log;
        this.socket_factory = socket_factory;
        this.thread_factory = thread_factory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DiagnosticsHandler setEnabled(boolean f) {
        this.enabled = f;
        return this;
    }

    public DiagnosticsHandler setMcastAddress(InetAddress a) {
        this.mcast_addr = a;
        return this;
    }

    public InetAddress getMcastAddress() {
        return this.mcast_addr;
    }

    public DiagnosticsHandler setBindAddress(InetAddress a) {
        this.bind_addr = a;
        return this;
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public boolean udpEnabled() {
        return this.enable_udp;
    }

    public DiagnosticsHandler enableUdp(boolean f) {
        this.enable_udp = f;
        if (f) {
            this.enabled = f;
        }
        return this;
    }

    public boolean tcpEnabled() {
        return this.enable_tcp;
    }

    public DiagnosticsHandler enableTcp(boolean f) {
        this.enable_tcp = f;
        if (f) {
            this.enabled = f;
        }
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public DiagnosticsHandler setPort(int p) {
        this.port = p;
        return this;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public DiagnosticsHandler setPortRange(int r) {
        this.port_range = r;
        return this;
    }

    public int getTtl() {
        return this.ttl;
    }

    public DiagnosticsHandler setTtl(int d) {
        this.ttl = d;
        return this;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public DiagnosticsHandler setPasscode(String d) {
        this.passcode = d;
        return this;
    }

    public List<NetworkInterface> getBindInterfaces() {
        return this.bind_interfaces;
    }

    public DiagnosticsHandler setBindInterfaces(List<NetworkInterface> l) {
        this.bind_interfaces = l;
        return this;
    }

    public DiagnosticsHandler setThreadNames() {
        Thread tmp;
        if (this.udp_runner != null && (tmp = this.udp_runner.getThread()) != null) {
            this.thread_factory.renameThread(UDP_THREAD_NAME, tmp);
        }
        if (this.tcp_runner != null && this.tcp_runner.isRunning() && (tmp = this.tcp_runner.getThread()) != null) {
            this.thread_factory.renameThread(TCP_THREAD_NAME, tmp);
        }
        return this;
    }

    public DiagnosticsHandler unsetThreadNames() {
        if (this.udp_runner != null) {
            this.udp_runner.threadName(UDP_THREAD_NAME);
        }
        if (this.tcp_runner != null) {
            this.tcp_runner.threadName(TCP_THREAD_NAME);
        }
        return this;
    }

    public Set<ProbeHandler> getProbeHandlers() {
        return this.handlers;
    }

    public DiagnosticsHandler registerProbeHandler(ProbeHandler handler) {
        this.handlers.add(Objects.requireNonNull(handler));
        return this;
    }

    public DiagnosticsHandler unregisterProbeHandler(ProbeHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
        return this;
    }

    public DiagnosticsHandler start() throws Exception {
        if (!this.enabled) {
            return this;
        }
        if (!this.enable_udp && !this.enable_tcp) {
            throw new IllegalStateException("both UDP and TCP are disabled - enable at least 1 of them");
        }
        if (this.enable_udp) {
            this.startUDP();
        }
        if (this.enable_tcp) {
            this.startTCP();
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public DiagnosticsHandler stop() {
        Util.close(this.udp_runner, this.tcp_runner);
        return this;
    }

    @ManagedAttribute(description="Is the diagnostics handler running?")
    public boolean isRunning() {
        return this.udp_runner != null && this.udp_runner.isRunning() || this.tcp_runner != null && this.tcp_runner.isRunning();
    }

    protected void runUDP() {
        byte[] buf = new byte[10000];
        DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
        try {
            this.udp_mcast_sock.receive(packet);
            int payloadStartOffset = 0;
            if (this.passcode != null) {
                payloadStartOffset = this.authorizeProbeRequest(packet);
            }
            this.handleDiagnosticProbe(packet.getSocketAddress(), new String(packet.getData(), packet.getOffset() + payloadStartOffset, packet.getLength()), this.udp_response_sender);
        }
        catch (IOException payloadStartOffset) {
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("FailureHandlingDiagnosticsRequest"), e);
        }
    }

    protected void runTCP() {
        SocketAddress sender = null;
        try (Socket client_sock2 = this.srv_sock.accept();
             InputStream input = client_sock2.getInputStream();
             OutputStream output = client_sock2.getOutputStream();){
            sender = client_sock2.getRemoteSocketAddress();
            String request = Util.readLine(input);
            this.handleDiagnosticProbe(sender, request, (snd, response) -> {
                try {
                    output.write(response.getBytes());
                }
                catch (IOException e) {
                    this.log.error("failed handling TCP probe request: %s", e.getMessage());
                }
            });
        }
        catch (SocketException client_sock2) {
        }
        catch (Throwable t) {
            this.log.error("failed processing TCP client request from %s: %s", sender, t);
        }
    }

    protected DiagnosticsHandler startUDP() throws Exception {
        if (this.udp_ucast_sock == null || this.udp_ucast_sock.isClosed()) {
            this.udp_ucast_sock = this.socket_factory.createDatagramSocket("jgroups.tp.diag.udp_ucast_sock");
        }
        if (this.udp_mcast_sock == null || this.udp_mcast_sock.isClosed()) {
            this.udp_mcast_sock = Util.can_bind_to_mcast_addr ? Util.createMulticastSocket(this.socket_factory, "jgroups.tp.diag.udp_mcast_sock", this.mcast_addr, this.port, this.log) : this.socket_factory.createMulticastSocket("jgroups.tp.diag.udp_mcast_sock", this.port);
            try {
                this.udp_mcast_sock.setTimeToLive(this.ttl);
            }
            catch (Exception ex) {
                this.log.error("failed setting TTL %d in MulticastSocket: %s", this.ttl, ex.getMessage());
            }
            List<NetworkInterface> interfaces = this.bind_interfaces != null ? this.bind_interfaces : Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.udp_mcast_sock);
        }
        if (this.udp_runner == null) {
            this.udp_runner = new Runner(this.thread_factory, UDP_THREAD_NAME, this::runUDP, () -> Util.close(this.udp_mcast_sock, this.udp_ucast_sock)).daemon(true);
        }
        this.udp_runner.start();
        return this;
    }

    protected DiagnosticsHandler startTCP() throws Exception {
        if (this.srv_sock == null || this.srv_sock.isClosed()) {
            this.srv_sock = Util.createServerSocket(this.socket_factory, "jgroups.tp.diag.tcp_sock", this.bind_addr, this.port, this.port + this.port_range, 0);
        }
        if (this.tcp_runner == null) {
            this.tcp_runner = new Runner(this.thread_factory, TCP_THREAD_NAME, this::runTCP, () -> Util.close((Closeable)this.srv_sock));
        }
        this.tcp_runner.start();
        return this;
    }

    protected void handleDiagnosticProbe(SocketAddress sender, String request, BiConsumer<SocketAddress, String> rsp_sender) {
        StringTokenizer tok = new StringTokenizer(request);
        ArrayList<String> list = new ArrayList<String>(10);
        while (tok.hasMoreTokens()) {
            String req = tok.nextToken().trim();
            if (req.isEmpty()) continue;
            if (req.startsWith("cluster=")) {
                if (this.same_cluster.apply(req).booleanValue()) continue;
                this.log.debug("probe response dropped as cluster %s does not match", req.substring("cluster=".length()));
                return;
            }
            list.add(req);
        }
        if (list.isEmpty()) {
            String default_rsp = this.print_headers.apply(true);
            rsp_sender.accept(sender, default_rsp);
            return;
        }
        String[] tokens = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tokens[i] = (String)list.get(i);
        }
        for (ProbeHandler handler : this.handlers) {
            Map<String, String> map2 = null;
            try {
                map2 = handler.handleProbe(tokens);
            }
            catch (IllegalArgumentException ex) {
                this.log.warn(ex.getMessage());
                return;
            }
            if (map2 == null || map2.isEmpty()) continue;
            String tmp = this.print_headers.apply(false);
            StringBuilder info = new StringBuilder(tmp);
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                info.append(String.format("%s=%s\r\n", entry.getKey(), entry.getValue()));
            }
            String diag_rsp = info.toString();
            rsp_sender.accept(sender, diag_rsp);
        }
    }

    protected int authorizeProbeRequest(DatagramPacket packet) throws Exception {
        int offset = 0;
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.getData());
        DataInputStream in = new DataInputStream(bis);
        long t1 = in.readLong();
        double q1 = in.readDouble();
        int length = in.readInt();
        byte[] digest = new byte[length];
        in.readFully(digest);
        offset = 20 + digest.length;
        byte[] local = Util.createDigest(this.passcode, t1, q1);
        if (!MessageDigest.isEqual(digest, local)) {
            throw new Exception("Authorization failed! Make sure correct passcode is used");
        }
        return offset;
    }

    protected void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) {
        try {
            DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
            sock.send(p);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedSendingDiagRspTo") + sender, t);
        }
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s2) {
        InetSocketAddress group_addr = new InetSocketAddress(this.mcast_addr, this.port);
        for (NetworkInterface i : interfaces) {
            try {
                List<InterfaceAddress> inet_addrs;
                if (!Util.isUp(i) || (inet_addrs = i.getInterfaceAddresses()) == null || inet_addrs.isEmpty()) continue;
                s2.joinGroup(group_addr, i);
                this.log.trace("joined %s on %s", group_addr, i.getName());
            }
            catch (Exception e) {
                this.log.warn("failed to join " + group_addr + " on " + i.getName() + ": " + e);
            }
        }
    }

    public static interface ProbeHandler {
        public Map<String, String> handleProbe(String ... var1);

        public String[] supportedKeys();
    }
}

