/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.XmlElement;
import org.jgroups.annotations.XmlInclude;
import org.jgroups.conf.AttributeType;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.XmlNode;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteMasterPicker;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@XmlInclude(schema={"relay.xsd"}, type=XmlInclude.Type.IMPORT, namespace="urn:jgroups:relay:1.0", alias="relay")
@XmlElement(name="RelayConfiguration", type="relay:RelayConfigurationType")
@MBean(description="RELAY2 protocol")
public class RELAY2
extends Protocol {
    public static final short site_master_flag = 1;
    public static final short can_become_site_master_flag = 2;
    @Property(description="Name of the site (needs to be defined in the configuration)", writable=false)
    protected String site;
    @Property(description="Name of the relay configuration", writable=false)
    protected String config;
    @Property(description="Whether or not this node can become the site master. If false, and we become the coordinator, we won't start the bridge(s)", writable=false)
    protected boolean can_become_site_master = true;
    @Property(description="Maximum number of site masters. Setting this to a value greater than 1 means that we can have multiple site masters. If the value is greater than the number of cluster nodes, everyone in the site will be a site master (and thus join the global cluster", writable=false)
    protected int max_site_masters = 1;
    @Property(description="Ratio of members that are site masters, out of range [0..1] (0 disables this). The number of site masters is computes as Math.min(max_site_masters, view.size() * site_masters_ratio). See https://issues.redhat.com/browse/JGRP-2581 for details")
    protected double site_masters_ratio;
    @Property(description="Whether or not we generate our own addresses in which we use can_become_site_master. If this property is false, can_become_site_master is ignored")
    protected boolean enable_address_tagging;
    @Property(description="Whether or not to relay multicast (dest=null) messages")
    protected boolean relay_multicasts = true;
    @Property(description="If true, the creation of the relay channel (and the connect()) are done in the background. Async relay creation is recommended, so the view callback won't be blocked")
    protected boolean async_relay_creation = true;
    @Property(description="Fully qualified name of a class implementing SiteMasterPicker")
    protected String site_master_picker_impl;
    @Property(description="Time during which identical errors about no route to host will be suppressed. 0 disables this (every error will be logged).", type=AttributeType.TIME)
    protected long suppress_time_no_route_errors = 60000L;
    protected final Map<String, RelayConfig.SiteConfig> sites = new HashMap<String, RelayConfig.SiteConfig>();
    protected RelayConfig.SiteConfig site_config;
    @ManagedAttribute(description="Whether this member is a site master")
    protected volatile boolean is_site_master;
    @ManagedAttribute(description="The first of all site masters broadcasts route-up/down messages to all members of the local cluster")
    protected volatile boolean broadcast_route_notifications;
    @ManagedAttribute(description="The current site masters")
    protected volatile List<Address> site_masters;
    protected SiteMasterPicker site_master_picker;
    protected Consumer<Boolean> site_master_listener;
    protected volatile Relayer relayer;
    protected TimeScheduler timer;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    @Property(description="If true, a site master forwards messages received from other sites to randomly chosen members of the local site for load balancing, reducing work for itself")
    protected boolean can_forward_local_cluster;
    @Property(description="Number of millis to wait for topology detection", type=AttributeType.TIME)
    protected long topo_wait_time = 2000L;
    protected short[] prots_above;
    protected volatile RouteStatusListener route_status_listener;
    protected final LongAdder forward_to_site_master = new LongAdder();
    protected final LongAdder forward_sm_time = new LongAdder();
    protected final LongAdder relayed = new LongAdder();
    protected final LongAdder relayed_time = new LongAdder();
    protected final LongAdder forward_to_local_mbr = new LongAdder();
    protected final LongAdder forward_to_local_mbr_time = new LongAdder();
    protected final LongAdder local_deliveries = new LongAdder();
    protected final LongAdder local_delivery_time = new LongAdder();
    protected final ResponseCollector<String> topo_collector = new ResponseCollector();
    protected SuppressLog<String> suppress_log_no_route;

    public RELAY2 site(String site_name) {
        this.site = site_name;
        return this;
    }

    public RELAY2 config(String cfg) {
        this.config = cfg;
        return this;
    }

    public RELAY2 canBecomeSiteMaster(boolean flag) {
        this.can_become_site_master = flag;
        return this;
    }

    public RELAY2 enableAddressTagging(boolean flag) {
        this.enable_address_tagging = flag;
        return this;
    }

    public RELAY2 relayMulticasts(boolean flag) {
        this.relay_multicasts = flag;
        return this;
    }

    public RELAY2 asyncRelayCreation(boolean flag) {
        this.async_relay_creation = flag;
        return this;
    }

    public RELAY2 siteMasterPicker(SiteMasterPicker s2) {
        if (s2 != null) {
            this.site_master_picker = s2;
        }
        return this;
    }

    public String site() {
        return this.site;
    }

    public List<Address> siteMasters() {
        return this.site_masters;
    }

    public List<Address> members() {
        return this.members;
    }

    public List<String> siteNames() {
        return this.getSites();
    }

    public String config() {
        return this.config;
    }

    public boolean canBecomeSiteMaster() {
        return this.can_become_site_master;
    }

    public boolean enableAddressTagging() {
        return this.enable_address_tagging;
    }

    public boolean relayMulticasts() {
        return this.relay_multicasts;
    }

    public boolean asyncRelayCreation() {
        return this.async_relay_creation;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public void incrementRelayed() {
        this.relayed.increment();
    }

    public void addToRelayedTime(long delta) {
        this.relayed_time.add(delta);
    }

    public String getSite() {
        return this.site;
    }

    public RELAY2 setSite(String s2) {
        this.site = s2;
        return this;
    }

    public String getConfig() {
        return this.config;
    }

    public RELAY2 setConfig(String c) {
        this.config = c;
        return this;
    }

    public int getMaxSiteMasters() {
        return this.max_site_masters;
    }

    public RELAY2 setMaxSiteMasters(int m3) {
        this.max_site_masters = m3;
        return this;
    }

    public double getSiteMastersRatio() {
        return this.site_masters_ratio;
    }

    public RELAY2 setSiteMastersRatio(double r) {
        this.site_masters_ratio = r;
        return this;
    }

    public String getSiteMasterPickerImpl() {
        return this.site_master_picker_impl;
    }

    public RELAY2 setSiteMasterPickerImpl(String s2) {
        this.site_master_picker_impl = s2;
        return this;
    }

    public boolean broadcastRouteNotifications() {
        return this.broadcast_route_notifications;
    }

    public RELAY2 broadcastRouteNotifications(boolean b) {
        this.broadcast_route_notifications = b;
        return this;
    }

    public boolean canForwardLocalCluster() {
        return this.can_forward_local_cluster;
    }

    public RELAY2 canForwardLocalCluster(boolean c) {
        this.can_forward_local_cluster = c;
        return this;
    }

    public long getTopoWaitTime() {
        return this.topo_wait_time;
    }

    public RELAY2 setTopoWaitTime(long t) {
        this.topo_wait_time = t;
        return this;
    }

    public RouteStatusListener getRouteStatusListener() {
        return this.route_status_listener;
    }

    public void setRouteStatusListener(RouteStatusListener l) {
        this.route_status_listener = l;
    }

    public RELAY2 setSiteMasterListener(Consumer<Boolean> l) {
        this.site_master_listener = l;
        return this;
    }

    @ManagedAttribute(description="Number of messages forwarded to the local SiteMaster")
    public long getNumForwardedToSiteMaster() {
        return this.forward_to_site_master.sum();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to the local SiteMaster", type=AttributeType.TIME)
    public long getTimeForwardingToSM() {
        return TimeUnit.MILLISECONDS.convert(this.forward_sm_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to the local SiteMaster")
    public long getAvgMsgsForwardingToSM() {
        return this.getTimeForwardingToSM() > 0L ? (long)((double)this.getNumForwardedToSiteMaster() / ((double)this.getTimeForwardingToSM() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages sent by this SiteMaster to a remote SiteMaster")
    public long getNumRelayed() {
        return this.relayed.sum();
    }

    @ManagedAttribute(description="The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", type=AttributeType.TIME)
    public long getTimeRelaying() {
        return TimeUnit.MILLISECONDS.convert(this.relayed_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters")
    public long getAvgMsgsRelaying() {
        return this.getTimeRelaying() > 0L ? (long)((double)this.getNumRelayed() / ((double)this.getTimeRelaying() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node")
    public long getNumForwardedToLocalMbr() {
        return this.forward_to_local_mbr.sum();
    }

    @ManagedAttribute(description="The total time (in ms) spent forwarding messages to a member in the same site", type=AttributeType.TIME)
    public long getTimeForwardingToLocalMbr() {
        return TimeUnit.MILLISECONDS.convert(this.forward_to_local_mbr_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for forwarding messages to a member in the same site")
    public long getAvgMsgsForwardingToLocalMbr() {
        return this.getTimeForwardingToLocalMbr() > 0L ? (long)((double)this.getNumForwardedToLocalMbr() / ((double)this.getTimeForwardingToLocalMbr() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Number of messages delivered locally, e.g. received and delivered to self")
    public long getNumLocalDeliveries() {
        return this.local_deliveries.sum();
    }

    @ManagedAttribute(description="The total time (ms) spent delivering received messages locally", type=AttributeType.TIME)
    public long getTimeDeliveringLocally() {
        return TimeUnit.MILLISECONDS.convert(this.local_delivery_time.sum(), TimeUnit.NANOSECONDS);
    }

    @ManagedAttribute(description="The average number of messages / s for delivering received messages locally")
    public long getAvgMsgsDeliveringLocally() {
        return this.getTimeDeliveringLocally() > 0L ? (long)((double)this.getNumLocalDeliveries() / ((double)this.getTimeDeliveringLocally() / 1000.0)) : 0L;
    }

    @ManagedAttribute(description="Whether or not this instance is a site master")
    public boolean isSiteMaster() {
        return this.relayer != null;
    }

    @ManagedAttribute(description="Number of 'no route to site X' errors")
    public int getNumberOfNoRouteErrors() {
        return this.suppress_log_no_route != null ? this.suppress_log_no_route.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the 'no route to site X' cache")
    public RELAY2 clearNoRouteCache() {
        if (this.suppress_log_no_route != null) {
            this.suppress_log_no_route.getCache().clear();
        }
        return this;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.forward_to_site_master.reset();
        this.forward_sm_time.reset();
        this.relayed.reset();
        this.relayed_time.reset();
        this.forward_to_local_mbr.reset();
        this.forward_to_local_mbr_time.reset();
        this.local_deliveries.reset();
        this.local_delivery_time.reset();
        this.clearNoRouteCache();
    }

    public View getBridgeView(String cluster_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getBridgeView(cluster_name) : null;
    }

    public RELAY2 addSite(String site_name, RelayConfig.SiteConfig cfg) {
        this.sites.put(site_name, cfg);
        return this;
    }

    public List<String> getSites() {
        return this.sites.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.sites.keySet());
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.configure();
        if (this.site_master_picker == null) {
            this.site_master_picker = new SiteMasterPicker(){

                @Override
                public Address pickSiteMaster(List<Address> site_masters, Address original_sender) {
                    return Util.pickRandomElement(site_masters);
                }

                @Override
                public Route pickRoute(String site, List<Route> routes, Address original_sender) {
                    return Util.pickRandomElement(routes);
                }
            };
        }
        if (this.suppress_time_no_route_errors > 0L) {
            this.suppress_log_no_route = new SuppressLog(this.log, "RelayNoRouteToSite", "SuppressMsgRelay");
        }
    }

    public void configure() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (this.max_site_masters < 1) {
            this.log.warn("max_size_masters was " + this.max_site_masters + ", changed to 1");
            this.max_site_masters = 1;
        }
        if (this.site_masters_ratio < 0.0) {
            this.log.warn("%s: changing incorrect site_masters_ratio of %.2f to 0", this.local_addr, this.site_masters_ratio);
            this.site_masters_ratio = 0.0;
        } else if (this.site_masters_ratio > 1.0) {
            this.log.warn("%s: changing incorrect site_masters_ratio of %.2f to 1", this.local_addr, this.site_masters_ratio);
            this.site_masters_ratio = 1.0;
        }
        if (this.site_master_picker_impl != null) {
            Class<?> clazz = Util.loadClass(this.site_master_picker_impl, (Class)null);
            this.site_master_picker = (SiteMasterPicker)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (this.config != null) {
            this.parseSiteConfiguration(this.sites);
        }
        this.site_config = this.sites.get(this.site);
        if (this.site_config == null) {
            throw new Exception("site configuration for \"" + this.site + "\" not found in " + this.config);
        }
        this.log.trace("site configuration:\n" + this.site_config);
        if (!this.site_config.getForwards().isEmpty()) {
            this.log.warn(this.local_addr + ": forwarding routes are currently not supported and will be ignored. This will change with hierarchical routing (https://issues.jboss.org/browse/JGRP-1506)");
        }
        if (this.enable_address_tagging) {
            JChannel ch = this.getProtocolStack().getChannel();
            ch.addAddressGenerator(() -> {
                ExtendedUUID retval = ExtendedUUID.randomUUID();
                if (this.can_become_site_master) {
                    retval.setFlag((short)2);
                }
                return retval;
            });
        }
        this.prots_above = this.getIdsAbove();
    }

    @Override
    public void stop() {
        super.stop();
        this.is_site_master = false;
        this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
        if (this.relayer != null) {
            this.relayer.stop();
        }
    }

    protected void parseSiteConfiguration(Map<String, RelayConfig.SiteConfig> map2) throws Exception {
        try (InputStream input = ConfiguratorFactory.getConfigStream(this.config);){
            RelayConfig.parse(input, map2);
        }
    }

    @Override
    public void parse(XmlNode node) throws Exception {
        RelayConfig.parse(node, this.sites);
    }

    @ManagedOperation(description="Prints the contents of the routing table. Only available if we're the current coordinator (site master)")
    public String printRoutes() {
        return this.relayer != null ? this.relayer.printRoutes() : "n/a (not site master)";
    }

    @ManagedOperation(description="Prints the routes that are currently up. Only available if we're the current coordinator (site master)")
    public String printSites() {
        return this.relayer != null ? Util.print(this.relayer.getSiteNames()) : "n/a (not site master)";
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printTopology(boolean all_sites) {
        if (!all_sites) {
            return this.printLocalTopology();
        }
        if (this.relayer != null) {
            return this._printTopology(this.relayer);
        }
        Address site_master = this.site_masters != null && !this.site_masters.isEmpty() ? this.site_masters.get(0) : null;
        return site_master == null ? "not site-master" : this.fetchTopoFromSiteMaster(site_master);
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printLocalTopology() {
        StringBuilder sb = new StringBuilder(this.site).append("\n");
        for (Address mbr : this.members) {
            sb.append("  ").append(mbr);
            PhysicalAddress pa = this.getPhysicalAddress(mbr);
            if (pa != null) {
                sb.append(String.format(" (%s)", pa));
            }
            if (Objects.equals(mbr, this.local_addr)) {
                sb.append(" (me)");
            }
            if (this.site_masters.contains(mbr)) {
                sb.append(" // site master");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public JChannel getBridge(String site_name) {
        Relayer tmp = this.relayer;
        Route route = tmp != null ? tmp.getRoute(site_name) : null;
        return route != null ? route.bridge() : null;
    }

    public Route getRoute(String site_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getRoute(site_name) : null;
    }

    public List<String> getCurrentSites() {
        Relayer rel = this.relayer;
        return rel == null ? null : rel.getSiteNames();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        SiteUUID sender;
        Address dest = msg.getDest();
        if (!(dest instanceof SiteAddress)) {
            return this.down_prot.down(msg);
        }
        SiteAddress target = (SiteAddress)dest;
        Address src = msg.getSrc();
        SiteUUID siteUUID = sender = src instanceof SiteMaster ? new SiteMaster(((SiteMaster)src).getSite()) : new SiteUUID((UUID)this.local_addr, NameCache.get(this.local_addr), this.site);
        if (this.local_addr instanceof ExtendedUUID) {
            ((ExtendedUUID)sender).addContents((ExtendedUUID)this.local_addr);
        }
        if (target.getSite().equals(this.site)) {
            if (this.local_addr.equals(target) || target instanceof SiteMaster && this.is_site_master) {
                long start = this.stats ? System.nanoTime() : 0L;
                this.forwardTo(this.local_addr, target, sender, msg, false);
                if (this.stats) {
                    this.local_delivery_time.add(System.nanoTime() - start);
                    this.local_deliveries.increment();
                }
            } else {
                this.deliverLocally(target, sender, msg);
            }
            return null;
        }
        if (!this.is_site_master) {
            long start = this.stats ? System.nanoTime() : 0L;
            Address site_master = this.pickSiteMaster(sender);
            if (site_master == null) {
                throw new IllegalStateException("site master is null");
            }
            this.forwardTo(site_master, target, sender, msg, this.max_site_masters == 1);
            if (this.stats) {
                this.forward_sm_time.add(System.nanoTime() - start);
                this.forward_to_site_master.increment();
            }
        } else {
            this.route(target, sender, msg);
        }
        return null;
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
        Address dest = msg.getDest();
        if (hdr == null) {
            if (dest == null && this.is_site_master && this.relay_multicasts && !msg.isFlagSet(Message.Flag.NO_RELAY)) {
                Address src = msg.getSrc();
                SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), NameCache.get(msg.getSrc()), this.site);
                if (src instanceof ExtendedUUID) {
                    sender.addContents((ExtendedUUID)src);
                }
                this.sendToBridges(sender, msg, this.site);
            }
            return this.up_prot.up(msg);
        }
        if (this.handleAdminMessage(hdr, msg.src())) {
            return null;
        }
        if (dest != null) {
            this.handleMessage(hdr, msg);
        } else {
            this.deliver(null, hdr.original_sender, msg);
        }
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        ArrayList<SiteAddress> unreachable_sites = null;
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
            Address dest = msg.getDest();
            if (hdr == null) {
                if (dest != null || !this.is_site_master || !this.relay_multicasts || msg.isFlagSet(Message.Flag.NO_RELAY)) continue;
                Address src = msg.getSrc();
                SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), NameCache.get(msg.getSrc()), this.site);
                if (src instanceof ExtendedUUID) {
                    sender.addContents((ExtendedUUID)src);
                }
                this.sendToBridges(sender, msg, this.site);
                continue;
            }
            if (this.handleAdminMessage(hdr, batch.sender())) {
                it.remove();
                continue;
            }
            it.remove();
            if (dest != null) {
                if (hdr.getType() == 2) {
                    boolean contains;
                    SiteAddress site_addr = (SiteAddress)hdr.final_dest;
                    String site_name = site_addr.getSite();
                    if (unreachable_sites == null) {
                        unreachable_sites = new ArrayList<SiteAddress>();
                    }
                    if (contains = unreachable_sites.stream().anyMatch(sa -> sa.getSite().equals(site_name))) continue;
                    unreachable_sites.add(site_addr);
                    continue;
                }
                this.handleMessage(hdr, msg);
                continue;
            }
            this.deliver(null, hdr.original_sender, msg);
        }
        if (unreachable_sites != null) {
            for (SiteAddress sa2 : unreachable_sites) {
                this.triggerSiteUnreachableEvent(sa2);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected PhysicalAddress getPhysicalAddress(Address mbr) {
        return mbr != null ? (PhysicalAddress)this.down(new Event(87, mbr)) : null;
    }

    public void handleView(View view) {
        this.members = view.getMembers();
        int max_num_site_masters = this.max_site_masters;
        if (this.site_masters_ratio > 0.0) {
            max_num_site_masters = (int)Math.max((double)this.max_site_masters, this.site_masters_ratio * (double)view.size());
        }
        List<Address> old_site_masters = this.site_masters;
        List<Address> new_site_masters = this.determineSiteMasters(view, max_num_site_masters);
        boolean become_site_master = new_site_masters.contains(this.local_addr) && (old_site_masters == null || !old_site_masters.contains(this.local_addr));
        boolean cease_site_master = old_site_masters != null && old_site_masters.contains(this.local_addr) && !new_site_masters.contains(this.local_addr);
        this.site_masters = new_site_masters;
        if (!this.site_masters.isEmpty() && this.site_masters.get(0).equals(this.local_addr)) {
            this.broadcast_route_notifications = true;
        }
        if (become_site_master) {
            this.is_site_master = true;
            String bridge_name = "_" + NameCache.get(this.local_addr);
            if (this.relayer != null) {
                this.relayer.stop();
            }
            Relayer tmp = this.relayer = new Relayer(this, this.log);
            if (this.async_relay_creation) {
                this.timer.execute(() -> this.startRelayer(tmp, bridge_name));
            } else {
                this.startRelayer(this.relayer, bridge_name);
            }
            this.notifySiteMasterListener(true);
        } else if (cease_site_master) {
            this.is_site_master = false;
            this.notifySiteMasterListener(false);
            this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
        if (this.suppress_log_no_route != null) {
            this.suppress_log_no_route.removeExpired(this.suppress_time_no_route_errors);
        }
    }

    protected void handleRelayMessage(Relay2Header hdr, Message msg) {
        if (hdr.final_dest != null) {
            Message message = msg;
            Relay2Header header = hdr;
            if (header.type == 1 && this.can_forward_local_cluster) {
                SiteUUID site_uuid = (SiteUUID)hdr.final_dest;
                UUID tmp = (UUID)Util.pickRandomElement(this.members);
                SiteUUID final_dest = new SiteUUID(tmp, site_uuid.getName(), site_uuid.getSite());
                if (!((Object)final_dest).equals(hdr.final_dest)) {
                    message = this.copy(msg);
                    header = new Relay2Header(1, final_dest, hdr.original_sender);
                    message.putHeader(this.id, header);
                }
            }
            this.handleMessage(header, message);
        } else {
            Message copy2 = this.copy(msg).setDest(null).setSrc(null).putHeader(this.id, hdr);
            this.down_prot.down(copy2);
        }
    }

    protected boolean handleAdminMessage(Relay2Header hdr, Address sender) {
        switch (hdr.type) {
            case 4: 
            case 5: {
                if (this.route_status_listener != null) {
                    if (hdr.type == 4) {
                        this.route_status_listener.sitesUp(hdr.getSites());
                    } else {
                        this.route_status_listener.sitesDown(hdr.getSites());
                    }
                }
                return true;
            }
            case 6: {
                Message topo_rsp = new EmptyMessage(sender).putHeader(this.id, new Relay2Header(7).setSites(this._printTopology(this.relayer)));
                this.down_prot.down(topo_rsp);
                return true;
            }
            case 7: {
                String rsp = hdr.sites != null && hdr.sites.length > 0 ? hdr.sites[0] : null;
                this.topo_collector.add(sender, rsp);
                return true;
            }
        }
        return false;
    }

    protected void handleMessage(Relay2Header hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                this.route((SiteAddress)hdr.final_dest, (SiteAddress)hdr.original_sender, msg);
                break;
            }
            case 2: {
                this.triggerSiteUnreachableEvent((SiteAddress)hdr.final_dest);
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.log.error("type " + hdr.type + " unknown");
            }
        }
    }

    protected void route(SiteAddress dest, SiteAddress sender, Message msg) {
        String target_site = dest.getSite();
        if (target_site.equals(this.site)) {
            if (this.local_addr.equals(dest) || dest instanceof SiteMaster && this.is_site_master) {
                this.deliver(dest, sender, msg);
            } else {
                this.deliverLocally(dest, sender, msg);
            }
            return;
        }
        Relayer tmp = this.relayer;
        if (tmp == null) {
            this.log.warn(this.local_addr + ": not site master; dropping message");
            return;
        }
        Route route = tmp.getRoute(target_site, sender);
        if (route == null) {
            if (this.suppress_log_no_route != null) {
                this.suppress_log_no_route.log(SuppressLog.Level.error, target_site, this.suppress_time_no_route_errors, sender, target_site);
            } else {
                this.log.error(Util.getMessage("RelayNoRouteToSite"), this.local_addr, target_site);
            }
            this.sendSiteUnreachableTo(msg.getSrc(), target_site);
        } else {
            route.send(dest, sender, msg);
        }
    }

    protected void sendToBridges(Address sender, Message msg, String ... excluded_sites) {
        List<Route> routes;
        Relayer tmp = this.relayer;
        List<Route> list = routes = tmp != null ? tmp.getRoutes(excluded_sites) : null;
        if (routes == null) {
            return;
        }
        for (Route route : routes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": relaying multicast message from " + sender + " via route " + route);
            }
            try {
                route.send(null, sender, msg);
            }
            catch (Exception ex) {
                this.log.error(this.local_addr + ": failed relaying message from " + sender + " via route " + route, ex);
            }
        }
    }

    protected void sendSiteUnreachableTo(Address src, String target_site) {
        if (src == null || src.equals(this.local_addr)) {
            this.triggerSiteUnreachableEvent(new SiteMaster(target_site));
            return;
        }
        Message msg = new EmptyMessage(src).setFlag(Message.Flag.OOB).putHeader(this.id, new Relay2Header(2, new SiteMaster(target_site), null));
        this.down_prot.down(msg);
    }

    protected void forwardTo(Address next_dest, SiteAddress final_dest, Address original_sender, Message msg, boolean forward_to_current_coord) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": forwarding message to final destination " + final_dest + " to " + (Comparable)(forward_to_current_coord ? " the current coordinator" : next_dest));
        }
        Message copy2 = this.copy(msg).setDest(next_dest).setSrc(null);
        Relay2Header hdr = new Relay2Header(1, final_dest, original_sender);
        copy2.putHeader(this.id, hdr);
        this.down_prot.down(copy2);
    }

    protected void deliverLocally(SiteAddress dest, SiteAddress sender, Message msg) {
        Address local_dest;
        boolean send_to_coord = false;
        if (dest instanceof SiteUUID) {
            if (dest instanceof SiteMaster) {
                local_dest = this.pickSiteMaster(sender);
                if (local_dest == null) {
                    throw new IllegalStateException("site master was null");
                }
                send_to_coord = true;
            } else {
                SiteUUID tmp = (SiteUUID)dest;
                local_dest = new UUID(tmp.getMostSignificantBits(), tmp.getLeastSignificantBits());
            }
        } else {
            local_dest = dest;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": delivering message to " + dest + " in local cluster");
        }
        long start = this.stats ? System.nanoTime() : 0L;
        this.forwardTo(local_dest, dest, sender, msg, send_to_coord);
        if (this.stats) {
            this.forward_to_local_mbr_time.add(System.nanoTime() - start);
            this.forward_to_local_mbr.increment();
        }
    }

    protected void deliver(Address dest, Address sender, Message msg) {
        try {
            Message copy2 = this.copy(msg).setDest(dest).setSrc(sender);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": delivering message from " + sender);
            }
            long start = this.stats ? System.nanoTime() : 0L;
            this.up_prot.up(copy2);
            if (this.stats) {
                this.local_delivery_time.add(System.nanoTime() - start);
                this.local_deliveries.increment();
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDeliveringMessage"), e);
        }
    }

    protected void sitesChange(boolean down2, String ... sites) {
        if (!this.broadcast_route_notifications || sites == null || sites.length == 0) {
            return;
        }
        Relay2Header hdr = new Relay2Header(down2 ? (byte)5 : 4, null, null).setSites(sites);
        this.down_prot.down(new EmptyMessage(null).putHeader(this.id, hdr).setFlag(Message.Flag.NO_RELAY));
    }

    protected Message copy(Message msg) {
        return Util.copy(msg, true, (short)200, this.prots_above);
    }

    protected void startRelayer(Relayer rel, String bridge_name) {
        try {
            this.log.trace(this.local_addr + ": became site master; starting bridges");
            rel.start(this.site_config.getBridges(), bridge_name, this.site);
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed starting relayer", t);
        }
    }

    protected void notifySiteMasterListener(boolean flag) {
        if (this.site_master_listener != null) {
            this.site_master_listener.accept(flag);
        }
    }

    protected List<Address> determineSiteMasters(View view, int max_num_site_masters) {
        Address coord;
        ArrayList<Address> retval = new ArrayList<Address>(view.size());
        int selected = 0;
        for (Address member : view) {
            if (member instanceof ExtendedUUID && !((ExtendedUUID)member).isFlagSet((short)2) || selected++ >= max_num_site_masters) continue;
            retval.add(member);
        }
        if (retval.isEmpty() && (coord = view.getCoord()) != null) {
            retval.add(coord);
        }
        return retval;
    }

    protected Address pickSiteMaster(Address sender) {
        List<Address> masters = this.site_masters;
        if (masters.size() == 1) {
            return masters.get(0);
        }
        return this.site_master_picker.pickSiteMaster(masters, sender);
    }

    protected String _printTopology(Relayer rel) {
        HashMap<Address, String> local_sitemasters = new HashMap<Address, String>();
        List<String> all_sites = rel.getSiteNames();
        ArrayList<Supplier<Boolean>> topo_reqs = new ArrayList<Supplier<Boolean>>();
        for (String site_name : all_sites) {
            Route r = rel.getRoute(site_name);
            JChannel bridge = r.bridge();
            Address site_master = r.site_master;
            if (Objects.equals(site_master, r.bridge().getAddress())) {
                local_sitemasters.put(site_master, this.printLocalTopology());
                continue;
            }
            local_sitemasters.put(site_master, null);
            topo_reqs.add(() -> this.sendTopoReq(bridge, site_master));
        }
        this.topo_collector.reset(local_sitemasters.keySet());
        local_sitemasters.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> this.topo_collector.add((Address)e.getKey(), (String)e.getValue()));
        topo_reqs.forEach(Supplier::get);
        this.topo_collector.waitForAllResponses(this.topo_wait_time);
        Map<Address, String> rsps = this.topo_collector.getResults();
        if (rsps == null || rsps.isEmpty()) {
            return "n/a";
        }
        return String.join((CharSequence)"\n", rsps.values());
    }

    protected boolean sendTopoReq(JChannel bridge, Address dest) {
        Message topo_req = new EmptyMessage(dest).putHeader(this.id, new Relay2Header(6));
        try {
            bridge.send(topo_req);
            return true;
        }
        catch (Exception e) {
            this.log.warn("%s: failed sending TOPO-REQ message to %s: %s", bridge.getAddress(), dest, e);
            return false;
        }
    }

    protected String fetchTopoFromSiteMaster(Address sm) {
        this.topo_collector.reset(sm);
        Message topo_req = new EmptyMessage(sm).putHeader(this.id, new Relay2Header(6));
        this.down_prot.down(topo_req);
        this.topo_collector.waitForAllResponses(this.topo_wait_time);
        Map<Address, String> rsps = this.topo_collector.getResults();
        return rsps != null ? rsps.get(sm) : null;
    }

    private void triggerSiteUnreachableEvent(SiteAddress remoteSite) {
        this.up_prot.up(new Event(104, remoteSite));
    }

    public static class Relay2Header
    extends Header {
        public static final byte DATA = 1;
        public static final byte SITE_UNREACHABLE = 2;
        public static final byte HOST_UNREACHABLE = 3;
        public static final byte SITES_UP = 4;
        public static final byte SITES_DOWN = 5;
        public static final byte TOPO_REQ = 6;
        public static final byte TOPO_RSP = 7;
        protected byte type;
        protected Address final_dest;
        protected Address original_sender;
        protected String[] sites;

        public Relay2Header() {
        }

        public Relay2Header(byte type2) {
            this.type = type2;
        }

        public Relay2Header(byte type2, Address final_dest, Address original_sender) {
            this(type2);
            this.final_dest = final_dest;
            this.original_sender = original_sender;
        }

        @Override
        public short getMagicId() {
            return 80;
        }

        @Override
        public Supplier<? extends Header> create() {
            return Relay2Header::new;
        }

        public byte getType() {
            return this.type;
        }

        public Address getFinalDest() {
            return this.final_dest;
        }

        public Address getOriginalSender() {
            return this.original_sender;
        }

        public Relay2Header setSites(String ... s2) {
            this.sites = s2;
            return this;
        }

        public String[] getSites() {
            return this.sites;
        }

        @Override
        public int serializedSize() {
            return 1 + Util.size(this.final_dest) + Util.size(this.original_sender) + Relay2Header.sizeOf(this.sites);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.final_dest, out);
            Util.writeAddress(this.original_sender, out);
            out.writeInt(this.sites == null ? 0 : this.sites.length);
            if (this.sites != null) {
                for (String s2 : this.sites) {
                    Bits.writeString(s2, out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.final_dest = Util.readAddress(in);
            this.original_sender = Util.readAddress(in);
            int num_elements = in.readInt();
            if (num_elements == 0) {
                return;
            }
            this.sites = new String[num_elements];
            for (int i = 0; i < this.sites.length; ++i) {
                this.sites[i] = Bits.readString(in);
            }
        }

        @Override
        public String toString() {
            return Relay2Header.typeToString(this.type) + " [dest=" + this.final_dest + ", sender=" + this.original_sender + (this.type == 7 ? ", topos=" : ", sites=") + Arrays.toString(this.sites) + "]";
        }

        protected static String typeToString(byte type2) {
            switch (type2) {
                case 1: {
                    return "DATA";
                }
                case 2: {
                    return "SITE_UNREACHABLE";
                }
                case 3: {
                    return "HOST_UNREACHABLE";
                }
                case 4: {
                    return "SITES_UP";
                }
                case 5: {
                    return "SITES_DOWN";
                }
                case 6: {
                    return "TOPO_REQ";
                }
                case 7: {
                    return "TOPO_RSP";
                }
            }
            return "<unknown>";
        }

        protected static int sizeOf(String[] arr) {
            int retval = 4;
            if (arr != null) {
                for (String s2 : arr) {
                    retval += Bits.sizeUTF(s2) + 1;
                }
            }
            return retval;
        }
    }
}

