/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    protected final Promise<JoinRsp> join_promise = new Promise();

    public ClientGmsImpl(GMS g2) {
        super(g2);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.join_promise.reset();
    }

    @Override
    public void join(Address address, boolean useFlushIfPresent) {
        this.joinInternal(address, false, useFlushIfPresent);
    }

    @Override
    public void joinWithStateTransfer(Address local_addr, boolean useFlushIfPresent) {
        this.joinInternal(local_addr, true, useFlushIfPresent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void joinInternal(Address mbr, boolean joinWithStateTransfer, boolean useFlushIfPresent) {
        int join_attempts = 0;
        this.join_promise.reset();
        Responses responses = null;
        try {
            while (!this.gms.isLeaving()) {
                if (this.installViewIfValidJoinRsp(this.join_promise, false)) {
                    return;
                }
                long start = System.currentTimeMillis();
                if (responses == null) {
                    responses = (Responses)((Protocol)this.gms.getDownProtocol()).down(new Event(12, this.gms.getJoinTimeout()));
                } else {
                    Responses tmp = (Responses)((Protocol)this.gms.getDownProtocol()).down(new Event(12, this.gms.getJoinTimeout()));
                    if (tmp != null) {
                        responses.add(tmp, this.gms.getAddress());
                        tmp.done();
                    }
                }
                if (this.installViewIfValidJoinRsp(this.join_promise, false)) {
                    return;
                }
                responses.waitFor(this.gms.join_timeout);
                long diff = System.currentTimeMillis() - start;
                boolean empty = responses.isEmpty();
                if (empty || responses.isCoord(this.gms.getAddress())) {
                    this.log.info("%s: %s: creating cluster as coordinator", this.gms.getAddress(), empty ? String.format("no members discovered after %d ms", diff) : "I'm the first member");
                    this.becomeSingletonMember(mbr);
                    return;
                }
                this.log.trace("%s: discovery took %d ms, members: %s", this.gms.getAddress(), diff, responses);
                List<Address> coords = ClientGmsImpl.getCoords(responses);
                if (coords == null) {
                    if (this.firstOfAllClients(mbr, responses)) {
                        return;
                    }
                } else {
                    if (coords.size() > 1) {
                        this.log.debug("%s: found multiple coords: %s", this.gms.getAddress(), coords);
                        Collections.shuffle(coords);
                    }
                    for (Address coord : coords) {
                        this.log.debug("%s: sending JOIN(%s) to %s", this.gms.getAddress(), mbr, coord);
                        this.sendJoinMessage(coord, mbr, joinWithStateTransfer, useFlushIfPresent);
                        if (this.installViewIfValidJoinRsp(this.join_promise, true)) {
                            return;
                        }
                        this.log.warn("%s: JOIN(%s) sent to %s timed out (after %d ms), on try %d", this.gms.getAddress(), mbr, coord, this.gms.join_timeout, join_attempts);
                    }
                }
                if (this.gms.max_join_attempts <= 0 || ++join_attempts < this.gms.max_join_attempts) continue;
                this.log.warn("%s: too many JOIN attempts (%d): becoming singleton", this.gms.getAddress(), join_attempts);
                this.becomeSingletonMember(mbr);
                return;
            }
        }
        finally {
            if (responses != null) {
                responses.done();
            }
        }
    }

    @Override
    public void leave() {
        this.wrongMethod("leave");
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        this.join_promise.setResult(join_rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean installViewIfValidJoinRsp(Promise<JoinRsp> join_promise, boolean block_for_rsp) {
        boolean success = false;
        JoinRsp rsp = null;
        try {
            if (join_promise.hasResult()) {
                rsp = join_promise.getResult(1L, true);
            } else if (block_for_rsp) {
                rsp = join_promise.getResult(this.gms.join_timeout, true);
            }
            success = rsp != null && this.isJoinResponseValid(rsp) && this.installView(rsp.getView(), rsp.getDigest());
            boolean bl = success;
            return bl;
        }
        finally {
            if (success) {
                this.gms.sendViewAck(rsp.getView().getCreator());
            }
        }
    }

    protected boolean firstOfAllClients(Address joiner, Responses rsps) {
        this.log.trace("%s: could not determine coordinator from rsps %s", this.gms.getAddress(), rsps);
        TreeSet<Address> clients = new TreeSet<Address>();
        clients.add(joiner);
        for (PingData response : rsps) {
            clients.add(response.getAddress());
        }
        this.log.trace("%s: nodes to choose new coord from are: %s", this.gms.getAddress(), clients);
        Address new_coord = (Address)clients.first();
        if (new_coord.equals(joiner)) {
            this.log.trace("%s: I'm the FIRST of the nodes, will become coordinator", this.gms.getAddress());
            this.becomeSingletonMember(joiner);
            return true;
        }
        this.log.trace("%s: I'm not the first of the nodes, waiting for %d ms for another client to become coordinator", this.gms.getAddress(), this.gms.all_clients_retry_timeout);
        Util.sleep(this.gms.all_clients_retry_timeout);
        return false;
    }

    protected boolean isJoinResponseValid(JoinRsp rsp) {
        if (rsp.getFailReason() != null) {
            throw new SecurityException(rsp.getFailReason());
        }
        Digest tmp_digest = rsp.getDigest();
        if (tmp_digest == null || tmp_digest.capacity() == 0) {
            this.log.warn("%s: digest is empty: digest=%s", this.gms.getAddress(), rsp.getDigest());
            return false;
        }
        if (!tmp_digest.contains(this.gms.getAddress())) {
            this.log.error("%s: digest in JOIN_RSP does not contain myself; join response: %s", this.gms.getAddress(), rsp);
            return false;
        }
        if (rsp.getView() == null) {
            this.log.error("%s: JoinRsp has a null view, skipping it", this.gms.getAddress());
            return false;
        }
        return true;
    }

    private boolean installView(View new_view, Digest digest) {
        if (!new_view.containsMember(this.gms.getAddress())) {
            this.log.error("%s: I'm not member of %s, will not install view", this.gms.getAddress(), new_view);
            return false;
        }
        this.gms.installView(new_view, digest);
        ((Protocol)this.gms.getUpProtocol()).up(new Event(16));
        ((Protocol)this.gms.getDownProtocol()).down(new Event(16));
        return true;
    }

    void sendJoinMessage(Address coord, Address mbr, boolean joinWithTransfer, boolean useFlushIfPresent) {
        byte type2 = joinWithTransfer ? (byte)11 : 1;
        GMS.GmsHeader hdr = new GMS.GmsHeader(type2, mbr, useFlushIfPresent);
        Message msg = new BytesMessage(coord).setFlag(Message.Flag.OOB).putHeader(this.gms.getId(), hdr);
        ((Protocol)this.gms.getDownProtocol()).down(msg);
    }

    private static List<Address> getCoords(Iterable<PingData> mbrs) {
        if (mbrs == null) {
            return null;
        }
        ArrayList<Address> coords = null;
        for (PingData mbr : mbrs) {
            if (!mbr.isCoord()) continue;
            if (coords == null) {
                coords = new ArrayList<Address>();
            }
            if (coords.contains(mbr.getAddress())) continue;
            coords.add(mbr.getAddress());
        }
        return coords;
    }

    void becomeSingletonMember(Address mbr) {
        View new_view = View.create(mbr, 0L, mbr);
        Digest initial_digest = new Digest(mbr, 0L, 0L);
        this.gms.installView(new_view, initial_digest);
        ((Protocol)this.gms.getUpProtocol()).up(new Event(16));
        ((Protocol)this.gms.getDownProtocol()).down(new Event(16));
        this.log.debug("%s: created cluster (first member). My view is %s, impl is %s", this.gms.getAddress(), this.gms.getViewId(), this.gms.getImpl().getClass().getSimpleName());
    }
}

