/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.PhysicalAddress;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class PingData
implements SizeStreamable,
Constructable<PingData> {
    protected Address sender;
    protected byte flags;
    protected String logical_name;
    protected PhysicalAddress physical_addr;
    protected Collection<? extends Address> mbrs;
    protected static final byte is_server = 1;
    protected static final byte is_coord = 2;

    public PingData() {
    }

    public PingData(Address sender, boolean is_server) {
        this.sender = sender;
        this.server(is_server);
    }

    public PingData(Address sender, boolean is_server, String logical_name, PhysicalAddress physical_addr) {
        this(sender, is_server);
        this.logical_name = logical_name;
        this.physical_addr = physical_addr;
    }

    @Override
    public Supplier<? extends PingData> create() {
        return PingData::new;
    }

    public PingData coord(boolean c) {
        if (c) {
            this.flags = Util.setFlag(this.flags, (byte)2);
            this.flags = Util.setFlag(this.flags, (byte)1);
        } else {
            this.flags = Util.clearFlags(this.flags, (byte)2);
        }
        return this;
    }

    public PingData server(boolean c) {
        this.flags = c ? Util.setFlag(this.flags, (byte)1) : Util.clearFlags(this.flags, (byte)1);
        return this;
    }

    public boolean isCoord() {
        return Util.isFlagSet(this.flags, (byte)2);
    }

    public boolean isServer() {
        return Util.isFlagSet(this.flags, (byte)1) || Util.isFlagSet(this.flags, (byte)2);
    }

    public Address getAddress() {
        return this.sender;
    }

    public String getLogicalName() {
        return this.logical_name;
    }

    public PhysicalAddress getPhysicalAddr() {
        return this.physical_addr;
    }

    public PingData mbrs(Collection<? extends Address> mbrs) {
        this.mbrs = mbrs;
        return this;
    }

    public Collection<? extends Address> mbrs() {
        return this.mbrs;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof PingData)) {
            return false;
        }
        PingData other = (PingData)obj2;
        return Objects.equals(this.sender, other.sender);
    }

    public int hashCode() {
        int retval = 0;
        if (this.sender != null) {
            retval += this.sender.hashCode();
        }
        if (retval == 0) {
            retval = super.hashCode();
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.sender);
        if (this.logical_name != null) {
            sb.append(", name=").append(this.logical_name);
        }
        if (this.physical_addr != null) {
            sb.append(", addr=").append(this.physical_addr);
        }
        if (this.isCoord()) {
            sb.append(", coord");
        } else if (this.isServer()) {
            sb.append(", server");
        }
        if (this.mbrs != null) {
            sb.append(", mbrs=" + this.mbrs.size());
        }
        return sb.toString();
    }

    @Override
    public int serializedSize() {
        int retval = 1;
        retval += Util.size(this.sender);
        ++retval;
        if (this.logical_name != null) {
            retval += this.logical_name.length() + 2;
        }
        retval += Util.size(this.physical_addr);
        retval = (int)((long)retval + Util.size(this.mbrs));
        return retval;
    }

    @Override
    public void writeTo(DataOutput outstream) throws IOException {
        Util.writeAddress(this.sender, outstream);
        outstream.writeByte(this.flags);
        Bits.writeString(this.logical_name, outstream);
        Util.writeAddress(this.physical_addr, outstream);
        Util.writeAddresses(this.mbrs, outstream);
    }

    @Override
    public void readFrom(DataInput instream) throws IOException, ClassNotFoundException {
        this.sender = Util.readAddress(instream);
        this.flags = instream.readByte();
        this.logical_name = Bits.readString(instream);
        this.physical_addr = (PhysicalAddress)Util.readAddress(instream);
        this.mbrs = Util.readAddresses(instream, ArrayList::new);
    }
}

