/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Bits;

public class FragHeader
extends Header {
    public long id;
    public int frag_id;
    public int num_frags;
    public boolean needs_deserialization;
    public short original_type;

    public FragHeader() {
    }

    public FragHeader(long id, int frag_id, int num_frags) {
        this.id = id;
        this.frag_id = frag_id;
        this.num_frags = num_frags;
    }

    @Override
    public short getMagicId() {
        return 52;
    }

    @Override
    public Supplier<? extends Header> create() {
        return FragHeader::new;
    }

    public boolean needsDeserialization() {
        return this.needs_deserialization;
    }

    public FragHeader needsDeserialization(boolean flag) {
        this.needs_deserialization = flag;
        return this;
    }

    public short getOriginalType() {
        return this.original_type;
    }

    public FragHeader setOriginalType(short type2) {
        this.original_type = type2;
        return this;
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", frag_id=" + this.frag_id + ", num_frags=" + this.num_frags + "]";
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Bits.writeLongCompressed(this.id, out);
        Bits.writeIntCompressed(this.frag_id, out);
        Bits.writeIntCompressed(this.num_frags, out);
        out.writeBoolean(this.needs_deserialization);
        out.writeShort(this.original_type);
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.id) + Bits.size(this.frag_id) + Bits.size(this.num_frags) + 1 + 2;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.id = Bits.readLongCompressed(in);
        this.frag_id = Bits.readIntCompressed(in);
        this.num_frags = Bits.readIntCompressed(in);
        this.needs_deserialization = in.readBoolean();
        this.original_type = in.readShort();
    }
}

