/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.jgroups.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogImpl
implements Log {
    private static final Map<Function<Logger, Boolean>, String> LEVELS = new LinkedHashMap<Function<Logger, Boolean>, String>();
    private static final Locale LOCALE = Locale.getDefault();
    private final Logger logger;
    private final Locale locale;

    public Slf4jLogImpl(Class<?> clazz) {
        this(LOCALE, LoggerFactory.getLogger(clazz));
    }

    public Slf4jLogImpl(String category) {
        this(LOCALE, LoggerFactory.getLogger(category));
    }

    public Slf4jLogImpl(Locale locale, Logger logger) {
        this.logger = logger;
        this.locale = locale;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void fatal(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void fatal(String msg, Object ... args2) {
        String formatted = String.format(this.locale, msg, args2);
        this.logger.error(formatted);
    }

    @Override
    public void fatal(String msg, Throwable throwable) {
        this.logger.error(msg, throwable);
    }

    @Override
    public void error(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void error(String format, Object ... args2) {
        String formatted = String.format(this.locale, format, args2);
        this.logger.error(formatted);
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.logger.error(msg, throwable);
    }

    @Override
    public void warn(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void warn(String msg, Object ... args2) {
        String formatted = String.format(this.locale, msg, args2);
        this.logger.warn(formatted);
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        this.logger.warn(msg, throwable);
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void info(String msg, Object ... args2) {
        String formatted = String.format(this.locale, msg, args2);
        this.logger.info(formatted);
    }

    @Override
    public void debug(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void debug(String msg, Object ... args2) {
        String formatted = String.format(this.locale, msg, args2);
        this.logger.debug(formatted);
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        this.logger.debug(msg, throwable);
    }

    @Override
    public void trace(Object msg) {
        this.logger.trace("{}", msg);
    }

    @Override
    public void trace(String msg) {
        this.logger.trace(msg);
    }

    @Override
    public void trace(String msg, Object ... args2) {
        String formatted = String.format(this.locale, msg, args2);
        this.logger.trace(formatted);
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        this.logger.trace(msg, throwable);
    }

    @Override
    public void setLevel(String level) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLevel() {
        String result2 = "NONE";
        for (Map.Entry<Function<Logger, Boolean>, String> entry : LEVELS.entrySet()) {
            if (!entry.getKey().apply(this.logger).booleanValue()) break;
            result2 = entry.getValue();
        }
        return result2;
    }

    static {
        LEVELS.put(Logger::isErrorEnabled, "ERROR");
        LEVELS.put(Logger::isWarnEnabled, "WARN");
        LEVELS.put(Logger::isInfoEnabled, "INFO");
        LEVELS.put(Logger::isDebugEnabled, "DEBUG");
        LEVELS.put(Logger::isTraceEnabled, "TRACE");
    }
}

