/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.fork;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.conf.XmlNode;

public final class ForkConfig {
    protected static final String FORK_STACKS = "fork-stacks";
    protected static final String FORK_STACK = "fork-stack";
    protected static final String ID = "id";

    private ForkConfig() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Map<String, List<ProtocolConfiguration>> parse(InputStream input) throws Exception {
        XmlNode root = XmlConfigurator.parseXmlDocument(input);
        return ForkConfig.parse(root);
    }

    public static Map<String, List<ProtocolConfiguration>> parse(XmlNode root) throws Exception {
        ForkConfig.match(FORK_STACKS, root.getName());
        List<XmlNode> children2 = root.getChildren();
        if (children2 == null || children2.isEmpty()) {
            return null;
        }
        HashMap<String, List<ProtocolConfiguration>> map2 = new HashMap<String, List<ProtocolConfiguration>>();
        for (XmlNode node : children2) {
            ForkConfig.match(FORK_STACK, node.getName());
            ForkConfig.parseForkStack(map2, node);
        }
        return map2;
    }

    protected static void parseForkStack(Map<String, List<ProtocolConfiguration>> map2, XmlNode root) throws Exception {
        List<XmlNode> children2 = root.getChildren();
        if (children2 == null || children2.isEmpty()) {
            return;
        }
        Map<String, String> attributes = root.getAttributes();
        String fork_stack_id = attributes.get(ID);
        if (map2.containsKey(fork_stack_id)) {
            throw new IllegalStateException("duplicate fork-stack ID: \"" + fork_stack_id + "\"");
        }
        for (XmlNode node : children2) {
            List<ProtocolConfiguration> protocols = XmlConfigurator.parseProtocols(node);
            map2.put(fork_stack_id, protocols);
        }
    }

    protected static void match(String expected_name, String name) throws Exception {
        if (!expected_name.equals(name)) {
            throw new Exception("\"" + name + "\" didn't match \"" + expected_name + "\"");
        }
    }
}

