/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.util.function.Consumer;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Message;
import org.jgroups.Refcountable;
import org.jgroups.annotations.Experimental;
import org.jgroups.util.ByteArray;
import org.jgroups.util.RefcountImpl;

@Experimental
public class RefcountedBytesMessage
extends BytesMessage
implements Refcountable<Message> {
    protected final RefcountImpl<Message> impl = new RefcountImpl();

    public RefcountedBytesMessage() {
    }

    public RefcountedBytesMessage(Address dest) {
        super(dest);
    }

    public RefcountedBytesMessage(Address dest, byte[] array) {
        super(dest, array);
    }

    public RefcountedBytesMessage(Address dest, byte[] array, int offset, int length) {
        super(dest, array, offset, length);
    }

    public RefcountedBytesMessage(Address dest, ByteArray array) {
        super(dest, array);
    }

    public RefcountedBytesMessage(Address dest, Object obj2) {
        super(dest, obj2);
    }

    public synchronized byte getRefcount() {
        return this.impl.getRefcount();
    }

    @Override
    public synchronized RefcountedBytesMessage incr() {
        this.impl.incr();
        return this;
    }

    @Override
    public synchronized RefcountedBytesMessage decr() {
        this.impl.decr(this);
        return this;
    }

    public RefcountedBytesMessage onRelease(Consumer<Message> rc) {
        this.impl.onRelease(rc);
        return this;
    }

    @Override
    public String toString() {
        return String.format("%s (refcnt=%d)", super.toString(), this.impl.getRefcount());
    }
}

