/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.overlay;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(WidgetOverlay.class);
    protected final Client client;
    private final WidgetInfo widgetInfo;
    private final Rectangle parentBounds = new Rectangle();
    private boolean revalidate;

    public static Collection<WidgetOverlay> createOverlays(OverlayManager overlayManager, Client client) {
        return List.of(new WidgetOverlay(client, WidgetInfo.HEALTH_HUD, OverlayPosition.DYNAMIC));
    }

    private WidgetOverlay(Client client, WidgetInfo widgetInfo, OverlayPosition overlayPosition) {
        this(client, widgetInfo, overlayPosition, OverlayPriority.HIGHEST);
    }

    private WidgetOverlay(Client client, WidgetInfo widgetInfo, OverlayPosition overlayPosition, OverlayPriority overlayPriority) {
        this.client = client;
        this.widgetInfo = widgetInfo;
        this.setPriority(overlayPriority);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPosition(overlayPosition);
    }

    @Override
    public String getName() {
        return Objects.toString((Object)this.widgetInfo);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        Widget widget = this.client.getWidget(this.widgetInfo);
        Rectangle parent = this.getParentBounds(widget);
        if (parent.isEmpty()) {
            return null;
        }
        assert (widget != null);
        Rectangle bounds = this.getBounds();
        if (this.getPreferredLocation() != null || this.getPreferredPosition() != null) {
            widget.setRelativeX(bounds.x - parent.x);
            widget.setRelativeY(bounds.y - parent.y);
        } else {
            if (this.revalidate) {
                this.revalidate = false;
                if (RuneLiteProperties.DEBUG_MODE.booleanValue()) {
                    log.debug("Revalidating {}", (Object)this.widgetInfo);
                }
                widget.revalidate();
            }
            Rectangle widgetBounds = widget.getBounds();
            bounds.setBounds(widgetBounds.x, widgetBounds.y, widgetBounds.width, widgetBounds.height);
        }
        return new Dimension(widget.getWidth(), widget.getHeight());
    }

    private Rectangle getParentBounds(Widget widget) {
        if (widget == null || widget.isHidden()) {
            this.parentBounds.setBounds(new Rectangle());
            return this.parentBounds;
        }
        Widget parent = widget.getParent();
        Rectangle bounds = parent == null ? new Rectangle(this.client.getRealDimensions()) : parent.getBounds();
        this.parentBounds.setBounds(bounds);
        return bounds;
    }

    @Override
    public Rectangle getParentBounds() {
        if (!this.client.isClientThread()) {
            return this.parentBounds;
        }
        Widget widget = this.client.getWidget(this.widgetInfo);
        return this.getParentBounds(widget);
    }

    @Override
    public void revalidate() {
        this.revalidate = true;
    }

    private static class XpTrackerWidgetOverlay
    extends WidgetOverlay {
        private final OverlayManager overlayManager;

        private XpTrackerWidgetOverlay(OverlayManager overlayManager, Client client, WidgetInfo widgetInfo, OverlayPosition overlayPosition) {
            super(client, widgetInfo, overlayPosition);
            this.overlayManager = overlayManager;
        }

        @Override
        public Dimension render(Graphics2D graphics) {
            return super.render(graphics);
        }

        @Override
        public OverlayPosition getPosition() {
            if (!this.client.isClientThread()) {
                return super.getPosition();
            }
            return null;
        }
    }
}

