/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.rs;

import java.applet.Applet;
import java.io.IOException;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.FatalErrorDialog;
import net.runelite.client.ui.SplashScreen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLoader
implements Supplier<Applet> {
    private static final Logger log = LoggerFactory.getLogger(ClientLoader.class);
    private Object client;

    @Override
    public synchronized Applet get() {
        if (this.client == null) {
            try {
                this.client = this.doLoad();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (this.client instanceof Throwable) {
            throw new RuntimeException((Throwable)this.client);
        }
        return (Applet)this.client;
    }

    private static Applet loadVanilla() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> client = Class.forName("com.client.Client");
        return ClientLoader.loadFromClass(client);
    }

    private static Applet loadFromClass(Class<?> clientClass) throws IllegalAccessException, InstantiationException {
        return (Applet)clientClass.newInstance();
    }

    private Object doLoad() throws InstantiationException {
        try {
            SplashScreen.stage(0.465, "Starting", "Starting OblivionPk");
            Applet rs = ClientLoader.loadVanilla();
            SplashScreen.stage(0.5, null, "Starting core classes");
            return rs;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException e) {
            log.error("Error loading RS!", e);
            SwingUtilities.invokeLater(() -> FatalErrorDialog.showNetErrorWindow("loading the client", e));
            return e;
        }
    }
}

