/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.widgets;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.SpritePixels;
import net.runelite.api.widgets.Widget;
import net.runelite.client.plugins.sailingskill.BoatTool;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.util.ImageUtil;

public class ToolsWidgetManager {
    @Inject
    private Client client;
    @Inject
    private SailingPlugin plugin;
    private final BufferedImage borderImage = ImageUtil.loadImageResource(this.getClass(), "Buttons_Border.png");
    private final BufferedImage fireCannonImage = ImageUtil.loadImageResource(this.getClass(), "Button_Cannon.png");
    private final BufferedImage rodImage = ImageUtil.loadImageResource(this.getClass(), "Button_Fish.png");
    private final BufferedImage harpoonImage = ImageUtil.loadImageResource(this.getClass(), "Button_Harpoon.png");
    private final BufferedImage coinsImage = ImageUtil.loadImageResource(this.getClass(), "Button_Plunder.png");
    private final BufferedImage spyglassImage = ImageUtil.loadImageResource(this.getClass(), "Button_Spyglass.png");
    private final BufferedImage netImage = ImageUtil.loadImageResource(this.getClass(), "Button_Net.png");
    private final BufferedImage cannonballUnpressed = ImageUtil.loadImageResource(this.getClass(), "Cannonball_UnPressed.png");
    private final BufferedImage cannonballPressed = ImageUtil.loadImageResource(this.getClass(), "Cannonball_Pressed.png");
    private final BufferedImage harpoonUnpressed = ImageUtil.loadImageResource(this.getClass(), "Harpoon_UnPressed.png");
    private final BufferedImage harpoonPressed = ImageUtil.loadImageResource(this.getClass(), "Harpoon_Pressed.png");
    private final BufferedImage rodUnpressed = ImageUtil.loadImageResource(this.getClass(), "Rod_UnPressed.png");
    private final BufferedImage rodPressed = ImageUtil.loadImageResource(this.getClass(), "Rod_Pressed.png");
    private final BufferedImage netUnpressed = ImageUtil.loadImageResource(this.getClass(), "Net_UnPressed.png");
    private final BufferedImage netPressed = ImageUtil.loadImageResource(this.getClass(), "Net_Pressed.png");
    private final BufferedImage scopeUnpressed = ImageUtil.loadImageResource(this.getClass(), "Scope_UnPressed.png");
    private final BufferedImage scopePressed = ImageUtil.loadImageResource(this.getClass(), "Scope_Pressed.png");
    private final BufferedImage coinsUnpressed = ImageUtil.loadImageResource(this.getClass(), "Coins_UnPressed.png");
    private final BufferedImage coinsPressed = ImageUtil.loadImageResource(this.getClass(), "Coins_Pressed.png");
    private Widget parent;
    private Widget borderWidget;
    private Widget fireWidget;
    private Widget cannonballWidget;
    private Widget rodWidget;
    private Widget harpoonWidget;
    private Widget netWidget;
    private Widget spyglassWidget;
    private Widget coinsWidget;
    private final int BORDER_SPRITE_ID = 810;
    private final int BUTTON_CANNON_ID = 809;
    private final int BUTTON_FISH_ID = 1357;
    private final int BUTTON_HARPOON_ID = 804;
    private final int BUTTON_NET_ID = 808;
    private final int BUTTON_PLUNDER_ID = 837;
    private final int BUTTON_SPYGLASS_ID = 1103;
    private final int CANNONBALL_UNPRESSED_SPRITE_ID = 1239;
    private final int CANNONBALL_PRESSED_SPRITE_ID = 1349;
    private final int HARPOON_UNPRESSED_SPRITE_ID = 1224;
    private final int HARPOON_PRESSED_SPRITE_ID = 1223;
    private final int ROD_UNPRESSED_SPRITE_ID = 1222;
    private final int ROD_PRESSED_SPRITE_ID = 1221;
    private final int NET_UNPRESSED_SPRITE_ID = 1097;
    private final int NET_PRESSED_SPRITE_ID = 1100;
    private final int SPYGLASS_UNPRESSED_SPRITE_ID = 1104;
    private final int SPYGLASS_PRESSED_SPRITE_ID = 806;
    private final int COINS_UNPRESSED_SPRITE_ID = 807;
    private final int COINS_PRESSED_SPRITE_ID = 805;
    private final int HOVERED_OPACITY = 125;
    private final int BASE_Y = 45;

    public void setParent(Widget parentWidget) {
        this.parent = parentWidget;
    }

    public void createWidgets() {
        this.borderWidget = this.parent.createChild(10, 5);
        this.borderWidget.setPos(0, 30, 1, 1);
        this.borderWidget.setSize(160, 68);
        this.borderWidget.setOriginalWidth(160);
        this.borderWidget.setOriginalHeight(68);
        this.borderWidget.setSpriteId(810);
        this.borderWidget.revalidate();
        this.borderWidget.setHasListener(false);
        this.fireWidget = this.parent.createChild(11, 5);
        this.fireWidget.setPos(0, 16, 1, 1);
        this.fireWidget.setSize(150, 27);
        this.fireWidget.setOriginalWidth(150);
        this.fireWidget.setOriginalHeight(27);
        this.fireWidget.setSpriteId(809);
        this.fireWidget.revalidate();
        this.fireWidget.setHasListener(true);
        this.fireWidget.setOnOpListener(this::fireOpEvent);
        this.fireWidget.setOnMouseOverListener(this::fireHoverEvent);
        this.fireWidget.setOnMouseLeaveListener(this::fireLeaveEvent);
        this.fireWidget.setAction(0, "Fire cannon");
        this.cannonballWidget = this.parent.createChild(12, 5);
        this.cannonballWidget.setPos(-62, 45, 1, 1);
        this.cannonballWidget.setSize(23, 23);
        this.cannonballWidget.setOriginalWidth(23);
        this.cannonballWidget.setOriginalHeight(23);
        this.cannonballWidget.setSpriteId(1349);
        this.cannonballWidget.revalidate();
        this.cannonballWidget.setHasListener(true);
        this.cannonballWidget.setOnOpListener(this::onCannonballPressed);
        this.cannonballWidget.setAction(0, "Switch-to cannon");
        this.rodWidget = this.parent.createChild(13, 5);
        this.rodWidget.setPos(-37, 45, 1, 1);
        this.rodWidget.setSize(23, 23);
        this.rodWidget.setOriginalWidth(23);
        this.rodWidget.setOriginalHeight(23);
        this.rodWidget.setSpriteId(1222);
        this.rodWidget.revalidate();
        this.rodWidget.setHasListener(true);
        this.rodWidget.setOnOpListener(this::onRodPressed);
        this.rodWidget.setAction(0, "Switch-to rod");
        this.harpoonWidget = this.parent.createChild(14, 5);
        this.harpoonWidget.setPos(-12, 45, 1, 1);
        this.harpoonWidget.setSize(23, 23);
        this.harpoonWidget.setOriginalWidth(23);
        this.harpoonWidget.setOriginalHeight(23);
        this.harpoonWidget.setSpriteId(1224);
        this.harpoonWidget.revalidate();
        this.harpoonWidget.setHasListener(true);
        this.harpoonWidget.setOnOpListener(this::onHarpoonPressed);
        this.harpoonWidget.setAction(0, "Switch-to harpoon");
        this.netWidget = this.parent.createChild(15, 5);
        this.netWidget.setPos(12, 45, 1, 1);
        this.netWidget.setSize(23, 23);
        this.netWidget.setOriginalWidth(23);
        this.netWidget.setOriginalHeight(23);
        this.netWidget.setSpriteId(1097);
        this.netWidget.revalidate();
        this.netWidget.setHasListener(true);
        this.netWidget.setOnOpListener(this::onNetPressed);
        this.netWidget.setAction(0, "Switch-to net");
        this.spyglassWidget = this.parent.createChild(16, 5);
        this.spyglassWidget.setPos(37, 45, 1, 1);
        this.spyglassWidget.setSize(23, 23);
        this.spyglassWidget.setOriginalWidth(23);
        this.spyglassWidget.setOriginalHeight(23);
        this.spyglassWidget.setSpriteId(1104);
        this.spyglassWidget.revalidate();
        this.spyglassWidget.setHasListener(true);
        this.spyglassWidget.setOnOpListener(this::onSpyglassPressed);
        this.spyglassWidget.setAction(0, "Switch-to spyglass");
        this.coinsWidget = this.parent.createChild(17, 5);
        this.coinsWidget.setPos(62, 45, 1, 1);
        this.coinsWidget.setSize(23, 23);
        this.coinsWidget.setOriginalWidth(23);
        this.coinsWidget.setOriginalHeight(23);
        this.coinsWidget.setSpriteId(807);
        this.coinsWidget.revalidate();
        this.coinsWidget.setHasListener(true);
        this.coinsWidget.setOnOpListener(this::onCoinsPressed);
        this.coinsWidget.setAction(0, "Switch-to plunder");
    }

    public void fireHoverEvent(ScriptEvent e) {
        this.fireWidget.setOpacity(125);
    }

    public void fireLeaveEvent(ScriptEvent e) {
        this.fireWidget.setOpacity(0);
    }

    public void fireOpEvent(ScriptEvent e) {
        this.plugin.useCurrentTool();
    }

    public void onCannonballPressed(ScriptEvent e) {
        this.swapToolIcons(this.cannonballWidget, 1349);
        this.swapFireButton(809);
        this.plugin.setCurrentBoatTool(BoatTool.CANNON);
    }

    public void onRodPressed(ScriptEvent e) {
        this.swapToolIcons(this.rodWidget, 1221);
        this.swapFireButton(1357);
        this.plugin.setCurrentBoatTool(BoatTool.FISHING_ROD);
    }

    public void onHarpoonPressed(ScriptEvent e) {
        this.swapToolIcons(this.harpoonWidget, 1223);
        this.swapFireButton(804);
        this.plugin.setCurrentBoatTool(BoatTool.HARPOON);
    }

    public void onNetPressed(ScriptEvent e) {
        this.swapToolIcons(this.netWidget, 1100);
        this.swapFireButton(808);
        this.plugin.setCurrentBoatTool(BoatTool.NET);
    }

    public void onSpyglassPressed(ScriptEvent e) {
        this.swapToolIcons(this.spyglassWidget, 806);
        this.swapFireButton(1103);
        this.plugin.setCurrentBoatTool(BoatTool.SPYGLASS);
    }

    public void onCoinsPressed(ScriptEvent e) {
        this.swapToolIcons(this.coinsWidget, 805);
        this.swapFireButton(837);
        this.plugin.setCurrentBoatTool(BoatTool.PLUNDER);
    }

    public void swapToolIcons(Widget updatedWidget, int nextSpriteID) {
        this.cannonballWidget.setSpriteId(1239);
        this.rodWidget.setSpriteId(1222);
        this.harpoonWidget.setSpriteId(1224);
        this.netWidget.setSpriteId(1097);
        this.spyglassWidget.setSpriteId(1104);
        this.coinsWidget.setSpriteId(807);
        updatedWidget.setSpriteId(nextSpriteID);
    }

    public void swapFireButton(int nextFireButtonSprite) {
        this.fireWidget.setSpriteId(nextFireButtonSprite);
    }

    public void setSailSprites() {
        SpritePixels sp0 = ImageUtil.getImageSpritePixels(this.borderImage, this.client);
        this.client.getSpriteOverrides().put(810, sp0);
        SpritePixels sp1 = ImageUtil.getImageSpritePixels(this.cannonballUnpressed, this.client);
        this.client.getSpriteOverrides().put(1239, sp1);
        SpritePixels sp2 = ImageUtil.getImageSpritePixels(this.cannonballPressed, this.client);
        this.client.getSpriteOverrides().put(1349, sp2);
        SpritePixels sp3 = ImageUtil.getImageSpritePixels(this.rodUnpressed, this.client);
        this.client.getSpriteOverrides().put(1222, sp3);
        SpritePixels sp4 = ImageUtil.getImageSpritePixels(this.rodPressed, this.client);
        this.client.getSpriteOverrides().put(1221, sp4);
        SpritePixels sp5 = ImageUtil.getImageSpritePixels(this.harpoonUnpressed, this.client);
        this.client.getSpriteOverrides().put(1224, sp5);
        SpritePixels sp6 = ImageUtil.getImageSpritePixels(this.harpoonPressed, this.client);
        this.client.getSpriteOverrides().put(1223, sp6);
        SpritePixels sp7 = ImageUtil.getImageSpritePixels(this.netUnpressed, this.client);
        this.client.getSpriteOverrides().put(1097, sp7);
        SpritePixels sp8 = ImageUtil.getImageSpritePixels(this.netPressed, this.client);
        this.client.getSpriteOverrides().put(1100, sp8);
        SpritePixels sp9 = ImageUtil.getImageSpritePixels(this.scopeUnpressed, this.client);
        this.client.getSpriteOverrides().put(1104, sp9);
        SpritePixels sp10 = ImageUtil.getImageSpritePixels(this.scopePressed, this.client);
        this.client.getSpriteOverrides().put(806, sp10);
        SpritePixels sp11 = ImageUtil.getImageSpritePixels(this.coinsUnpressed, this.client);
        this.client.getSpriteOverrides().put(807, sp11);
        SpritePixels sp12 = ImageUtil.getImageSpritePixels(this.coinsPressed, this.client);
        this.client.getSpriteOverrides().put(805, sp12);
        SpritePixels sp13 = ImageUtil.getImageSpritePixels(this.fireCannonImage, this.client);
        this.client.getSpriteOverrides().put(809, sp13);
        SpritePixels sp14 = ImageUtil.getImageSpritePixels(this.rodImage, this.client);
        this.client.getSpriteOverrides().put(1357, sp14);
        SpritePixels sp15 = ImageUtil.getImageSpritePixels(this.harpoonImage, this.client);
        this.client.getSpriteOverrides().put(804, sp15);
        SpritePixels sp16 = ImageUtil.getImageSpritePixels(this.netImage, this.client);
        this.client.getSpriteOverrides().put(808, sp16);
        SpritePixels sp17 = ImageUtil.getImageSpritePixels(this.coinsImage, this.client);
        this.client.getSpriteOverrides().put(837, sp17);
        SpritePixels sp18 = ImageUtil.getImageSpritePixels(this.spyglassImage, this.client);
        this.client.getSpriteOverrides().put(1103, sp18);
    }

    public void setupManager(Widget parent) {
        this.setParent(parent);
        this.setSailSprites();
        this.createWidgets();
    }
}

