/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.overlays;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.sailingskill.BoatMaths;
import net.runelite.client.plugins.sailingskill.SailingConfig;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.util.ImageUtil;

public class WindOverlay
extends Overlay {
    private final Client client;
    private final SailingPlugin plugin;
    private final SailingConfig config;
    private int animationRotation = 0;
    BufferedImage windArrowBlank = ImageUtil.loadImageResource(this.getClass(), "Windy_Blank.png");
    BufferedImage windArrow0 = ImageUtil.loadImageResource(this.getClass(), "Windy_0.png");
    BufferedImage windArrow1 = ImageUtil.loadImageResource(this.getClass(), "Windy_1.png");
    BufferedImage windArrow2 = ImageUtil.loadImageResource(this.getClass(), "Windy_2.png");
    BufferedImage windArrow3 = ImageUtil.loadImageResource(this.getClass(), "Windy_3.png");
    BufferedImage windArrow4 = ImageUtil.loadImageResource(this.getClass(), "Windy_4.png");
    BufferedImage windArrow5 = ImageUtil.loadImageResource(this.getClass(), "Windy_5.png");
    BufferedImage boatIndicator = ImageUtil.loadImageResource(this.getClass(), "Wind_Boat_Indicator.png");

    @Inject
    private WindOverlay(Client client, SailingPlugin plugin, SailingConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.config = config;
        this.client = client;
        this.plugin = plugin;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        graphics.scale(this.config.overlayScale(), this.config.overlayScale());
        BufferedImage windImage = this.getWindImage();
        ImageComponent windImageComponent = new ImageComponent(windImage);
        ImageComponent windBlankImageComponent = new ImageComponent(this.windArrowBlank);
        double windCenterX = (double)windImage.getWidth() / 2.0;
        double windCenterY = (double)windImage.getHeight() / 2.0;
        int globalRotation = this.client.getCameraYaw() - 2048;
        double jUnitToRad = 0.0030679615757712823;
        graphics.rotate(jUnitToRad * (double)globalRotation, windCenterX, windCenterY);
        int sailOptionRotation = BoatMaths.translateOrientation(this.plugin.getAbsoluteBoatOrientation());
        graphics.rotate(jUnitToRad * (double)sailOptionRotation, windCenterX, windCenterY);
        graphics.drawImage((Image)this.boatIndicator, 0, 0, null);
        graphics.rotate(jUnitToRad * (double)sailOptionRotation * -1.0, windCenterX, windCenterY);
        int windRotation = this.plugin.getWindDirection();
        graphics.rotate((double)windRotation * jUnitToRad, windCenterX, windCenterY);
        int windChangeCountdown = this.config.windChangeRate() - this.plugin.getWindChangeTimer();
        if (windChangeCountdown < 16 && windChangeCountdown % 3 == 0) {
            return windBlankImageComponent.render(graphics);
        }
        return windImageComponent.render(graphics);
    }

    private BufferedImage getWindImage() {
        ++this.animationRotation;
        if (this.animationRotation < 40) {
            return this.windArrow0;
        }
        if (this.animationRotation < 50) {
            return this.windArrow1;
        }
        if (this.animationRotation < 60) {
            return this.windArrow2;
        }
        if (this.animationRotation < 70) {
            return this.windArrow3;
        }
        if (this.animationRotation < 80) {
            return this.windArrow4;
        }
        if (this.animationRotation < 100) {
            return this.windArrow5;
        }
        this.animationRotation = 0;
        return this.windArrow0;
    }
}

