/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill.overlays;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.sailingskill.SailingPlugin;
import net.runelite.client.plugins.sailingskill.combat.HitSplat;
import net.runelite.client.plugins.sailingskill.npcs.NPCCharacter;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;

public class HitsplatOverlay
extends Overlay {
    private final Client client;
    private final SailingPlugin plugin;
    BufferedImage hitsplatImage = ImageUtil.loadImageResource(this.getClass(), "Damage_hitsplat.png");
    BufferedImage healthBarRed = ImageUtil.loadImageResource(this.getClass(), "Healthbar Red.png");
    BufferedImage healthBarGreen = ImageUtil.loadImageResource(this.getClass(), "Healthbar Green.png");

    @Inject
    private HitsplatOverlay(Client client, SailingPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.LOW);
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        for (NPCCharacter npcDummy : this.plugin.getNpcCharacters()) {
            int hitTimer;
            RuneLiteObject runeLiteObject = npcDummy.getRuneLiteObject();
            int barTimer = npcDummy.getHealthBarTimer();
            if (barTimer > 0) {
                npcDummy.setHealthBarTimer(barTimer - 1);
                double healthRatio = (double)npcDummy.getCurrentHealth() / (double)npcDummy.getMaxHealth();
                this.drawHealthBar(graphics, runeLiteObject, healthRatio);
            }
            if ((hitTimer = npcDummy.getHitTimer()) <= 0) continue;
            npcDummy.setHitTimer(hitTimer - 1);
            this.drawHitsplat(graphics, runeLiteObject, npcDummy.getLastHit(), 1);
        }
        RuneLiteObject shipObject = this.plugin.getShipObject();
        int healthBarTimer = this.plugin.getHealthBarTimer();
        if (healthBarTimer > 0) {
            this.plugin.setHealthBarTimer(healthBarTimer - 1);
            double healthRatio = (double)this.plugin.getCurrentHealth() / (double)this.plugin.getMaxHealth();
            this.drawHealthBar(graphics, shipObject, healthRatio);
        }
        ArrayList<HitSplat> hitSplats = this.plugin.getHitSplats();
        for (int i = hitSplats.size() - 1; i >= 0; --i) {
            HitSplat hitSplat = hitSplats.get(i);
            int hitTimer = hitSplat.getHitTimer();
            hitSplat.setHitTimer(hitTimer - 1);
            this.drawHitsplat(graphics, this.plugin.getShipObject(), hitSplat.getHitValue(), hitSplat.getSplatPosition());
        }
        return null;
    }

    public void drawHitsplat(Graphics2D graphics, RuneLiteObject runeLiteObject, int lastHit, int position) {
        LocalPoint localPoint = runeLiteObject.getLocation();
        Point centralPoint = Perspective.getCanvasImageLocation(this.client, localPoint, this.hitsplatImage, 90);
        int splatWidth = this.hitsplatImage.getWidth();
        int positionModX = 0;
        int positionModY = 0;
        switch (position) {
            default: {
                break;
            }
            case 2: {
                positionModY = 20;
                break;
            }
            case 3: {
                positionModX = -15;
                positionModY = 10;
                break;
            }
            case 4: {
                positionModX = 15;
                positionModY = 10;
            }
        }
        Point healthPoint = new Point(centralPoint.getX() + positionModX, centralPoint.getY() + positionModY);
        OverlayUtil.renderImageLocation(graphics, healthPoint, this.hitsplatImage);
        FontMetrics fontMetrics = graphics.getFontMetrics(FontManager.getRunescapeSmallFont());
        String text = String.valueOf(lastHit);
        int fontWidth = fontMetrics.stringWidth(text);
        Point textPoint = new Point(centralPoint.getX() + positionModX + splatWidth / 2 - (fontWidth + 1) / 2, centralPoint.getY() + positionModY + 17);
        OverlayUtil.renderTextLocation(graphics, textPoint, text, Color.WHITE);
    }

    public void drawHealthBar(Graphics2D graphics, RuneLiteObject runeLiteObject, double healthRatio) {
        LocalPoint localPoint = runeLiteObject.getLocation();
        Point centralPoint = Perspective.getCanvasImageLocation(this.client, localPoint, this.hitsplatImage, 175);
        int splatWidth = this.hitsplatImage.getWidth();
        int barWidth = this.healthBarRed.getWidth();
        Point endPoint = new Point(centralPoint.getX() - barWidth / 2 + splatWidth / 2, centralPoint.getY());
        OverlayUtil.renderImageLocation(graphics, endPoint, this.healthBarRed);
        int greenBarWidth = (int)(30.0 * healthRatio);
        if (greenBarWidth > 0) {
            BufferedImage greenBar = this.healthBarGreen.getSubimage(0, 0, greenBarWidth, 5);
            OverlayUtil.renderImageLocation(graphics, endPoint, greenBar);
        }
    }
}

