/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.sailingskill;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.inject.Inject;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.JagexColor;
import net.runelite.api.Model;
import net.runelite.client.plugins.sailingskill.ModelSource;

public class ModelHandler {
    @Inject
    private Client client;
    public Model shipModel0;
    public Model shipModel0Half;
    public Model shipModelP45;
    public Model shipModelP90;
    public Model shipModelN45;
    public Model shipModelN90;
    public Model npcShipModel;
    public Model cannonballModel;
    public Model mossyRockSmall;
    public Model mossyRockLarge;
    public Model mossyRockTriple;
    public Model greyRockLarge;
    public Model greyRockSmall;
    public Model emptyModel;
    public Model flagModel;
    public Model fireModel;
    public Model basalt1;
    public Model basalt2;
    public Model basalt3;
    public Model basalt4;
    public Model basalt5;
    public Model basalt6;
    public Model basalt7;
    public Model basalt8;
    public Model fishModel;
    public Model fishSpace;
    public Model krakenModel;
    public Model krakenGiantModel;
    public Model krakenTentacleModel;
    public Model krakenProjectileModel;
    public Model krakenBossProjectileModel;
    public Model gullModel;
    public Model crocodileModel;
    public Animation boatIdleAnimation;
    public Animation greyRockAnimation;
    public Animation flagAnimation;
    public Animation boatDeathAnimation;
    public Animation fireAnimation;
    public Animation fishAnimation;
    public Animation krakenIdleAnimation;
    public Animation krakenBiteAnimation;
    public Animation krakenSpellAnimation;
    public Animation krakenDeathAnimation;
    public Animation tentacleIdleAnimation;
    public Animation tentacleAttackAnimation;
    public Animation tentacleDeathAnimation;
    public Animation krakenProjectileAnimation;
    public Animation krakenBossProjectileAnimation;
    public Animation gullIdleAnimation;
    public Animation gullDeathAnimation;
    public Animation crocodileIdleAnimation;
    public Animation crocodileWalkAnimation;
    public Animation crocodileAttackAnimation;
    public Animation crocodileDeathAnimation;
    private final int SHIP_MODEL = 8694;
    private final int SAIL_MODEL = 8695;
    private final int CANNONBALL_MODEL = 2846;
    private final int KRAKEN_PROJECTILE_MODEL = 7412;
    private final int MOSSY_ROCK_SMALL = 1517;
    private final int MOSSY_ROCK_LARGE = 1434;
    private final int MOSSY_ROCK_TRIPLE = 1518;
    private final int GREY_ROCK_LARGE = 5514;
    private final int GREY_ROCK_SMALL = 5515;
    private final int BLOCK = 1116;
    private final int FLAG = 2281;
    private final int FIRE = 26582;
    private final int BOAT_IDLE_ANIMATION = 2346;
    private final int GREY_ROCK_ANIMATION = 1727;
    private final int FLAG_ANIMATION = 471;
    private final int BOAT_DEATH_ANIMATION = 6645;
    private final int FIRE_ANIMATION = 6645;
    private final int FISH_ANIMATION = 5012;
    private final int BASALT_1 = 4548;
    private final int BASALT_2 = 4549;
    private final int BASALT_3 = 4550;
    private final int BASALT_4 = 4551;
    private final int BASALT_5 = 4552;
    private final int BASALT_6 = 4553;
    private final int BASALT_7 = 4554;
    private final int BASALT_8 = 4555;
    private final int KRAKEN = 28231;
    private final int KRAKEN_MEGA = 14920;
    private final int KRAKEN_IDLE_ANIMATION = 3989;
    private final int KRAKEN_BITE_ANIMATION = 3991;
    private final int KRAKEN_SPELL_ANIMATION = 3992;
    private final int KRAKEN_DEATH_ANIMATION = 3993;
    private final int KRAKEN_TENTACLE_MODEL = 13201;
    private final int TENTACLE_IDLE_ANIMATION = 3617;
    private final int TENTACLE_ATTACK_ANIMATION = 3618;
    private final int TENTACLE_DEATH_ANIMATION = 3620;
    private final int KRAKEN_PROJECTILE_ANIMATION = 34253;
    private final int KRAKEN_BOSS_PROJECTILE_MODEL = 26584;
    private final int KRAKEN_BOSS_PROJECTILE_ANIMATION = 6646;
    private final int FISH_MODEL = 19128;
    private final int FISH_RIPPLE = 19126;
    private final int GULL_MODEL_1 = 26841;
    private final int GULL_MODEL_2 = 26844;
    private final int GULL_IDLE_ANIMATION = 6771;
    private final int GULL_DEATH_ANIMATION = 6777;
    private final int CROCODILE_MODEL = 6454;
    private final int CROCODILE_IDLE_ANIMATION = 2037;
    private final int CROCODILE_WALK_ANIMATION = 2036;
    private final int CROCODILE_ATTACK_ANIMATION = 2039;
    private final int CROCODILE_DEATH_ANIMATION = 2038;

    public void loadModels() {
        Model shipBoat0 = this.client.loadModelData(8694).scale(80, 100, 70).rotateY270Ccw();
        Model shipSail0 = this.loadModel(8695, ModelSource.sail0);
        Model modelData0 = this.client.mergeModels(shipBoat0, shipSail0);
        this.shipModel0 = modelData0.light();
        Model shipBoatP45 = this.client.loadModelData(8694).scale(80, 100, 70).rotateY270Ccw();
        Model shipSailP45 = this.loadModel(8695, ModelSource.sailP45);
        Model modelDataP45 = this.client.mergeModels(shipBoatP45, shipSailP45);
        this.shipModelP45 = modelDataP45.light();
        Model shipBoatP90 = this.client.loadModelData(8694).scale(80, 100, 70).rotateY270Ccw();
        Model shipSailP90 = this.loadModel(8695, ModelSource.sailP90);
        Model modelDataP90 = this.client.mergeModels(shipBoatP90, shipSailP90);
        this.shipModelP90 = modelDataP90.light();
        Model shipBoatN45 = this.client.loadModelData(8694).scale(80, 100, 70).rotateY270Ccw();
        Model shipSailN45 = this.loadModel(8695, ModelSource.sailN45);
        Model modelDataN45 = this.client.mergeModels(shipBoatN45, shipSailN45);
        this.shipModelN45 = modelDataN45.light();
        Model shipBoatN90 = this.client.loadModelData(8694).scale(80, 100, 70).rotateY270Ccw();
        Model shipSailN90 = this.loadModel(8695, ModelSource.sailN90);
        Model modelDataN90 = this.client.mergeModels(shipBoatN90, shipSailN90);
        this.shipModelN90 = modelDataN90.light();
        Model npcShip = this.client.loadModelData(8694).scale(80, 100, 70).rotateY270Ccw();
        Model npcSail = this.client.loadModelData(8695).cloneColors().scale(100, 120, 90).rotateY90Ccw();
        short sailColour = npcSail.getFaceColors()[0];
        short sailReplaceColour = JagexColor.packHSL(55, 0, 40);
        npcSail.recolor(sailColour, sailReplaceColour);
        Model modelDataNPC = this.client.mergeModels(npcShip, npcSail);
        this.npcShipModel = modelDataNPC.light();
        Model cannonModel = this.client.loadModelData(2846).cloneColors();
        short cannonColour = cannonModel.getFaceColors()[0];
        short replaceColour = JagexColor.packHSL(5, 0, 10);
        cannonModel.scale(25, 25, 25).translate(0, 0, 50).recolor(cannonColour, replaceColour);
        this.cannonballModel = cannonModel.light();
        this.mossyRockSmall = this.client.loadModel(1517);
        Model mossyRockLargeMD = this.client.loadModelData(1434);
        this.mossyRockLarge = mossyRockLargeMD.scale(180, 180, 180).translate(20, 0, -50).light();
        Model mossyRockTripleMD = this.client.loadModelData(1518);
        this.mossyRockTriple = mossyRockTripleMD.scale(80, 80, 80).light();
        Model blockMD = this.client.loadModelData(1116);
        this.emptyModel = blockMD.scale(1, 1, 1).getModel();
        this.greyRockLarge = this.client.loadModel(5514);
        this.greyRockSmall = this.client.loadModel(5515);
        Model flagMD = this.client.loadModelData(2281).cloneColors();
        short flagWhiteColour = flagMD.getFaceColors()[19];
        short flagReplaceColour = JagexColor.packHSL(5, 6, 10);
        this.flagModel = flagMD.scale(70, 60, 70).recolor(flagWhiteColour, flagReplaceColour).light();
        this.fireModel = this.client.loadModel(26582);
        Model fishModelData = this.client.loadModelData(19128);
        Model fishRippleData = this.client.loadModelData(19126);
        this.fishModel = this.client.mergeModels(fishModelData, fishRippleData).light();
        Model fishSpaceMD = this.client.loadModelData(1116);
        this.fishSpace = fishSpaceMD.scale(1, 1, 1).light();
        this.basalt1 = this.client.loadModel(4548);
        this.basalt2 = this.client.loadModel(4549);
        this.basalt3 = this.client.loadModel(4550);
        this.basalt4 = this.client.loadModel(4551);
        this.basalt5 = this.client.loadModel(4552);
        this.basalt6 = this.client.loadModel(4553);
        this.basalt7 = this.client.loadModel(4554);
        this.basalt8 = this.client.loadModel(4555);
        Model krakenMD = this.client.loadModelData(28231);
        this.krakenModel = krakenMD.scale(64, 64, 64).translate(0, 0, 40).light();
        Model krakenGiantMD = this.client.loadModelData(14920);
        this.krakenGiantModel = krakenGiantMD.scale(640, 640, 640).light();
        Model krakenTentacleMD = this.client.loadModelData(13201).cloneColors();
        this.krakenTentacleModel = krakenTentacleMD.scale(700, 700, 700).light();
        Model krakenProjectile = this.client.loadModelData(7412).cloneColors();
        short krakenProjectileColour = krakenProjectile.getFaceColors()[0];
        short krakenProjectileReplaceColour = JagexColor.packHSL(31, 5, 80);
        this.krakenProjectileModel = krakenProjectile.scale(64, 64, 64).recolor(krakenProjectileColour, krakenProjectileReplaceColour).light();
        Model krakenBossProjectileMD = this.client.loadModelData(26584);
        this.krakenBossProjectileModel = krakenBossProjectileMD.scale(300, 300, 300).light(100, 768, -50, -10, -50);
        Model gullMD1 = this.client.loadModelData(26841);
        Model gullMD2 = this.client.loadModelData(26844);
        this.gullModel = this.client.mergeModels(gullMD1, gullMD2).light();
        Model crocodileMD = this.client.loadModelData(6454);
        this.crocodileModel = crocodileMD.scale(180, 180, 180).light();
        this.boatIdleAnimation = this.client.loadAnimation(2346);
        this.greyRockAnimation = this.client.loadAnimation(1727);
        this.flagAnimation = this.client.loadAnimation(471);
        this.boatDeathAnimation = this.client.loadAnimation(6645);
        this.fireAnimation = this.client.loadAnimation(6645);
        this.fishAnimation = this.client.loadAnimation(5012);
        this.krakenIdleAnimation = this.client.loadAnimation(3989);
        this.krakenSpellAnimation = this.client.loadAnimation(3992);
        this.krakenBiteAnimation = this.client.loadAnimation(3991);
        this.krakenDeathAnimation = this.client.loadAnimation(3993);
        this.tentacleIdleAnimation = this.client.loadAnimation(3617);
        this.tentacleAttackAnimation = this.client.loadAnimation(3618);
        this.tentacleDeathAnimation = this.client.loadAnimation(3620);
        this.krakenProjectileAnimation = this.client.loadAnimation(34253);
        this.krakenBossProjectileAnimation = this.client.loadAnimation(6646);
        this.gullIdleAnimation = this.client.loadAnimation(6771);
        this.gullDeathAnimation = this.client.loadAnimation(6777);
        this.crocodileIdleAnimation = this.client.loadAnimation(2037);
        this.crocodileWalkAnimation = this.client.loadAnimation(2036);
        this.crocodileAttackAnimation = this.client.loadAnimation(2039);
        this.crocodileDeathAnimation = this.client.loadAnimation(2038);
    }

    public Model loadModel(int modelId, ModelSource modelSource) {
        Model modelData = this.client.loadModelData(modelId);
        int[] verticesX = modelData.getVerticesX();
        int[] verticesY = modelData.getVerticesY();
        int[] verticesZ = modelData.getVerticesZ();
        int[] faces1 = modelData.getFaceIndices1();
        int[] faces2 = modelData.getFaceIndices2();
        int[] faces3 = modelData.getFaceIndices3();
        short[] faceColours = modelData.getFaceColors();
        try {
            URL vertexURL = new URL(modelSource.vertexLink);
            URLConnection vertexConnection = vertexURL.openConnection();
            BufferedReader inVertex = new BufferedReader(new InputStreamReader(vertexConnection.getInputStream()));
            int vertIteration = 0;
            String lineVertex = "";
            while ((lineVertex = inVertex.readLine()) != null) {
                int vertZ;
                int vertY;
                int vertX;
                String[] vertex = lineVertex.split(",");
                verticesX[vertIteration] = vertX = (int)(-1.0 * Double.parseDouble(vertex[0]));
                verticesZ[vertIteration] = vertY = (int)Double.parseDouble(vertex[1]);
                verticesY[vertIteration] = vertZ = (int)(-1.0 * Double.parseDouble(vertex[2]));
                ++vertIteration;
            }
            inVertex.close();
            URL faceURL = new URL(modelSource.faceLink);
            URLConnection faceConnection = faceURL.openConnection();
            BufferedReader inFace = new BufferedReader(new InputStreamReader(faceConnection.getInputStream()));
            int faceIteration = 0;
            String lineFace = "";
            while ((lineFace = inFace.readLine()) != null) {
                int face3;
                int face2;
                int face1;
                String[] face = lineFace.split(",");
                faces1[faceIteration] = face1 = Integer.parseInt(face[0]);
                faces3[faceIteration] = face2 = Integer.parseInt(face[1]);
                faces2[faceIteration] = face3 = Integer.parseInt(face[2]);
                ++faceIteration;
            }
            inFace.close();
            URL colourURL = new URL(modelSource.colourLink);
            URLConnection colourConnection = colourURL.openConnection();
            BufferedReader inColour = new BufferedReader(new InputStreamReader(colourConnection.getInputStream()));
            int colourIteration = 0;
            String lineColour = "";
            while ((lineColour = inColour.readLine()) != null) {
                short jagexColor;
                String[] colour = lineColour.split(",");
                double colourH = Double.parseDouble(colour[0]);
                int colourHInt = (int)(63.0 - colourH * 63.0);
                double colourL = Double.parseDouble(colour[1]);
                int colourLInt = (int)(colourL * 127.0);
                double colourS = Double.parseDouble(colour[2]);
                int colourSInt = (int)(colourS * 7.0);
                faceColours[colourIteration] = jagexColor = JagexColor.packHSL(colourHInt, colourSInt, colourLInt);
                ++colourIteration;
            }
            inColour.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modelData;
    }
}

