/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.resourcepacks.hub;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import net.runelite.client.plugins.resourcepacks.ResourcePacksManager;
import net.runelite.client.plugins.resourcepacks.ResourcePacksPlugin;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePackManifest;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePacksClient;
import net.runelite.client.plugins.resourcepacks.hub.ResourcePacksHubPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePacksHubItem
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ResourcePacksHubItem.class);
    private static final ImageIcon MISSING_ICON;
    private static final ImageIcon HELP_ICON;
    private static final ImageIcon HELP_ICON_HOVER;
    private static final int HEIGHT = 147;
    private static final int ICON_WIDTH = 224;
    private static final int BOTTOM_LINE_HEIGHT = 16;
    public final ResourcePackManifest manifest;
    public final List<String> keywords = new ArrayList<String>();
    private final boolean installed;

    ResourcePacksHubItem(ResourcePackManifest newManifest, Collection<ResourcePackManifest> currentManifests, boolean installed, ScheduledExecutorService executor, ResourcePacksClient resourcePacksClient, ResourcePacksManager resourcePacksManager) {
        ResourcePackManifest loaded = null;
        if (!currentManifests.isEmpty()) {
            loaded = currentManifests.iterator().next();
        }
        this.manifest = loaded == null ? newManifest : loaded;
        this.installed = installed;
        if (this.manifest != null) {
            Collections.addAll(this.keywords, ResourcePacksHubPanel.SPACES.split(this.manifest.getDisplayName().toLowerCase()));
            Collections.addAll(this.keywords, this.manifest.getAuthor().toLowerCase());
            if (this.manifest.getTags() != null) {
                Collections.addAll(this.keywords, this.manifest.getTags());
            }
        }
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setOpaque(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JLabel pluginName = new JLabel(this.manifest.getDisplayName());
        pluginName.setFont(FontManager.getRunescapeBoldFont());
        pluginName.setToolTipText(this.manifest.getDisplayName());
        JLabel author = new JLabel(this.manifest.getAuthor());
        author.setFont(FontManager.getRunescapeSmallFont());
        author.setToolTipText(this.manifest.getAuthor());
        JLabel version = new JLabel(this.manifest.getCompatibleVersion());
        version.setFont(FontManager.getRunescapeSmallFont());
        version.setHorizontalAlignment(4);
        version.setToolTipText("Compatible with " + this.manifest.getCompatibleVersion() + " version of Resource Packs plugin");
        JLabel icon = new JLabel();
        icon.setHorizontalAlignment(0);
        icon.setIcon(MISSING_ICON);
        if (this.manifest.isHasIcon()) {
            executor.submit(() -> {
                try {
                    BufferedImage img = resourcePacksClient.downloadIcon(this.manifest);
                    SwingUtilities.invokeLater(() -> icon.setIcon(new ImageIcon(img)));
                }
                catch (IOException e) {
                    log.info("Cannot download icon for pack \"{}\"", (Object)this.manifest.getInternalName(), (Object)e);
                }
            });
        }
        JButton help = new JButton(HELP_ICON);
        help.setRolloverIcon(HELP_ICON_HOVER);
        SwingUtil.removeButtonDecorations(help);
        help.setBorder(null);
        if (this.manifest.getRepo() == null) {
            help.setVisible(false);
        } else {
            help.setToolTipText("See more: " + this.manifest.getRepo().toString());
            help.addActionListener(ev -> LinkBrowser.browse(this.manifest.getRepo().toString()));
        }
        help.setBorder(null);
        boolean install = !installed;
        boolean update2 = loaded != null && newManifest != null && !newManifest.equals(loaded);
        boolean remove = !install && !update2;
        JButton addrm = new JButton();
        if (install) {
            addrm.setText("Install");
            addrm.setBackground(new Color(2670120));
            addrm.addActionListener(l -> {
                addrm.setText("Installing");
                addrm.setBackground(new Color(12888064));
                resourcePacksManager.install(this.manifest.getInternalName());
            });
        } else if (remove) {
            addrm.setText("Remove");
            addrm.setBackground(new Color(12462120));
            addrm.addActionListener(l -> {
                addrm.setText("Removing");
                addrm.setBackground(new Color(12888064));
                resourcePacksManager.remove(this.manifest.getInternalName());
            });
        } else {
            addrm.setText("Update");
            addrm.setBackground(new Color(2056735));
            addrm.addActionListener(l -> {
                addrm.setText("Updating");
                addrm.setBackground(new Color(12888064));
                executor.submit(resourcePacksManager::refreshPlugins);
            });
        }
        addrm.setBorder(new LineBorder(addrm.getBackground().darker()));
        addrm.setFocusPainted(false);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(5).addComponent(pluginName, 0, -2, 135).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addComponent(help, 0, 24, 24).addComponent(addrm, 0, 50, -2).addGap(5)).addGroup(layout.createSequentialGroup().addGap(5).addComponent(author, 0, -2, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, 100).addComponent(version, 0, -2, Short.MAX_VALUE).addGap(5))).addGroup(layout.createSequentialGroup().addGap(2).addComponent(icon, 224, 224, 224)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(5).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(pluginName).addComponent(help, 16, 16, 16).addComponent(addrm, 16, 16, 16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -2, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(author, 16, 16, 16).addComponent(version, 16, 16, 16)).addGap(5)).addComponent(icon, 147, -1, 147).addGap(5));
    }

    public boolean isInstalled() {
        return this.installed;
    }

    static {
        BufferedImage missingIcon = ImageUtil.getResourceStreamFromClass(ResourcePacksPlugin.class, "/missing.png");
        MISSING_ICON = new ImageIcon(missingIcon);
        BufferedImage helpIcon = ImageUtil.getResourceStreamFromClass(ResourcePacksPlugin.class, "/help.png");
        HELP_ICON = new ImageIcon(helpIcon);
        HELP_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)helpIcon, -100));
    }
}

