/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.pyramidplunder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.pyramidplunder.PyramidPlunderConfig;
import net.runelite.client.plugins.pyramidplunder.PyramidPlunderPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ColorUtil;

class PyramidPlunderOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 1500;
    private final Client client;
    private final PyramidPlunderPlugin plugin;
    private final PyramidPlunderConfig config;

    @Inject
    private PyramidPlunderOverlay(Client client, PyramidPlunderPlugin plugin, PyramidPlunderConfig config) {
        super(plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        Point mousePosition = this.client.getMouseCanvasPosition();
        this.plugin.getTilesToHighlight().forEach((object, tile) -> {
            if (!this.config.highlightDoors() && PyramidPlunderPlugin.TOMB_DOOR_WALL_IDS.contains(object.getId()) || !this.config.highlightSpeartraps() && 21280 == object.getId() || tile.getPlane() != this.client.getPlane() || object.getLocalLocation().distanceTo(playerLocation) >= 1500) {
                return;
            }
            Color highlightColor = 21280 == object.getId() ? this.config.highlightSpeartrapsColor() : this.config.highlightDoorsColor();
            Shape objectClickbox = object.getClickbox();
            if (objectClickbox != null) {
                if (objectClickbox.contains(mousePosition.getX(), mousePosition.getY())) {
                    graphics.setColor(highlightColor.darker());
                } else {
                    graphics.setColor(highlightColor);
                }
                graphics.draw(objectClickbox);
                graphics.setColor(ColorUtil.colorWithAlpha(highlightColor, highlightColor.getAlpha() / 5));
                graphics.fill(objectClickbox);
            }
        });
        return null;
    }
}

