/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.hd.utils;

import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.client.config.Keybind;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.hd.data.environments.Area;
import net.runelite.client.plugins.hd.overlays.TileInfoOverlay;
import net.runelite.client.plugins.hd.utils.AABB;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeveloperTools
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(DeveloperTools.class);
    private static final Keybind KEY_TOGGLE_TILE_INFO = new Keybind(114, 128);
    @Inject
    private KeyManager keyManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TileInfoOverlay tileInfoOverlay;
    private boolean tileInfoOverlayEnabled = false;

    public void activate() {
        this.keyManager.registerKeyListener(this);
        if (this.tileInfoOverlayEnabled) {
            this.overlayManager.add(this.tileInfoOverlay);
        }
        for (Area area : Area.values()) {
            if (area == Area.ALL || area == Area.NONE) continue;
            for (AABB aabb : area.aabbs) {
                if (aabb.minX >= -128 && aabb.minY >= 1000 && aabb.maxX <= 5000 && aabb.maxY <= 13000) continue;
                throw new IllegalArgumentException("Your definition for the area " + area + " has an incorrect AABB: " + aabb);
            }
        }
    }

    public void deactivate() {
        this.keyManager.unregisterKeyListener(this);
        this.overlayManager.remove(this.tileInfoOverlay);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (KEY_TOGGLE_TILE_INFO.matches(event)) {
            event.consume();
            boolean bl = this.tileInfoOverlayEnabled = !this.tileInfoOverlayEnabled;
            if (this.tileInfoOverlayEnabled) {
                this.overlayManager.add(this.tileInfoOverlay);
            } else {
                this.overlayManager.remove(this.tileInfoOverlay);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }
}

