/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.combatlevel;

import com.google.inject.Provides;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.combatlevel.CombatLevelConfig;
import net.runelite.client.plugins.combatlevel.CombatLevelOverlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Combat Level", description="Show a more accurate combat level in Combat Options panel and other combat level functions", tags={"wilderness", "attack", "range"})
public class CombatLevelPlugin
extends Plugin {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.###");
    private static final String CONFIG_GROUP = "combatlevel";
    private static final String ATTACK_RANGE_CONFIG_KEY = "wildernessAttackLevelRange";
    private static final Pattern WILDERNESS_LEVEL_PATTERN = Pattern.compile("^Level: (\\d+)$");
    private static final int MIN_COMBAT_LEVEL = 3;
    private static final String COMBAT_LEVEL_SECTION_TEXT = "Combat Level:";
    private static final Color CHARACTER_SUMMARY_GREEN = Color.decode("#0dc10d");
    @Inject
    private Client client;
    @Inject
    private CombatLevelConfig config;
    @Inject
    private CombatLevelOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    CombatLevelConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(CombatLevelConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.overlay);
        if (this.config.wildernessAttackLevelRange()) {
            // empty if block
        }
    }

    @Override
    protected void shutDown() throws Exception {
        String widgetText;
        this.overlayManager.remove(this.overlay);
        Widget combatLevelWidget = this.client.getWidget(WidgetInfo.COMBAT_LEVEL.getGroupId());
        if (combatLevelWidget != null && (widgetText = combatLevelWidget.getText()).contains(".")) {
            combatLevelWidget.setText(widgetText.substring(0, widgetText.indexOf(".")));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.setCombatLevelWidget(WidgetInfo.COMBAT_LEVEL.getGroupId());
        this.setCombatLevelWidget(331);
        this.setCombatLevelWidget(12294);
        this.setCombatLevelWidget(780);
        this.setCombatLevelWidget(1702);
        this.setCombatLevelWidget(1768);
        this.setCombatLevelWidget(2427);
    }

    private void setCombatLevelWidget(int id) {
        Widget combatLevelWidget = this.client.getWidget(id);
        if (combatLevelWidget == null || !this.config.showPreciseCombatLevel()) {
            return;
        }
        double combatLevelPrecise = Experience.getCombatLevelPrecise(this.client.getRealSkillLevel(Skill.ATTACK), this.client.getRealSkillLevel(Skill.STRENGTH), this.client.getRealSkillLevel(Skill.DEFENCE), this.client.getRealSkillLevel(Skill.HITPOINTS), this.client.getRealSkillLevel(Skill.MAGIC), this.client.getRealSkillLevel(Skill.RANGED), this.client.getRealSkillLevel(Skill.PRAYER));
        combatLevelWidget.setText("Combat Lvl: " + DECIMAL_FORMAT.format(combatLevelPrecise));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup()) || !ATTACK_RANGE_CONFIG_KEY.equals(event.getKey())) {
            return;
        }
    }

    private static String combatAttackRange(int combatLevel, int wildernessLevel) {
        return Math.max(3, combatLevel - wildernessLevel) + "-" + Math.min(126, combatLevel + wildernessLevel);
    }
}

