/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.api;

public class Hitsplat {
    private HitsplatType hitsplatType;
    private int amount;
    private int disappearsOnGameCycle;

    public Hitsplat(HitsplatType hitsplatType, int amount, int disappearsOnGameCycle) {
        this.hitsplatType = hitsplatType;
        this.amount = amount;
        this.disappearsOnGameCycle = disappearsOnGameCycle;
    }

    public boolean isMine() {
        switch (this.getHitsplatType()) {
            case BLOCK_ME: 
            case DAMAGE_ME: 
            case DAMAGE_ME_CYAN: 
            case DAMAGE_ME_YELLOW: 
            case DAMAGE_ME_ORANGE: 
            case DAMAGE_ME_WHITE: {
                return true;
            }
        }
        return false;
    }

    public boolean isOthers() {
        switch (this.getHitsplatType()) {
            case BLOCK_OTHER: 
            case DAMAGE_OTHER: 
            case DAMAGE_OTHER_CYAN: 
            case DAMAGE_OTHER_YELLOW: 
            case DAMAGE_OTHER_ORANGE: 
            case DAMAGE_OTHER_WHITE: {
                return true;
            }
        }
        return false;
    }

    public HitsplatType getHitsplatType() {
        return this.hitsplatType;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getDisappearsOnGameCycle() {
        return this.disappearsOnGameCycle;
    }

    public static enum HitsplatType {
        BLOCK_ME,
        BLOCK_OTHER,
        DAMAGE_ME,
        DAMAGE_OTHER,
        DAMAGE_ME_CYAN,
        DAMAGE_OTHER_CYAN,
        DAMAGE_ME_ORANGE,
        DAMAGE_OTHER_ORANGE,
        DAMAGE_ME_YELLOW,
        DAMAGE_OTHER_YELLOW,
        DAMAGE_ME_WHITE,
        DAMAGE_OTHER_WHITE,
        POISON,
        VENOM,
        DISEASE,
        HEAL;


        public static HitsplatType fromInteger(int type2) {
            switch (type2) {
                case 12: {
                    return BLOCK_ME;
                }
                case 13: {
                    return BLOCK_OTHER;
                }
                case 16: {
                    return DAMAGE_ME;
                }
                case 17: {
                    return DAMAGE_OTHER;
                }
                case 1: {
                    return DAMAGE_ME;
                }
                case 0: {
                    return BLOCK_ME;
                }
                case 2: {
                    return POISON;
                }
                case 3: {
                    return VENOM;
                }
                case 4: {
                    return DISEASE;
                }
                case 5: {
                    return VENOM;
                }
                case 6: {
                    return HEAL;
                }
                case 18: {
                    return DAMAGE_ME_CYAN;
                }
                case 19: {
                    return DAMAGE_OTHER_CYAN;
                }
                case 20: {
                    return DAMAGE_ME_ORANGE;
                }
                case 21: {
                    return DAMAGE_OTHER_ORANGE;
                }
                case 22: {
                    return DAMAGE_ME_YELLOW;
                }
                case 23: {
                    return DAMAGE_OTHER_YELLOW;
                }
                case 24: {
                    return DAMAGE_ME_WHITE;
                }
                case 25: {
                    return DAMAGE_OTHER_WHITE;
                }
            }
            return null;
        }
    }
}

