/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableThrottleLatest<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean emitLast;

    public ObservableThrottleLatest(Observable<T> source2, long timeout2, TimeUnit unit, Scheduler scheduler, boolean emitLast) {
        super(source2);
        this.timeout = timeout2;
        this.unit = unit;
        this.scheduler = scheduler;
        this.emitLast = emitLast;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new ThrottleLatestObserver<T>(observer, this.timeout, this.unit, this.scheduler.createWorker(), this.emitLast));
    }

    static final class ThrottleLatestObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -8296689127439125014L;
        final Observer<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final boolean emitLast;
        final AtomicReference<T> latest;
        Disposable upstream;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        volatile boolean timerFired;
        boolean timerRunning;

        ThrottleLatestObserver(Observer<? super T> downstream, long timeout2, TimeUnit unit, Scheduler.Worker worker, boolean emitLast) {
            this.downstream = downstream;
            this.timeout = timeout2;
            this.unit = unit;
            this.worker = worker;
            this.emitLast = emitLast;
            this.latest = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.latest.set(t);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.latest.lazySet(null);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void run() {
            this.timerFired = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<T> latest = this.latest;
            Observer<T> downstream = this.downstream;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    latest.lazySet(null);
                    return;
                }
                boolean d = this.done;
                if (d && this.error != null) {
                    latest.lazySet(null);
                    downstream.onError(this.error);
                    this.worker.dispose();
                    return;
                }
                T v = latest.get();
                boolean bl = empty = v == null;
                if (d) {
                    v = latest.getAndSet(null);
                    if (!empty && this.emitLast) {
                        downstream.onNext(v);
                    }
                    downstream.onComplete();
                    this.worker.dispose();
                    return;
                }
                if (empty) {
                    if (this.timerFired) {
                        this.timerRunning = false;
                        this.timerFired = false;
                    }
                } else if (!this.timerRunning || this.timerFired) {
                    v = latest.getAndSet(null);
                    downstream.onNext(v);
                    this.timerFired = false;
                    this.timerRunning = true;
                    this.worker.schedule(this, this.timeout, this.unit);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

