/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.objectPool;

import dorkbox.objectPool.ObjectPool;
import dorkbox.objectPool.PoolableObject;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

class BlockingPool<T>
extends ObjectPool<T> {
    private final BlockingQueue<T> queue;
    private final PoolableObject<T> poolableObject;

    BlockingPool(PoolableObject<T> poolableObject, int size) {
        this(poolableObject, new ArrayBlockingQueue(size), size);
    }

    BlockingPool(PoolableObject<T> poolableObject, BlockingQueue<T> queue, int size) {
        this.poolableObject = poolableObject;
        this.queue = queue;
        for (int x = 0; x < size; ++x) {
            T e = poolableObject.create();
            poolableObject.onReturn(e);
            this.queue.add(e);
        }
    }

    @Override
    public T take() {
        try {
            return this.takeInterruptibly();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public T takeInterruptibly() throws InterruptedException {
        T take2 = this.queue.take();
        this.poolableObject.onTake(take2);
        return take2;
    }

    @Override
    public void put(T object) {
        this.poolableObject.onReturn(object);
        this.queue.offer(object);
    }

    @Override
    public T newInstance() {
        return this.poolableObject.create();
    }
}

