/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.INotify;
import dorkbox.notify.LookAndFeel;
import dorkbox.notify.Notify;
import dorkbox.notify.NotifyCanvas;
import dorkbox.notify.Theme;
import dorkbox.util.SwingUtil;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AsApplication
implements INotify {
    private final LookAndFeel look;
    private final Notify notification;
    private final NotifyCanvas notifyCanvas;
    private final JFrame appWindow;
    private final ComponentListener parentListener;
    private final WindowStateListener windowStateListener;
    private static final String glassPanePrefix = "dorkbox.notify";
    private JPanel glassPane;

    AsApplication(Notify notification, ImageIcon image, final JFrame appWindow, Theme theme) {
        this.notification = notification;
        this.notifyCanvas = new NotifyCanvas(this, notification, image, theme);
        this.appWindow = appWindow;
        this.look = new LookAndFeel(this, appWindow, this.notifyCanvas, notification, appWindow.getBounds(), false);
        this.parentListener = new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                AsApplication.this.look.reLayout(appWindow.getBounds());
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AsApplication.this.look.reLayout(appWindow.getBounds());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }
        };
        this.windowStateListener = new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                int state = e.getNewState();
                if ((state & 1) == 0) {
                    AsApplication.this.look.reLayout(appWindow.getBounds());
                }
            }
        };
        appWindow.addWindowStateListener(this.windowStateListener);
        appWindow.addComponentListener(this.parentListener);
        Component glassPane_ = appWindow.getGlassPane();
        if (glassPane_ instanceof JPanel) {
            this.glassPane = (JPanel)glassPane_;
            String name = this.glassPane.getName();
            if (!name.equals(glassPanePrefix)) {
                this.glassPane.setLayout(null);
                this.glassPane.setName(glassPanePrefix);
            }
            this.glassPane.add(this.notifyCanvas);
            if (!this.glassPane.isVisible()) {
                this.glassPane.setVisible(true);
            }
        } else {
            System.err.println("Not able to add notification to custom glassPane");
        }
    }

    @Override
    public void onClick(int x, int y) {
        this.look.onClick(x, y);
    }

    @Override
    public void shake(int durationInMillis, int amplitude) {
        this.look.shake(durationInMillis, amplitude);
    }

    @Override
    public void setVisible(boolean visible) {
        this.look.updatePositionsPre(visible);
        this.look.updatePositionsPost(visible);
    }

    @Override
    public void close() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component[] components;
                AsApplication.this.look.close();
                AsApplication.this.glassPane.remove(AsApplication.this.notifyCanvas);
                AsApplication.this.appWindow.removeWindowStateListener(AsApplication.this.windowStateListener);
                AsApplication.this.appWindow.removeComponentListener(AsApplication.this.parentListener);
                boolean found = false;
                for (Component component : components = AsApplication.this.glassPane.getComponents()) {
                    if (!(component instanceof NotifyCanvas)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    AsApplication.this.glassPane.setVisible(false);
                }
                AsApplication.this.notification.onClose();
            }
        });
    }
}

