/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.core.util.FastField;
import com.thoughtworks.xstream.mapper.AttributeMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.HashMap;
import java.util.Map;

public class LocalConversionMapper
extends MapperWrapper {
    private final Map localConverters = new HashMap();
    private transient AttributeMapper attributeMapper;

    public LocalConversionMapper(Mapper wrapped) {
        super(wrapped);
        this.readResolve();
    }

    public void registerLocalConverter(Class definedIn, String fieldName, Converter converter) {
        this.localConverters.put(new FastField(definedIn, fieldName), converter);
    }

    public Converter getLocalConverter(Class definedIn, String fieldName) {
        return (Converter)this.localConverters.get(new FastField(definedIn, fieldName));
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type2) {
        SingleValueConverter converter = this.getLocalSingleValueConverter(definedIn, attribute, type2);
        return converter == null ? super.getConverterFromAttribute(definedIn, attribute, type2) : converter;
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type2, Class definedIn) {
        SingleValueConverter converter = this.getLocalSingleValueConverter(definedIn, fieldName, type2);
        return converter == null ? super.getConverterFromItemType(fieldName, type2, definedIn) : converter;
    }

    private SingleValueConverter getLocalSingleValueConverter(Class definedIn, String fieldName, Class type2) {
        Converter converter;
        if (this.attributeMapper != null && this.attributeMapper.shouldLookForSingleValueConverter(fieldName, type2, definedIn) && (converter = this.getLocalConverter(definedIn, fieldName)) != null && converter instanceof SingleValueConverter) {
            return (SingleValueConverter)((Object)converter);
        }
        return null;
    }

    private Object readResolve() {
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        return this;
    }
}

