/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributeMapper
extends MapperWrapper {
    private final Map fieldNameToTypeMap = new HashMap();
    private final Set typeSet = new HashSet();
    private ConverterLookup converterLookup;
    private ReflectionProvider reflectionProvider;
    private final Set fieldToUseAsAttribute = new HashSet();

    public AttributeMapper(Mapper wrapped) {
        this(wrapped, null, null);
    }

    public AttributeMapper(Mapper wrapped, ConverterLookup converterLookup, ReflectionProvider refProvider) {
        super(wrapped);
        this.converterLookup = converterLookup;
        this.reflectionProvider = refProvider;
    }

    public void setConverterLookup(ConverterLookup converterLookup) {
        this.converterLookup = converterLookup;
    }

    public void addAttributeFor(String fieldName, Class type2) {
        this.fieldNameToTypeMap.put(fieldName, type2);
    }

    public void addAttributeFor(Class type2) {
        this.typeSet.add(type2);
    }

    private SingleValueConverter getLocalConverterFromItemType(Class type2) {
        Converter converter = this.converterLookup.lookupConverterForType(type2);
        if (converter != null && converter instanceof SingleValueConverter) {
            return (SingleValueConverter)((Object)converter);
        }
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type2) {
        if (this.fieldNameToTypeMap.get(fieldName) == type2) {
            return this.getLocalConverterFromItemType(type2);
        }
        return null;
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type2, Class definedIn) {
        SingleValueConverter converter;
        if (this.shouldLookForSingleValueConverter(fieldName, type2, definedIn) && (converter = this.getLocalConverterFromItemType(type2)) != null) {
            return converter;
        }
        return super.getConverterFromItemType(fieldName, type2, definedIn);
    }

    public boolean shouldLookForSingleValueConverter(String fieldName, Class type2, Class definedIn) {
        if (this.typeSet.contains(type2)) {
            return true;
        }
        if (this.fieldNameToTypeMap.get(fieldName) == type2) {
            return true;
        }
        if (fieldName != null && definedIn != null) {
            Field field = this.reflectionProvider.getFieldOrNull(definedIn, fieldName);
            return field != null && this.fieldToUseAsAttribute.contains(field);
        }
        return false;
    }

    public SingleValueConverter getConverterFromItemType(Class type2) {
        if (this.typeSet.contains(type2)) {
            return this.getLocalConverterFromItemType(type2);
        }
        return null;
    }

    public SingleValueConverter getConverterFromAttribute(String attributeName) {
        SingleValueConverter converter = null;
        Class type2 = (Class)this.fieldNameToTypeMap.get(attributeName);
        if (type2 != null) {
            converter = this.getLocalConverterFromItemType(type2);
        }
        return converter;
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute) {
        Field field = this.reflectionProvider.getFieldOrNull(definedIn, attribute);
        return field != null ? this.getConverterFromAttribute(definedIn, attribute, field.getType()) : null;
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type2) {
        SingleValueConverter converter;
        if (this.shouldLookForSingleValueConverter(attribute, type2, definedIn) && (converter = this.getLocalConverterFromItemType(type2)) != null) {
            return converter;
        }
        return super.getConverterFromAttribute(definedIn, attribute, type2);
    }

    public void addAttributeFor(Field field) {
        if (field != null) {
            this.fieldToUseAsAttribute.add(field);
        }
    }

    public void addAttributeFor(Class definedIn, String fieldName) {
        this.addAttributeFor(this.reflectionProvider.getField(definedIn, fieldName));
    }
}

