/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSingleValueConverter
extends AbstractSingleValueConverter {
    private final Class<? extends Enum> enumType;

    public EnumSingleValueConverter(Class<? extends Enum> type2) {
        if (!Enum.class.isAssignableFrom(type2) && type2 != Enum.class) {
            throw new IllegalArgumentException("Converter can only handle defined enums");
        }
        this.enumType = type2;
    }

    @Override
    public boolean canConvert(Class type2) {
        return type2 != null && this.enumType.isAssignableFrom(type2);
    }

    @Override
    public String toString(Object obj2) {
        return ((Enum)Enum.class.cast(obj2)).name();
    }

    @Override
    public Object fromString(String str) {
        Enum result2 = Enum.valueOf(this.enumType, str);
        return result2;
    }
}

