/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class EnumConverter
implements Converter {
    public boolean canConvert(Class type2) {
        return type2 != null && type2.isEnum() || Enum.class.isAssignableFrom(type2);
    }

    public void marshal(Object source2, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(((Enum)source2).name());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type2 = context.getRequiredType();
        if (type2.getSuperclass() != Enum.class) {
            type2 = type2.getSuperclass();
        }
        String name = reader.getValue();
        try {
            return Enum.valueOf(type2, name);
        }
        catch (IllegalArgumentException e) {
            for (Enum c : (Enum[])type2.getEnumConstants()) {
                if (!c.name().equalsIgnoreCase(name)) continue;
                return c;
            }
            throw e;
        }
    }
}

