/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.SecurityUtil;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class PropertyAccess {
    public static final String jnlp_prefix = "jnlp.";
    public static final String javaws_prefix = "javaws.";
    static final HashSet<String> trustedPrefixes = new HashSet();
    static final HashSet<String> trusted;

    protected static final void addTrustedPrefix(String string2) throws AccessControlException {
        SecurityUtil.checkAllPermissions();
        trustedPrefixes.add(string2);
    }

    public static final boolean isTrusted(String string2) {
        int n = string2.indexOf(46);
        if (0 <= n) {
            return trustedPrefixes.contains(string2.substring(0, n + 1)) || trusted.contains(string2);
        }
        return false;
    }

    public static final int getIntProperty(String string2, boolean bl, int n) {
        int n2 = n;
        try {
            String string3 = PropertyAccess.getProperty(string2, bl);
            if (null != string3) {
                n2 = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static final long getLongProperty(String string2, boolean bl, long l) {
        long l2 = l;
        try {
            String string3 = PropertyAccess.getProperty(string2, bl);
            if (null != string3) {
                l2 = Long.parseLong(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    public static final boolean getBooleanProperty(String string2, boolean bl) {
        return Boolean.valueOf(PropertyAccess.getProperty(string2, bl));
    }

    public static final boolean getBooleanProperty(String string2, boolean bl, boolean bl2) {
        String string3 = PropertyAccess.getProperty(string2, bl);
        if (null != string3) {
            return Boolean.valueOf(string3);
        }
        return bl2;
    }

    public static final boolean isPropertyDefined(String string2, boolean bl) {
        return PropertyAccess.getProperty(string2, bl) != null;
    }

    public static final String getProperty(String string2, boolean bl) throws SecurityException, NullPointerException, IllegalArgumentException {
        if (null == string2) {
            throw new NullPointerException("propertyKey is NULL");
        }
        if (0 == string2.length()) {
            throw new IllegalArgumentException("propertyKey is empty");
        }
        String string3 = null;
        string3 = PropertyAccess.isTrusted(string2) ? PropertyAccess.getTrustedPropKey(string2) : System.getProperty(string2);
        if (null == string3 && bl && !string2.startsWith(jnlp_prefix)) {
            string3 = PropertyAccess.getTrustedPropKey(jnlp_prefix + string2);
        }
        return string3;
    }

    public static final String getProperty(String string2, boolean bl, String string3) throws SecurityException, NullPointerException, IllegalArgumentException {
        String string4 = PropertyAccess.getProperty(string2, bl);
        if (null != string4) {
            return string4;
        }
        return string3;
    }

    private static final String getTrustedPropKey(final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(string2);
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Could not access trusted property '" + string2 + "'", securityException);
                }
            }
        });
    }

    static {
        trustedPrefixes.add(javaws_prefix);
        trustedPrefixes.add(jnlp_prefix);
        trusted = new HashSet();
        trusted.add("sun.java2d.opengl");
        trusted.add("sun.java2d.noddraw");
        trusted.add("sun.java2d.d3d");
        trusted.add("sun.awt.noerasebackground");
    }
}

