/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Classes {
    public static boolean isInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
    }

    public static boolean isConcrete(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !clazz.isInterface() && !Modifier.isAbstract(modifiers);
    }

    public static String toString(Member member) {
        Class<? extends Member> memberType = Classes.memberType(member);
        if (memberType == Method.class) {
            String string2 = member.getDeclaringClass().getName();
            String string3 = member.getName();
            return new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(".").append(string3).append("()").toString();
        }
        if (memberType == Field.class) {
            String string4 = member.getDeclaringClass().getName();
            String string5 = member.getName();
            return new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string4).append(".").append(string5).toString();
        }
        if (memberType == Constructor.class) {
            return String.valueOf(member.getDeclaringClass().getName()).concat(".<init>()");
        }
        throw new AssertionError();
    }

    public static Class<? extends Member> memberType(Member member) {
        Preconditions.checkNotNull(member, "member");
        if (member instanceof Field) {
            return Field.class;
        }
        if (member instanceof Method) {
            return Method.class;
        }
        if (member instanceof Constructor) {
            return Constructor.class;
        }
        String string2 = String.valueOf(member.getClass());
        throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string2).length()).append("Unsupported implementation class for Member, ").append(string2).toString());
    }
}

