/*
 * Decompiled with CFR 0.152.
 */
package com.displee.compress.type;

import com.displee.io.impl.InputBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010\t\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/displee/compress/type/GZIPCompressor;", "", "()V", "gzipBuffer", "", "inflater", "Ljava/util/zip/Inflater;", "deflate", "data", "deflate317", "inflate", "", "buffer", "Lcom/displee/io/impl/InputBuffer;", "inflate317", "uncompressed", "rs-cache-library"})
public final class GZIPCompressor {
    private static Inflater inflater;
    private static final byte[] gzipBuffer;
    public static final GZIPCompressor INSTANCE;

    public final boolean inflate(@NotNull InputBuffer buffer, @NotNull byte[] data2) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        byte[] bytes = buffer.raw();
        int offset = buffer.getOffset();
        if (bytes[offset] != 31 || bytes[offset + 1] != -117) {
            return false;
        }
        Inflater inflater = GZIPCompressor.inflater;
        if (inflater == null) {
            Inflater inflater2 = new Inflater(true);
            boolean bl = false;
            boolean bl2 = false;
            Inflater it = inflater2;
            boolean bl3 = false;
            GZIPCompressor.inflater = it;
            inflater = inflater2;
        }
        Inflater inflater3 = inflater;
        try {
            inflater3.setInput(bytes, offset + 10, bytes.length - (10 + offset + 8));
            inflater3.inflate(data2);
        }
        catch (Exception exception) {
            inflater3.reset();
            return false;
        }
        inflater3.reset();
        return true;
    }

    @NotNull
    public final byte[] deflate(@NotNull byte[] data2) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(compressed);
            gzipOutputStream.write(data2);
            gzipOutputStream.finish();
            gzipOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] byArray = compressed.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "compressed.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] inflate317(@NotNull byte[] uncompressed) {
        Intrinsics.checkParameterIsNotNull(uncompressed, "uncompressed");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            Closeable closeable = new GZIPOutputStream(bout);
            boolean bl = false;
            Throwable throwable = null;
            try {
                GZIPOutputStream os = (GZIPOutputStream)closeable;
                boolean bl2 = false;
                os.write(uncompressed);
                os.finish();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] byArray = bout.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "bout.toByteArray()");
        return byArray;
    }

    @NotNull
    public final byte[] deflate317(@Nullable byte[] data2) {
        int read2 = 0;
        try {
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(data2));
            while (true) {
                if (read2 == gzipBuffer.length) {
                    throw (Throwable)new RuntimeException("buffer overflow!");
                }
                int length = gis.read(gzipBuffer, read2, gzipBuffer.length - read2);
                if (length != -1) {
                    read2 += length;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw (Throwable)new RuntimeException("error unzipping");
        }
        byte[] deflated = new byte[read2];
        System.arraycopy(gzipBuffer, 0, deflated, 0, deflated.length);
        return deflated;
    }

    private GZIPCompressor() {
    }

    static {
        GZIPCompressor gZIPCompressor;
        INSTANCE = gZIPCompressor = new GZIPCompressor();
        gzipBuffer = new byte[1000000];
    }
}

