/*
 * Decompiled with CFR 0.152.
 */
package com.displee.cache.index;

import com.displee.cache.CacheLibrary;
import com.displee.cache.ProgressListener;
import com.displee.cache.index.Index255;
import com.displee.cache.index.ReferenceTable;
import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.ArchiveSector;
import com.displee.compress.CompressionExtKt;
import com.displee.compress.CompressionType;
import com.displee.io.Buffer;
import com.displee.io.impl.InputBuffer;
import com.displee.io.impl.OutputBuffer;
import com.displee.util.OtherExtKt;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0006\u0010*\u001a\u00020(J\u000e\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\nJ\u0011\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0014J\b\u00103\u001a\u00020(H\u0014J\u0010\u00104\u001a\u00020\n2\u0006\u00102\u001a\u00020\u0005H\u0014J\u0010\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u0004\u001a\u00020\u0005J\b\u00107\u001a\u00020\u001cH\u0016J\u0006\u00108\u001a\u00020(J\u0014\u0010,\u001a\u00020\n2\n\b\u0002\u00109\u001a\u0004\u0018\u00010:H\u0017J\u0016\u0010;\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\"R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006>"}, d2={"Lcom/displee/cache/index/Index;", "Lcom/displee/cache/index/ReferenceTable;", "origin", "Lcom/displee/cache/CacheLibrary;", "id", "", "raf", "Ljava/io/RandomAccessFile;", "(Lcom/displee/cache/CacheLibrary;ILjava/io/RandomAccessFile;)V", "cached", "", "closed", "getClosed", "()Z", "setClosed", "(Z)V", "compressionType", "Lcom/displee/compress/CompressionType;", "getCompressionType", "()Lcom/displee/compress/CompressionType;", "setCompressionType", "(Lcom/displee/compress/CompressionType;)V", "crc", "getCrc", "()I", "setCrc", "(I)V", "info", "", "getInfo", "()Ljava/lang/String;", "getRaf", "()Ljava/io/RandomAccessFile;", "whirlpool", "", "getWhirlpool", "()[B", "setWhirlpool", "([B)V", "cache", "", "clear", "close", "fixCRCs", "update", "flaggedArchives", "", "Lcom/displee/cache/index/archive/Archive;", "()[Lcom/displee/cache/index/archive/Archive;", "indexToWrite", "index", "init", "isIndexValid", "readArchiveSector", "Lcom/displee/cache/index/archive/ArchiveSector;", "toString", "unCache", "listener", "Lcom/displee/cache/ProgressListener;", "writeArchiveSector", "data", "Companion", "rs-cache-library"})
public class Index
extends ReferenceTable {
    private int crc;
    @Nullable
    private byte[] whirlpool;
    @NotNull
    private CompressionType compressionType;
    private boolean cached;
    private boolean closed;
    @NotNull
    private final RandomAccessFile raf;
    public static final int INDEX_SIZE = 6;
    public static final int SECTOR_HEADER_SIZE_SMALL = 8;
    public static final int SECTOR_DATA_SIZE_SMALL = 512;
    public static final int SECTOR_HEADER_SIZE_BIG = 10;
    public static final int SECTOR_DATA_SIZE_BIG = 510;
    public static final int SECTOR_SIZE = 520;
    public static final int WHIRLPOOL_SIZE = 64;
    public static final Companion Companion = new Companion(null);

    public final int getCrc() {
        return this.crc;
    }

    public final void setCrc(int n) {
        this.crc = n;
    }

    @Nullable
    public final byte[] getWhirlpool() {
        return this.whirlpool;
    }

    public final void setWhirlpool(@Nullable byte[] byArray) {
        this.whirlpool = byArray;
    }

    @NotNull
    public final CompressionType getCompressionType() {
        return this.compressionType;
    }

    public final void setCompressionType(@NotNull CompressionType compressionType) {
        Intrinsics.checkParameterIsNotNull((Object)compressionType, "<set-?>");
        this.compressionType = compressionType;
    }

    protected final boolean getClosed() {
        return this.closed;
    }

    protected final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final String getInfo() {
        return "Index[id=" + this.getId() + ", archives=" + this.getArchives().size() + ", compression=" + (Object)((Object)this.compressionType) + "]";
    }

    protected void init() {
        if (this.getId() < 0 || this.getId() >= 255) {
            return;
        }
        Object object = this.getOrigin().getIndex255();
        if (object == null || (object = ((Index)object).readArchiveSector(this.getId())) == null) {
            return;
        }
        Object archiveSector = object;
        byte[] archiveSectorData = ((ArchiveSector)archiveSector).getData();
        this.crc = OtherExtKt.generateCrc$default(archiveSectorData, 0, 0, 3, null);
        this.whirlpool = OtherExtKt.generateWhirlpool$default(archiveSectorData, 0, 0, 3, null);
        this.read(new InputBuffer(CompressionExtKt.decompress$default((ArchiveSector)archiveSector, null, 1, null)));
        this.compressionType = ((ArchiveSector)archiveSector).getCompressionType();
    }

    public final void cache() {
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Index is closed.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (this.cached) {
            return;
        }
        Collection<Archive> collection = this.getArchives().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "archives.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Archive it = (Archive)element$iv;
            boolean bl5 = false;
            try {
                this.archive(it.getId(), it.getXtea$rs_cache_library(), false);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.cached = true;
    }

    public final void unCache() {
        for (Archive archive : this.archives()) {
            archive.restore();
        }
        this.cached = false;
    }

    @JvmOverloads
    public boolean update(@Nullable ProgressListener listener) {
        block9: {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "Index is closed.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            Archive[] flaggedArchives = this.flaggedArchives();
            double i = 0.0;
            Archive[] $this$forEach$iv2 = flaggedArchives;
            boolean $i$f$forEach = false;
            Archive[] archiveArray = $this$forEach$iv2;
            int n = archiveArray.length;
            for (int j = 0; j < n; ++j) {
                Archive element$iv;
                Archive it = element$iv = archiveArray[j];
                boolean bl5 = false;
                double d = i;
                i = d + 1.0;
                Archive archive = it;
                int n2 = archive.getRevision();
                archive.setRevision(n2 + 1);
                it.unFlag();
                ProgressListener progressListener = listener;
                if (progressListener != null) {
                    progressListener.notify(i / (double)flaggedArchives.length * 0.8, "Repacking archive " + it.getId() + "...");
                }
                byte[] byArray = it.write();
                CompressionType compressionType = it.getCompressionType();
                if (compressionType == null) {
                    compressionType = CompressionType.GZIP;
                }
                byte[] compressed = CompressionExtKt.compress(byArray, compressionType, it.getXtea$rs_cache_library(), it.getRevision());
                it.setCrc(OtherExtKt.generateCrc$default(compressed, 0, compressed.length - 2, 1, null));
                it.setWhirlpool(OtherExtKt.generateWhirlpool$default(compressed, 0, compressed.length - 2, 1, null));
                boolean written = this.writeArchiveSector(it.getId(), compressed);
                boolean bl6 = false;
                boolean bl7 = false;
                if (!written) {
                    boolean bl8 = false;
                    String string3 = "Unable to write data to archive sector. Your cache may be corrupt.";
                    throw (Throwable)new IllegalStateException(string3.toString());
                }
                if (!this.getOrigin().getClearDataAfterUpdate()) continue;
                it.restore();
            }
            ProgressListener progressListener = listener;
            if (progressListener != null) {
                progressListener.notify(0.85, "Updating checksum table for index " + this.getId() + "...");
            }
            $this$forEach$iv2 = flaggedArchives;
            $i$f$forEach = false;
            archiveArray = $this$forEach$iv2;
            n = 0;
            if (!(archiveArray.length == 0) && !this.flagged()) {
                this.flag();
            }
            if (this.flagged()) {
                this.unFlag();
                Index index = this;
                int $this$forEach$iv2 = index.getRevision();
                index.setRevision($this$forEach$iv2 + 1);
                byte[] indexData = CompressionExtKt.compress$default(this.write(), this.compressionType, null, 0, 6, null);
                this.crc = OtherExtKt.generateCrc$default(indexData, 0, 0, 3, null);
                this.whirlpool = OtherExtKt.generateWhirlpool$default(indexData, 0, 0, 3, null);
                Index255 index255 = this.getOrigin().getIndex255();
                boolean written = index255 != null ? index255.writeArchiveSector(this.getId(), indexData) : false;
                boolean bl9 = false;
                n = 0;
                if (!written) {
                    boolean bl10 = false;
                    String string4 = "Unable to write data to checksum table. Your cache may be corrupt.";
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
            }
            ProgressListener progressListener2 = listener;
            if (progressListener2 == null) break block9;
            progressListener2.notify(1.0, "Successfully updated index " + this.getId() + '.');
        }
        return true;
    }

    public static /* synthetic */ boolean update$default(Index index, ProgressListener progressListener, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 1) != 0) {
            progressListener = null;
        }
        return index.update(progressListener);
    }

    @JvmOverloads
    public boolean update() {
        return Index.update$default(this, null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final ArchiveSector readArchiveSector(int id) {
        boolean bl = !this.closed;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Index is closed.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        RandomAccessFile randomAccessFile = this.getOrigin().getMainFile();
        bl2 = false;
        bl3 = false;
        synchronized (randomAccessFile) {
            boolean bl5 = false;
            try {
                int sectorDataSize;
                if (this.getOrigin().getMainFile().length() < (long)(6 * id + 6)) {
                    return null;
                }
                byte[] sectorData = new byte[520];
                this.raf.seek((long)id * (long)6);
                this.raf.read(sectorData, 0, 6);
                boolean bigSector = id > 65535;
                InputBuffer buffer = new InputBuffer(sectorData);
                ArchiveSector archiveSector = new ArchiveSector(bigSector, buffer.read24BitInt(), buffer.read24BitInt(), 0, 0, 24, null);
                if (archiveSector.getSize() < 0) return null;
                if (archiveSector.getPosition() <= 0) return null;
                if ((long)archiveSector.getPosition() > this.getOrigin().getMainFile().length() / (long)520) {
                    return null;
                }
                int read2 = 0;
                int chunk = 0;
                int sectorHeaderSize = bigSector ? 10 : 8;
                int n = sectorDataSize = bigSector ? 510 : 512;
                while (true) {
                    if (read2 >= archiveSector.getSize()) {
                        return archiveSector;
                    }
                    if (archiveSector.getPosition() == 0) {
                        return null;
                    }
                    int requiredToRead = archiveSector.getSize() - read2;
                    if (requiredToRead > sectorDataSize) {
                        requiredToRead = sectorDataSize;
                    }
                    this.getOrigin().getMainFile().seek((long)archiveSector.getPosition() * (long)520);
                    this.getOrigin().getMainFile().read(buffer.raw(), 0, requiredToRead + sectorHeaderSize);
                    buffer.setOffset(0);
                    archiveSector.read(buffer);
                    if (!this.isIndexValid(archiveSector.getIndex())) return null;
                    if (id != archiveSector.getId()) return null;
                    if (chunk != archiveSector.getChunk()) {
                        return null;
                    }
                    if (archiveSector.getNextPosition() < 0) return null;
                    if ((long)archiveSector.getNextPosition() > this.getOrigin().getMainFile().length() / (long)520) {
                        return null;
                    }
                    byte[] bufferData = buffer.raw();
                    int n2 = 0;
                    int n3 = requiredToRead;
                    while (n2 < n3) {
                        void i;
                        archiveSector.getData()[read2++] = bufferData[i + sectorHeaderSize];
                        ++i;
                    }
                    archiveSector.setPosition(archiveSector.getNextPosition());
                    ++chunk;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Unit unit = Unit.INSTANCE;
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean writeArchiveSector(int id, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        var3_3 = this.closed == false;
        var4_5 = false;
        var5_6 = false;
        if (!var3_3) {
            $i$a$-check-Index$writeArchiveSector$1 = false;
            var5_7 = "Index is closed.";
            throw (Throwable)new IllegalStateException(var5_7.toString());
        }
        var3_4 = this.getOrigin().getMainFile();
        var4_5 = false;
        var5_6 = false;
        synchronized (var3_4) {
            $i$a$-synchronized-Index$writeArchiveSector$2 = false;
            try {
                position = 0;
                archive = null;
                archiveSector = this.readArchiveSector(id);
                if (this.getId() != 255) {
                    archive = this.archive(id, null, true);
                }
                if (this.getId() == 255 && archiveSector != null) ** GOTO lbl-1000
                v0 = archive;
                if (v0 != null && !v0.getNew()) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                overWrite = v1;
                sectorData = new byte[520];
                v2 = bigSector = id > 65535;
                if (overWrite) {
                    if ((long)(6 * id + 6) > this.raf.length()) {
                        return false;
                    }
                    this.raf.seek((long)id * (long)6);
                    this.raf.read(sectorData, 0, 6);
                    buffer = new InputBuffer(sectorData);
                    v3 = buffer;
                    v3.setOffset(v3.getOffset() + 3);
                    position = buffer.read24BitInt();
                    if (position <= 0) return false;
                    if ((long)position > this.getOrigin().getMainFile().length() / (long)520) {
                        return false;
                    }
                } else {
                    position = (int)((this.getOrigin().getMainFile().length() + (long)519) / (long)520);
                    if (position == 0) {
                        position = 1;
                    }
                    archiveSector = new ArchiveSector(bigSector, data.length, position, id, this.indexToWrite(this.getId()));
                }
                if (archiveSector == null) {
                    return false;
                }
                buffer = new OutputBuffer(6);
                buffer.write24BitInt(data.length);
                buffer.write24BitInt(position);
                this.raf.seek((long)id * (long)6);
                this.raf.write(Buffer.array$default(buffer, 0, 0, 3, null), 0, 6);
                written = 0;
                chunk = 0;
                archiveHeaderSize = bigSector != false ? 10 : 8;
                archiveDataSize = bigSector != false ? 510 : 512;
                while (written < data.length) {
                    currentPosition = 0;
                    if (overWrite) {
                        this.getOrigin().getMainFile().seek((long)position * (long)520);
                        this.getOrigin().getMainFile().read(sectorData, 0, archiveHeaderSize);
                        archiveSector.read(new InputBuffer(sectorData));
                        currentPosition = archiveSector.getNextPosition();
                        if (archiveSector.getId() != id) return false;
                        if (archiveSector.getChunk() != chunk) return false;
                        if (!this.isIndexValid(archiveSector.getIndex())) {
                            return false;
                        }
                        if (currentPosition < 0) return false;
                        if (this.getOrigin().getMainFile().length() / (long)520 < (long)currentPosition) {
                            return false;
                        }
                    }
                    if (currentPosition == 0) {
                        overWrite = false;
                        currentPosition = (int)((this.getOrigin().getMainFile().length() + (long)519) / (long)520);
                        if (currentPosition == 0) {
                            ++currentPosition;
                        }
                        if (currentPosition == position) {
                            ++currentPosition;
                        }
                    }
                    if (data.length - written <= archiveDataSize) {
                        currentPosition = 0;
                    }
                    archiveSector.setChunk(chunk);
                    archiveSector.setPosition(currentPosition);
                    this.getOrigin().getMainFile().seek((long)position * (long)520);
                    this.getOrigin().getMainFile().write(archiveSector.write(), 0, archiveHeaderSize);
                    length = data.length - written;
                    if (length > archiveDataSize) {
                        length = archiveDataSize;
                    }
                    this.getOrigin().getMainFile().write(data, written, length);
                    written += length;
                    position = currentPosition;
                    ++chunk;
                }
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
        }
    }

    public final void fixCRCs(boolean update2) {
        Object object;
        boolean flag;
        block13: {
            block12: {
                boolean bl = !this.closed;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string2 = "Index is closed.";
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                if (this.is317()) {
                    return;
                }
                int[] archiveIds = this.archiveIds();
                flag = false;
                for (int i : archiveIds) {
                    Archive archive;
                    ArchiveSector sector;
                    if (this.readArchiveSector(i) == null) {
                        continue;
                    }
                    int correctCRC = OtherExtKt.generateCrc$default(sector.getData(), 0, sector.getData().length - 2, 1, null);
                    if (ReferenceTable.archive$default((ReferenceTable)this, i, false, 2, null) == null) {
                        continue;
                    }
                    int currentCRC = archive.getCrc();
                    if (currentCRC == correctCRC) continue;
                    String string2 = "Incorrect CRC in index " + this.getId() + " -> archive " + i + ", current_crc=" + currentCRC + ", correct_crc=" + correctCRC;
                    boolean bl4 = false;
                    System.out.println((Object)string2);
                    archive.flag();
                    flag = true;
                }
                object = this.getOrigin().getIndex255();
                if (object == null || (object = ((Index)object).readArchiveSector(this.getId())) == null) break block12;
                byte[] byArray = ((ArchiveSector)object).getData();
                object = byArray;
                if (byArray != null) break block13;
            }
            return;
        }
        Object sectorData = object;
        int indexCRC = OtherExtKt.generateCrc$default((byte[])sectorData, 0, 0, 3, null);
        if (this.crc != indexCRC) {
            flag = true;
        }
        if (flag && update2) {
            Index.update$default(this, null, 1, null);
        } else if (!flag) {
            String string3 = "No invalid CRCs found.";
            int n = 0;
            System.out.println((Object)string3);
            return;
        }
        this.unCache();
    }

    public final void clear() {
        this.getArchives().clear();
        this.crc = 0;
        this.whirlpool = new byte[64];
    }

    public final void close() {
        if (this.closed) {
            return;
        }
        this.raf.close();
        this.closed = true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Archive[] flaggedArchives() {
        void $this$filterTo$iv$iv;
        Collection<Archive> collection = this.getArchives().values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "archives.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Archive it = (Archive)element$iv$iv;
            boolean bl = false;
            if (!it.flagged()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Archive[] archiveArray = thisCollection$iv.toArray(new Archive[0]);
        if (archiveArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return archiveArray;
    }

    protected boolean isIndexValid(int index) {
        return this.getId() == index;
    }

    protected int indexToWrite(int index) {
        return index;
    }

    @NotNull
    public String toString() {
        return "Index " + this.getId();
    }

    @NotNull
    public final RandomAccessFile getRaf() {
        return this.raf;
    }

    public Index(@NotNull CacheLibrary origin, int id, @NotNull RandomAccessFile raf) {
        Intrinsics.checkParameterIsNotNull(origin, "origin");
        Intrinsics.checkParameterIsNotNull(raf, "raf");
        super(origin, id);
        this.raf = raf;
        this.compressionType = CompressionType.NONE;
        this.init();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/displee/cache/index/Index$Companion;", "", "()V", "INDEX_SIZE", "", "SECTOR_DATA_SIZE_BIG", "SECTOR_DATA_SIZE_SMALL", "SECTOR_HEADER_SIZE_BIG", "SECTOR_HEADER_SIZE_SMALL", "SECTOR_SIZE", "WHIRLPOOL_SIZE", "rs-cache-library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

