/*
 * Decompiled with CFR 0.152.
 */
package com.client.utilities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class JsonUtil {
    private static ObjectMapper jsonMapper = new ObjectMapper();
    private static ObjectWriter jsonWriter = null;
    private static ObjectMapper yamlMapper = new ObjectMapper(new YAMLFactory());
    private static ObjectWriter yamlWriter = null;

    @Deprecated
    public static <T> void toJson(T t, String filePath) {
        Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = prettyGson.toJson(t);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(filePath)));
            bw.write(prettyJson);
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static <T> T fromJson(String filePath) throws IOException {
        return JsonUtil.fromJson(filePath, new TypeToken<T>(){});
    }

    @Deprecated
    public static <T> T fromJson(String filePath, TypeToken<T> typeToken) throws IOException {
        return new Gson().fromJson(FileUtils.readFileToString(new File(filePath)), typeToken.getType());
    }

    @Deprecated
    public static <T> T fromJsonOrDefault(String filePath, TypeToken<T> typeToken, T defaultObject) throws IOException {
        if (!new File(filePath).exists()) {
            return defaultObject;
        }
        return JsonUtil.fromJson(filePath, typeToken);
    }

    public static <T> T fromJsonString(String jsonString, TypeToken<T> typeToken) throws IOException {
        return new Gson().fromJson(jsonString, typeToken.getType());
    }

    public static <T> String toJsonString(T object) throws IOException {
        return new Gson().toJson(object);
    }

    public static <T> void toJacksonJson(T t, String filePath) throws IOException {
        jsonWriter.writeValue(new File(filePath), t);
    }

    public static <T> T fromJacksonJson(String filePath, TypeReference clazz) throws IOException {
        return jsonMapper.readValue(new File(filePath), clazz);
    }

    public static <T> void toYaml(T t, String filePath) throws IOException {
        yamlWriter.writeValue(new File(filePath), t);
    }

    public static <T> T fromYaml(String filePath, TypeReference clazz) throws IOException {
        return yamlMapper.readValue(new File(filePath), clazz);
    }

    static {
        Lists.newArrayList(jsonMapper, yamlMapper).stream().forEach(it -> {
            it.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
            it.setVisibility((VisibilityChecker<?>)it.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        });
        jsonWriter = jsonMapper.writerWithDefaultPrettyPrinter();
        yamlWriter = yamlMapper.writerWithDefaultPrettyPrinter();
    }
}

