/*
 * Decompiled with CFR 0.152.
 */
package com.client.soundeffects;

import com.client.Buffer;
import com.client.soundeffects.Synthesizer;

public final class SoundEffects {
    private static final SoundEffects[] effects = new SoundEffects[5000];
    public static final int[] delays = new int[5000];
    private static byte[] output;
    private static Buffer riff;
    private final Synthesizer[] synthesizers = new Synthesizer[10];
    private int loopStart;
    private int loopEnd;

    private SoundEffects() {
    }

    public static void unpack(Buffer stream) {
        output = new byte[441000];
        riff = new Buffer(output);
        Synthesizer.init();
        int id;
        while ((id = stream.readUShort()) != 65535) {
            SoundEffects.effects[id] = new SoundEffects();
            effects[id].decode(stream);
            SoundEffects.delays[id] = effects[id].calculateDelay();
        }
        return;
    }

    public static Buffer data(int loops, int id) {
        if (effects[id] != null) {
            SoundEffects soundTrack = effects[id];
            return soundTrack.pack(loops);
        }
        return null;
    }

    private void decode(Buffer stream) {
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            int valid = stream.readUnsignedByte();
            if (valid == 0) continue;
            --stream.currentPosition;
            this.synthesizers[synthesizer] = new Synthesizer();
            this.synthesizers[synthesizer].decode(stream);
        }
        this.loopStart = stream.readUShort();
        this.loopEnd = stream.readUShort();
    }

    private int calculateDelay() {
        int offset = 9999999;
        for (int syntheziser = 0; syntheziser < 10; ++syntheziser) {
            if (this.synthesizers[syntheziser] == null || this.synthesizers[syntheziser].offset / 20 >= offset) continue;
            offset = this.synthesizers[syntheziser].offset / 20;
        }
        if (this.loopStart < this.loopEnd && this.loopStart / 20 < offset) {
            offset = this.loopStart / 20;
        }
        if (offset == 9999999 || offset == 0) {
            return 0;
        }
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.synthesizers[synthesizer] == null) continue;
            this.synthesizers[synthesizer].offset -= offset * 20;
        }
        if (this.loopStart < this.loopEnd) {
            this.loopStart -= offset * 20;
            this.loopEnd -= offset * 20;
        }
        return offset;
    }

    private Buffer pack(int loops) {
        int size = this.mix(loops);
        SoundEffects.riff.currentPosition = 0;
        riff.writeDWord(1380533830);
        riff.method403(36 + size);
        riff.writeDWord(1463899717);
        riff.writeDWord(1718449184);
        riff.method403(16);
        riff.method400(1);
        riff.method400(1);
        riff.method403(22050);
        riff.method403(22050);
        riff.method400(1);
        riff.method400(8);
        riff.writeDWord(1684108385);
        riff.method403(size);
        SoundEffects.riff.currentPosition += size;
        return riff;
    }

    private int mix(int loops) {
        int duration = 0;
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.synthesizers[synthesizer] == null || this.synthesizers[synthesizer].duration + this.synthesizers[synthesizer].offset <= duration) continue;
            duration = this.synthesizers[synthesizer].duration + this.synthesizers[synthesizer].offset;
        }
        if (duration == 0) {
            return 0;
        }
        int sampleCount = 22050 * duration / 1000;
        int loopStart = 22050 * this.loopStart / 1000;
        int loopEnd = 22050 * this.loopEnd / 1000;
        if (loopStart < 0 || loopStart > sampleCount || loopEnd < 0 || loopEnd > sampleCount || loopStart >= loopEnd) {
            loops = 0;
        }
        int size = sampleCount + (loopEnd - loopStart) * (loops - 1);
        for (int offset = 44; offset < size + 44; ++offset) {
            SoundEffects.output[offset] = -128;
        }
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.synthesizers[synthesizer] == null) continue;
            int synthDuration = this.synthesizers[synthesizer].duration * 22050 / 1000;
            int synthOffset = this.synthesizers[synthesizer].offset * 22050 / 1000;
            int[] samples = this.synthesizers[synthesizer].synthesize(synthDuration, this.synthesizers[synthesizer].duration);
            for (int sample2 = 0; sample2 < synthDuration; ++sample2) {
                int n = sample2 + synthOffset + 44;
                output[n] = (byte)(output[n] + (byte)(samples[sample2] >> 8));
            }
        }
        if (loops > 1) {
            loopStart += 44;
            loopEnd += 44;
            int k2 = (size += 44) - (sampleCount += 44);
            for (int j3 = sampleCount - 1; j3 >= loopEnd; --j3) {
                SoundEffects.output[j3 + k2] = output[j3];
            }
            for (int k3 = 1; k3 < loops; ++k3) {
                int l2 = (loopEnd - loopStart) * k3;
                System.arraycopy(output, loopStart, output, loopStart + l2, loopEnd - loopStart);
            }
            size -= 44;
        }
        return size;
    }
}

