/*
 * Decompiled with CFR 0.152.
 */
package com.client.skillorbs;

import com.client.Client;
import com.client.Configuration;
import com.client.skillorbs.SkillOrb;

public class SkillOrbs {
    public static final SkillOrb[] orbs = new SkillOrb[25];

    public static void init() {
        for (int i = 0; i < 25; ++i) {
            SkillOrbs.orbs[i] = new SkillOrb(i, Client.instance.smallXpSprites[i]);
        }
    }

    public static void process() {
        if (!Configuration.skillOrbs) {
            return;
        }
        int totalOrbs = 0;
        for (SkillOrb orb : orbs) {
            if (!SkillOrbs.draw(orb)) continue;
            ++totalOrbs;
        }
        boolean blockingInterfaceOpen = Client.instance.openWalkableWidgetID == 23300;
        boolean hpOverlay = Client.getUserSettings().isShowEntityTarget();
        int y = -2;
        int x = (int)((double)Client.canvasWidth / 3.1) - totalOrbs * 30;
        if (blockingInterfaceOpen) {
            x -= totalOrbs * 10;
        } else if (hpOverlay) {
            if (x < 130) {
                x = 130;
            }
            y = 12;
        }
        if (x < 5) {
            x = 5;
        }
        SkillOrb hover = null;
        for (SkillOrb orb : orbs) {
            if (!SkillOrbs.draw(orb)) continue;
            if (orb.getShowTimer().finished()) {
                orb.decrementAlpha();
            }
            orb.draw(x, y);
            if (Client.instance.hover(x, y, Client.instance.skillOrbs[0])) {
                hover = orb;
            }
            if ((x += 62) > (blockingInterfaceOpen ? 300 : 460)) break;
        }
        if (hover != null) {
            hover.drawTooltip();
        }
    }

    private static boolean draw(SkillOrb orb) {
        return !orb.getShowTimer().finished() || orb.getAlpha() > 0;
    }
}

