/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Sprite;
import com.client.StringUtils;
import com.client.TextDrawingArea;
import com.client.graphics.interfaces.RSInterface;

public class QuestTab
extends RSInterface {
    public static final int INTERFACE_ID = 50414;
    public static final int CONFIG_ID = 1355;
    public static final int DEFAULT_SCROLL_MAX = 219;
    public static final int TAB_1 = 10280;
    public static final int TAB_2 = 19050;
    public static final int TAB_3 = 24500;
    public static final int TAB_4 = 50614;
    public static final int[] INTERFACE_PLACEHOLDERS = new int[]{10280, 19050, 24500, 50614};
    private static final String SPRITE_FOLDER = "/Info Tab/";
    private static final String TAB = "/Info Tab/TAB";
    private static final Sprite BIG_BOX = new Sprite("/Info Tab/BIG BOX");
    private static final Sprite SMALL_BOX = new Sprite("/Info Tab/SMALL BOX");
    private static final Sprite TAB_0 = new Sprite("/Info Tab/TAB 0");
    public static final int DEFAULT_CONTAINER_WIDTH = 152;
    private static int containerInterfaceId = 0;
    private static int containerChildIndex = 0;
    private static int containerDefaultX = 0;
    private static int containerDefaultY = 0;
    private static int containerDefaultWidth = 0;
    private static int containerDefaultHeight = 0;
    private static int smallBoxInterfaceId = 0;
    private static int smallBoxChildId = 0;
    private static RSInterface master;

    public static void onConfigChanged(int config, int value) {
        if (config == 1355) {
            for (Button button : Button.values()) {
                if (value != button.ordinal()) continue;
                QuestTab.setContainer(button);
                return;
            }
            throw new IllegalStateException("No button for value: " + value);
        }
    }

    private static void setContainer(Button button) {
        RSInterface placeholder = RSInterface.interfaceCache[button.getPlaceholderInterface()];
        RSInterface container = RSInterface.interfaceCache[containerInterfaceId];
        container.children = placeholder.children;
        container.childX = placeholder.childX;
        container.childY = placeholder.childY;
        container.scrollMax = button.scrollMax;
        container.scrollPosition = 0;
        container.width = button.scrollMax != 0 ? 152 : 177;
        RSInterface containerChild = master.getChild(containerChildIndex);
        if (button == Button.DIARIES) {
            QuestTab.master.childX[QuestTab.containerChildIndex] = 0;
            QuestTab.master.childY[QuestTab.containerChildIndex] = 25;
            containerChild.width = 255;
            containerChild.height = 255;
            QuestTab.master.children[QuestTab.smallBoxChildId] = RSInterface.emptyInterface;
        } else {
            containerChild.width = containerDefaultWidth;
            containerChild.height = containerDefaultHeight;
            QuestTab.master.childX[QuestTab.containerChildIndex] = containerDefaultX;
            QuestTab.master.childY[QuestTab.containerChildIndex] = containerDefaultY;
            QuestTab.master.children[QuestTab.smallBoxChildId] = smallBoxInterfaceId;
        }
    }

    public void load(TextDrawingArea[] tda) {
        QuestTab.questTab(tda);
        QuestTab.infoTab(tda);
        this.tab(tda);
        QuestTab.setContainer(Button.INFORMATION);
        this.questList();
        QuestTab.get(50414).setNewButtonClicking();
    }

    public void tab(TextDrawingArea[] tda) {
        master = QuestTab.addInterface(50414);
        QuestTab.setChildren(3 + Button.values().length * 2, master);
        int childIndex = 0;
        int interfaceId = 50415;
        int x = 5;
        int y = 24;
        QuestTab.addSprite(interfaceId, BIG_BOX);
        master.child(childIndex++, interfaceId++, x, y);
        smallBoxInterfaceId = interfaceId;
        smallBoxChildId = childIndex;
        QuestTab.addSprite(interfaceId, SMALL_BOX);
        master.child(childIndex++, interfaceId++, x + 7, y + 6);
        for (Button button : Button.values()) {
            int tabX = x + button.ordinal() * QuestTab.TAB_0.myWidth - button.ordinal();
            int tabY = y + 1 - QuestTab.TAB_0.myHeight;
            QuestTab.addConfigButton(interfaceId, 50414, 0, 1, TAB, QuestTab.TAB_0.myWidth, QuestTab.TAB_0.myHeight, StringUtils.fixName(button.toString().toLowerCase()), button.ordinal(), 4, 1355);
            RSInterface.interfaceCache[interfaceId].ignoreConfigClicking = true;
            master.child(childIndex++, interfaceId++, tabX, tabY);
            Sprite icon = button.getSprite();
            int iconX = tabX + QuestTab.TAB_0.myWidth / 2 - icon.myWidth / 2;
            int iconY = tabY + QuestTab.TAB_0.myHeight / 2 - icon.myHeight / 2;
            QuestTab.addSprite(interfaceId, icon);
            master.child(childIndex++, interfaceId++, iconX, iconY);
        }
        containerInterfaceId = interfaceId;
        containerChildIndex = childIndex;
        containerDefaultX = x + 7;
        containerDefaultY = y + 7;
        containerDefaultWidth = 152;
        containerDefaultHeight = 218;
        RSInterface container = QuestTab.addInterface(interfaceId);
        master.child(childIndex++, interfaceId++, containerDefaultX, containerDefaultY);
        container.width = containerDefaultWidth;
        container.height = containerDefaultHeight;
        container.scrollMax = 219;
    }

    private void questList() {
        int lines = 20;
        RSInterface inter = QuestTab.addInterface(50614);
        QuestTab.setChildren(lines, inter);
        int y = 8;
        for (int line = 0; line < lines; ++line) {
            inter.child(line, 50615 + line, 8, y);
            RSInterface.addClickableText(50615 + line, "", "Open quest journal", RSInterface.defaultTextDrawingAreas, 0, 16750623, false, true, 140, 16);
            y += 14;
        }
        inter.setNewButtonClicking();
    }

    public static void questTab(TextDrawingArea[] tda) {
        RSInterface tab = QuestTab.addTabInterface(10220);
        QuestTab.addText(10221, "@or1@Control Panel", tda, 2, 0xFF9933, false, true);
        QuestTab.addText(10222, "@or1@OblivionPk.com", tda, 2, 0xFF9933, true, true);
        QuestTab.addSprite(10224, 0, "Interfaces/infoTab/SPRITE");
        QuestTab.addButton(10403, 2, "Interfaces/infoTab/TAB", "Refresh Tab");
        QuestTab.addButton(10404, 4, "Interfaces/infoTab/TAB", "View Diaries");
        QuestTab.addSprite(10223, 1, "Interfaces/infoTab/SPRITE");
        QuestTab.addText(10405, "@cr10@", tda, 2, 0xFF9933, false, true);
        tab.totalChildren(9);
        tab.child(0, 10221, 20, 7);
        tab.child(1, 10222, 95, 240);
        tab.child(2, 10224, 0, 35);
        tab.child(3, 10223, 0, 230);
        tab.child(4, 10403, 172, 15);
        tab.child(5, 10223, 0, 32);
        tab.child(6, 10280, 2, 34);
        tab.child(7, 10404, 154, 15);
        tab.child(8, 10405, 3, 10);
        RSInterface infoList = QuestTab.addTabInterface(10280);
        infoList.height = 196;
        infoList.width = 172;
        infoList.newScroller = false;
        int size = 60;
        infoList.totalChildren(size);
        for (int id = 0; id < size; ++id) {
            int interfaceId = 51901 + id;
            QuestTab.addHoverText(interfaceId, "", "View Details", tda, 0, 1022259, false, true, 150);
            infoList.child(id, interfaceId, 2, 5 + id * 16);
        }
    }

    public static void infoTab(TextDrawingArea[] tda) {
        RSInterface tab = QuestTab.addTabInterface(47500);
        QuestTab.addText(47501, "OblivionPk", tda, 2, 0xFF9933, true, true);
        QuestTab.addHoverText(47502, "Call for help", "Call help", tda, 2, 0xFF9933, true, true, 100);
        QuestTab.addSprite(47503, 0, "Interfaces/infoTab/SPRITE");
        QuestTab.addSprite(47504, 1, "Interfaces/infoTab/SPRITE");
        int childId = 19050;
        RSInterface scroll = QuestTab.addInterface(childId++);
        int scrollFrame = 0;
        scroll.height = 196;
        scroll.width = 174;
        CoinTab[] tabs = new CoinTab[]{new CoinTab("Collection Log", 4, 52, 7), new CoinTab("Monster Kill Log", 5, 62, 7), new CoinTab("Drop Table", 5, 42, 7), new CoinTab("Loot Tables", 6, 46, 4), new CoinTab("World Events", 2, 50, 7), new CoinTab("Task Manager", 7, 50, 5), new CoinTab("Donator Benefits", 3, 62, 7), new CoinTab("Titles", 1, 22, 10), new CoinTab("Community Guides", 2, 65, 7), new CoinTab("Vote Page", 2, 40, 7), new CoinTab("Online Store", 2, 46, 7), new CoinTab("Forums", 2, 30, 7), new CoinTab("OblivionPk Rules", 2, 50, 7), new CoinTab("Call For Help", 2, 50, 7)};
        scroll.scrollMax = tabs.length * 28;
        scroll.totalChildren(tabs.length * 4);
        int startY = 0;
        for (int i = 0; i < tabs.length; ++i) {
            CoinTab coinTab = tabs[i];
            QuestTab.addHoverButton(childId++, "Interfaces/HelpTab/BUTTON", 1, 151, 28, coinTab.string, -1, childId, 1);
            QuestTab.interfaceCache[childId - 1].onClick = new Object[]{68, childId - 1, interfaceCache[childId - 1] + "1"};
            QuestTab.addHoveredButton(childId++, "Interfaces/HelpTab/BUTTON", 0, 151, 28, childId++);
            childId -= 3;
            scroll.child(scrollFrame++, childId++, 2, startY);
            scroll.child(scrollFrame++, childId++, 2, startY);
            QuestTab.addText(++childId, coinTab.string, tda, 2, 0xFF9933, true, true);
            scroll.child(scrollFrame++, childId++, 68, startY + 5);
            QuestTab.addSprite(childId, coinTab.icon, "Interfaces/HelpTab/ICON");
            scroll.child(scrollFrame++, childId++, 66 + coinTab.x, startY + coinTab.y);
            startY += 28;
        }
        tab.totalChildren(5);
        tab.child(0, 47501, 92, 8);
        tab.child(1, 47502, 43, 240);
        tab.child(2, 47503, 1, 35);
        tab.child(3, 47504, 0, 230);
        tab.child(4, 19050, 0, 34);
    }

    private static enum Button {
        INFORMATION(1, 719),
        COIN(2, 369),
        DIARIES(3, 0),
        QUEST_LIST(5, 219);

        private final int spriteId;
        private final int scrollMax;

        private Button(int spriteId, int scrollMax) {
            this.spriteId = spriteId;
            this.scrollMax = scrollMax;
        }

        public Sprite getSprite() {
            return new Sprite("/Info Tab/SYMBOL " + this.spriteId);
        }

        public int getPlaceholderInterface() {
            return INTERFACE_PLACEHOLDERS[this.ordinal()];
        }
    }

    private static class CoinTab {
        private final String string;
        private final int icon;
        private final int x;
        private final int y;

        public CoinTab(String string2, int icon, int x, int y) {
            this.string = string2;
            this.icon = icon;
            this.x = x;
            this.y = y;
        }
    }
}

