/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.TextDrawingArea;
import com.client.graphics.interfaces.RSInterface;

public class LootViewer
extends RSInterface {
    private static final int ID = 44942;
    private static final int BUTTONS = 45010;
    private static final int TABLE_ONE = 45140;
    private static final int TABLE_TWO = 45180;
    private static final boolean PRINT_IDS = false;
    private static final String SPRITES_PATH = "interfaces/lootviewer/sprite";

    public void load(TextDrawingArea[] tda) {
        RSInterface inter = LootViewer.addInterface(44942);
        int nextId = 44943;
        LootViewer.setChildren(6, inter);
        int baseX = 16;
        int baseY = 10;
        LootViewer.addSprite(nextId, 0, SPRITES_PATH);
        inter.child(0, nextId++, 16, 10);
        LootViewer.addText(nextId, "Global Loot Tables", tda, 2, 16748608, true, true);
        inter.child(1, nextId++, 261, 20);
        LootViewer.configHoverButton1(49032, "Close", SPRITES_PATH, 12, 13, 12, 13, false, new int[0]);
        inter.child(2, 49032, 477, 20);
        this.getButtons(tda, 45010);
        inter.child(3, 45010, 24, 47);
        this.getTable(tda, 45140, "");
        this.getTable(tda, 45180, "");
        inter.child(4, 45140, 22, 156);
        inter.child(5, 45180, 263, 156);
    }

    public int getTable(TextDrawingArea[] tda, int id, String header) {
        RSInterface table = LootViewer.addInterface(id++);
        LootViewer.setChildren(4, table);
        int child = 0;
        table.child(child++, id, 108, 0);
        LootViewer.addText(id++, header, tda, 1, 16748608, true, true);
        table.child(child++, id, 0, 0);
        LootViewer.addSprite(id++, 1, SPRITES_PATH);
        RSInterface.interfaceCache[id - 1].setHidden(true);
        table.child(child++, id, 0, 20);
        int scrollId = id;
        RSInterface scroll = LootViewer.addInterface(id++);
        LootViewer.setChildren(1, scroll);
        scroll.width = 216;
        scroll.height = 137;
        scroll.scrollMax = scroll.height + 1;
        scroll.child(0, id, 4, 4);
        LootViewer.addItemContainerAutoScrollable(id++, 5, 36, 12, 4, true, scrollId, new String[0]);
        return id;
    }

    public int getButtons(TextDrawingArea[] tda, int startingId) {
        int id;
        int PARENT_ID = id = startingId;
        RSInterface bar = LootViewer.addInterface(id++);
        bar.height = 80;
        bar.width = 471;
        bar.scrollMax = (int)(41.9 * (double)Button.values().length);
        bar.horizontalScroll = true;
        int buttonCount = Button.values().length;
        LootViewer.setChildren(buttonCount * 3, bar);
        int child = 0;
        int colX = 0;
        int colIndex = 0;
        for (int i = 0; i < buttonCount; ++i) {
            Button b = Button.values()[i];
            int rowY = (int)((double)colIndex * 27.8);
            bar.child(child++, id, colX, rowY);
            LootViewer.addConfigButton(id, PARENT_ID, 1, 2, SPRITES_PATH, 117, 26, b.name, i, 4, 1354);
            RSInterface.interfaceCache[id].ignoreConfigClicking = true;
            bar.child(child++, ++id, colX + 45, rowY + 7);
            LootViewer.addText(id++, b.name, tda, 0, 16748608, true, true);
            bar.child(child++, id, colX + 95, rowY + 4);
            LootViewer.addItemView(id++, b.itemId + 1, true, true);
            ++colIndex;
            if ((i + 1) % 3 != 0) continue;
            colX += 119;
            colIndex = 0;
        }
        return id;
    }

    private static enum Button {
        STARTERBOX("Starter Box", 6680),
        PVM_CASKET("PvM Casket", 405),
        SLAYER_MYSTERY_CHEST("Slayer Chest", 13438),
        CRYSTAL_CHEST("Crystal Chest", 989),
        BRIMSTONE_KEY("Brimstone Key", 23083),
        SLAYER_CHEST("Slayer Key's", 28421),
        HESPORI_KEY("Hespori Key", 22374),
        PORAZDIRS_KEY("Unbearable Key", 4185),
        SERENS_KEY("Seren's Key", 6792),
        LARRANS_CHEST("Larran's Chest", 23490),
        VOTE_KEY("Vote Key", 22093),
        PRESTIGEBOX("Prestige Box", 12585),
        HUNNLEFS_KEY("Hunnlef's Key", 23776),
        XERIC_CHESTS("COX Chest", 20851),
        TOB_CHEST("TOB Chest", 8151),
        TOACHEST("TOA Chest", 27387),
        ARBOGRAVE("Crypt Chest", 2400),
        TEKKO("Tekko Chest", 29523),
        COXC("Xeric's Chest", 11708),
        WILDERNESS_CHEST("Wildyman Chest", 13302),
        MATCHGAME("Match-Game", 3578),
        VOTE_MYSTERY_BOX("Vote M Box", 11739),
        COSMETIC_BOX("Cosmetic Box", 19897),
        MYSTERY_BOX("Mystery Box", 6199),
        SUPER_MYSTERY_BOX("Super M Box", 6828),
        ULTRA_MYSTERY_BOX("Ultra M Box", 13346),
        COX_BOX("COX Box", 12582),
        TOB_BOX("TOB Box", 19891),
        TOABOX("TOA Box", 6677),
        ARBO_BOX("Crypt Box", 12579),
        XERICIANBOX("Xerician Box", 38165),
        DIVISION_F2P(" F2P Box", 6831),
        DIVISION_P2P(" P2P Box", 6829),
        DONO_BOX("Donator Box", 12588),
        CHANCEBOX("Box of Chance", 6679),
        FORTUNE("Crypt Plunder", 6805),
        LEGENDS("Box of Legends", 6678),
        MAGICAL("Magical Chest", 8152),
        VAULT("Vaults", 25454);

        private final String name;
        private final int itemId;

        private Button(String name, int itemId) {
            this.name = name;
            this.itemId = itemId;
        }
    }
}

