/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.Sprite;
import com.client.graphics.interfaces.RSInterface;
import com.google.common.collect.Lists;
import java.util.List;

public class DonatorRewards
extends RSInterface {
    public static final int INTERFACE_ID = 22693;
    private static final Sprite BG = new Sprite("donator_rewards/BACKGROUND");
    private static final Sprite BAR = new Sprite("donator_rewards/BAR");
    private static final Sprite BAR_SHADOW = new Sprite("donator_rewards/BAR_SHADOW");
    private static final Sprite BOX = new Sprite("donator_rewards/BOX");
    private static final Sprite BOX_HIGHLIGHTED = new Sprite("donator_rewards/BOX_HIGHLIGHTED");
    private static final DonatorRewards INSTANCE = new DonatorRewards();
    private int progressBarId;
    private int pricingItemContainer;
    private List<RSInterface> progressBars = Lists.newArrayList();

    public static DonatorRewards getInstance() {
        return INSTANCE;
    }

    private DonatorRewards() {
    }

    public void load() {
        int interfaceId = 22693;
        int childId = 0;
        RSInterface inter = DonatorRewards.addInterface(interfaceId++);
        inter.totalChildren(27);
        DonatorRewards.addSprite(interfaceId, BG);
        inter.child(childId++, interfaceId++, 64, 84);
        DonatorRewards.addText(interfaceId, 2, 0xFF9933, true, "Weekly Donation Rewards");
        inter.child(childId++, interfaceId++, 254, 98);
        inter.child(childId++, 37302, 428, 98);
        inter.child(childId++, 37303, 428, 98);
        DonatorRewards.addText(interfaceId, 0, 0xFF9933, true, "Week ends in 1d 4hrs");
        inter.child(childId++, interfaceId++, 254, 234);
        DonatorRewards.addSprite(interfaceId, BAR);
        inter.child(childId++, interfaceId++, 91, 196);
        for (int index = 0; index < 6; ++index) {
            int y = 156;
            int x = 99 + index * 57;
            DonatorRewards.addConfigSprite(interfaceId, BOX, BOX_HIGHLIGHTED, index, 1374);
            inter.child(childId++, interfaceId++, x, y);
            DonatorRewards.addText(interfaceId, 0, 0xFF9933, true, "$100");
            inter.child(childId++, interfaceId++, x + 18, y - 12);
        }
        ++interfaceId;
        ++interfaceId;
        DonatorRewards.addItemContainer(++interfaceId, 6, 1, 25, 0, true, new String[0]);
        inter.child(childId++, interfaceId++, 104, 160);
        this.pricingItemContainer = interfaceId;
        DonatorRewards.addItemContainer(interfaceId, 6, 1, 0, 0, true, new String[0]);
        ++interfaceId;
        this.progressBars.clear();
        int x = 92;
        for (int index = 0; index < 6; ++index) {
            DonatorRewards.addProgressBarReal(interfaceId, 0, 12, 5480275);
            this.progressBars.add(DonatorRewards.get(interfaceId));
            inter.child(childId++, interfaceId++, x, 211);
            if (index == 0) {
                x += 27;
                continue;
            }
            x += 56;
        }
        DonatorRewards.addSprite(interfaceId, BAR_SHADOW);
        DonatorRewards.get((int)interfaceId).drawsTransparent = true;
        DonatorRewards.get((int)interfaceId).transparency = 70;
        inter.child(childId++, interfaceId++, 92, 211);
        DonatorRewards.addText(interfaceId, 0, 0xFF9933, true, "$100 / $500");
        inter.child(childId++, interfaceId++, 258, 211);
    }

    public void onConfigChanged(int configId, int value) {
        if (configId == 1375) {
            Client.instance.variousSettings[1374] = 6;
            for (int index = 0; index < this.progressBars.size(); ++index) {
                int maxWidth;
                int n = maxWidth = index == 0 ? 27 : 57;
                if (value > this.priceForIndex(index)) {
                    this.progressBars.get((int)index).width = maxWidth;
                    continue;
                }
                int totalPriceDifferential = this.progressForIndex(value, index);
                double percentage = (int)((double)totalPriceDifferential / (double)this.priceDifferenceForIndex(index) * 100.0);
                if (percentage > 100.0) {
                    percentage = 100.0;
                }
                if (percentage < 0.0) {
                    percentage = 0.0;
                }
                this.progressBars.get((int)index).width = (int)((double)maxWidth * (percentage / 100.0));
                if (!(percentage < 100.0) || Client.instance.variousSettings[1374] != 6) continue;
                Client.instance.variousSettings[1374] = index;
            }
        }
    }

    private int priceForIndex(int index) {
        return DonatorRewards.get((int)this.pricingItemContainer).inventoryAmounts[index];
    }

    private int priceDifferenceForIndex(int index) {
        if (index == 0) {
            return this.priceForIndex(0);
        }
        return this.priceForIndex(index) - this.priceForIndex(index - 1);
    }

    private int progressForIndex(int totalSpent, int index) {
        if (index == 0) {
            return totalSpent;
        }
        return totalSpent - this.priceForIndex(index - 1);
    }
}

