/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.impl;

import com.client.Client;
import com.client.Sprite;
import com.client.graphics.interfaces.RSInterface;
import com.client.model.Spell;
import com.google.common.base.Preconditions;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Autocast
extends RSInterface {
    private static final Autocast SINGLETON = new Autocast();
    public static final int AUTOCAST_MENU_ACTION_ID = 1755;
    public static final int BUTTON_START_INTERFACE_ID = 28801;
    private static final Set<Spell> autocastable;
    private static final Sprite SPRITE_STANDARD;
    private static final Sprite SPRITE_DEFENSIVE;
    private boolean loaded = false;
    private List<RSInterface> autocasts = new ArrayList<RSInterface>();

    public static Autocast getSingleton() {
        return SINGLETON;
    }

    private Autocast() {
    }

    public void load() {
        if (!this.loaded) {
            this.loaded = true;
            int interfaceId = 28801;
            for (Spell autocast : autocastable) {
                RSInterface spell = Autocast.get(autocast.getId());
                RSInterface container = Autocast.get(autocast.getSpellBook().getInterfaceId());
                Preconditions.checkState(container != null);
                Preconditions.checkState(spell != null);
                int spellChildIndex = RSInterface.getIndexOfChild(container, autocast.getId());
                Preconditions.checkState(spellChildIndex != -1);
                int x = container.childX[spellChildIndex];
                int y = container.childY[spellChildIndex];
                RSInterface.expandChildren(3, container);
                Autocast.addSprite(interfaceId, SPRITE_STANDARD);
                Point spriteOffset = this.getSpriteOffset(autocast);
                container.child(container.children.length - 3, interfaceId, x + spriteOffset.x, y + spriteOffset.y);
                Autocast.get((int)interfaceId).sprite1 = null;
                Autocast.get((int)interfaceId).active = false;
                ++interfaceId;
                for (int i = 2; i > 0; --i) {
                    this.autocast(interfaceId, autocast.toString(), spell.width, spell.height, autocast.getId(), i == 2, spell);
                    container.child(container.children.length - i, interfaceId, x, y);
                    ++interfaceId;
                }
            }
        }
    }

    private void autocast(int interfaceId, String spellName, int width, int height, int spellId, boolean defensive, RSInterface spellInterface) {
        RSInterface autocastChild = Autocast.addInterface(interfaceId);
        autocastChild.id = interfaceId;
        autocastChild.parentID = interfaceId;
        autocastChild.type = 5;
        autocastChild.atActionType = 50;
        autocastChild.contentType = 0;
        autocastChild.opacity = 0;
        autocastChild.hoverType = 52;
        autocastChild.width = width;
        autocastChild.height = height;
        autocastChild.tooltip = "Autocast " + (defensive ? "defensive " : "") + "@gre@" + spellName;
        autocastChild.autocastSpellId = spellId;
        autocastChild.autocastDefensive = defensive;
        this.autocasts.add(autocastChild);
        autocastChild.mOverInterToTrigger = spellInterface.mOverInterToTrigger;
    }

    private int getAutocastSpriteInterfaceId(RSInterface rsInterface) {
        return rsInterface.autocastDefensive ? rsInterface.id - 1 : rsInterface.id - 2;
    }

    public void onConfigChanged(int config, int value) {
        block3: {
            block2: {
                if (config != 1370) break block2;
                for (RSInterface autocast : this.autocasts) {
                    Autocast.get((int)this.getAutocastSpriteInterfaceId((RSInterface)autocast)).sprite2 = value == 1 ? SPRITE_DEFENSIVE : SPRITE_STANDARD;
                }
                break block3;
            }
            if (config != 1369) break block3;
            boolean defensive = Client.instance.variousSettings[1370] == 1;
            for (RSInterface autocast : this.autocasts) {
                RSInterface rsInterface = Autocast.get(this.getAutocastSpriteInterfaceId(autocast));
                rsInterface.active = autocast.autocastSpellId == value;
            }
        }
    }

    private Point getSpriteOffset(Spell spell) {
        switch (spell) {
            case WIND_STRIKE: 
            case WATER_STRIKE: 
            case EARTH_STRIKE: 
            case FIRE_STRIKE: 
            case WIND_BOLT: 
            case WATER_BOLT: 
            case EARTH_BOLT: 
            case FIRE_BOLT: 
            case WIND_BLAST: 
            case WATER_BAST: 
            case EARTH_BLAST: 
            case FIRE_BLAST: 
            case WIND_WAVE: 
            case WATER_WAVE: 
            case EARTH_WAVE: 
            case FIRE_WAVE: 
            case SMOKE_RUSH: 
            case SHADOW_RUSH: 
            case BLOOD_RUSH: 
            case ICE_RUSH: 
            case SMOKE_BURST: 
            case SHADOW_BURST: 
            case BLOOD_BURST: 
            case ICE_BURST: 
            case SMOKE_BLITZ: 
            case SHADOW_BLITZ: 
            case BLOOD_BLITZ: 
            case ICE_BLITZ: 
            case SMOKE_BARRAGE: 
            case SHADOW_BARRAGE: 
            case BLOOD_BARRAGE: 
            case ICE_BARRAGE: {
                return new Point(-2, -2);
            }
            case WIND_SURGE: 
            case WATER_SURGE: 
            case EARTH_SURGE: 
            case FIRE_SURGE: {
                return new Point(0, 0);
            }
        }
        return new Point(0, 0);
    }

    static {
        SPRITE_STANDARD = new Sprite("autocast");
        SPRITE_DEFENSIVE = new Sprite("autocast_defensive");
        autocastable = Collections.unmodifiableSet(Arrays.stream(Spell.values()).filter(Spell::isAutocastable).collect(Collectors.toSet()));
    }
}

