/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.builder.impl.tasks;

import com.client.graphics.interfaces.RSInterface;
import com.client.graphics.interfaces.builder.impl.tasks.AchievementFilter;
import com.client.graphics.interfaces.builder.impl.tasks.TaskEntryInterfaceBuilder;
import com.client.graphics.interfaces.builder.impl.tasks.TaskInterface;
import com.client.graphics.interfaces.builder.impl.tasks.TaskInterfaceSub;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskEntry;
import com.client.graphics.interfaces.builder.impl.tasks.model.TaskEntryType;
import com.client.sign.Signlink;
import com.client.utilities.JsonUtil;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TaskInterfaceActions {
    private final TaskInterface inter;
    private List<TaskEntry> achievements = Lists.newArrayList();
    private List<TaskEntry> diaries = Lists.newArrayList();
    private AchievementFilter filter = AchievementFilter.ALL;

    public TaskInterfaceActions(TaskInterface inter) {
        this.inter = inter;
    }

    public void loadAchievements() {
        try {
            this.achievements = JsonUtil.fromJson(Signlink.getCacheDirectory() + "etc/achievements.json", new TypeToken<List<TaskEntry>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setOpen(TaskEntryType type2) {
        TaskInterfaceSub sub = this.inter.byType(type2);
        this.inter.state = sub.getType();
        RSInterface.get((int)this.inter.containerInterfaceId).children[0] = sub.getInterfaceId();
        Arrays.stream(this.inter.subs).forEach(it -> it.setButtonState(this.inter.state == it.getType()));
    }

    public void onButtonClick(int buttonId) {
        this.setOpen(TaskEntryType.ACHIEVEMENTS);
    }

    public void setFilter(AchievementFilter filter2) {
        if (this.filter != filter2) {
            this.filter = filter2;
            this.addEntries(TaskEntryType.ACHIEVEMENTS, this.getAchievements());
            this.inter.byType((TaskEntryType)TaskEntryType.ACHIEVEMENTS).getEntryContainer().scrollPosition = 0;
        }
    }

    public void setAchievements(List<TaskEntry> entries2) {
        this.achievements = entries2;
        this.addEntries(TaskEntryType.ACHIEVEMENTS, this.getAchievements());
    }

    public List<TaskEntry> getAchievements() {
        return this.achievements;
    }

    public void setDiaries(List<TaskEntry> entries2) {
        this.diaries = entries2;
        this.addEntries(TaskEntryType.DIARIES, entries2);
    }

    public List<TaskEntry> getDiaries() {
        return this.diaries;
    }

    public void setProgress(TaskEntryType type2, String title, List<String> progress, boolean claimed) {
        boolean achievements = type2 == TaskEntryType.ACHIEVEMENTS;
        List<TaskEntry> tasks = achievements ? this.getAchievements() : this.getDiaries();
        tasks.stream().filter(it -> it.getTitle().equals(title)).forEach(it -> {
            it.setProgress(progress);
            it.setClaimed(claimed);
        });
        if (achievements) {
            this.setAchievements(this.getAchievements());
        }
    }

    private void addEntries(TaskEntryType type2, List<TaskEntry> entries2) {
        TaskInterfaceSub sub = this.inter.byType(type2);
        int interfacePointer = sub.getEntryBasePointer();
        ArrayList<RSInterface> entryInterfaces = Lists.newArrayList();
        for (TaskEntry entry : entries2) {
            if (entry.isFiltered(this.filter)) {
                interfacePointer += TaskEntryInterfaceBuilder.achievementsInterfaceSize;
                continue;
            }
            TaskEntryInterfaceBuilder builder = new TaskEntryInterfaceBuilder(type2, interfacePointer, entry);
            builder.build();
            entryInterfaces.add(RSInterface.get(interfacePointer));
            int size = builder.getCurrentInterfaceId() - interfacePointer;
            if (type2 == TaskEntryType.ACHIEVEMENTS && size != TaskEntryInterfaceBuilder.achievementsInterfaceSize) {
                System.err.println("Incorrect interface size id=" + interfacePointer + ", size=" + size + ", expected=" + TaskEntryInterfaceBuilder.achievementsInterfaceSize);
            }
            interfacePointer = builder.getCurrentInterfaceId();
        }
        sub.setEntries(entryInterfaces);
    }
}

