/*
 * Decompiled with CFR 0.152.
 */
package com.client.graphics.interfaces.builder;

import com.client.graphics.interfaces.RSInterface;

public abstract class InterfaceBuilder
extends RSInterface {
    private final int baseInterfaceId;
    private final RSInterface root;
    private int nextChildId;
    private int nextInterfaceId;

    public abstract void build();

    public InterfaceBuilder(int baseInterfaceId) {
        this.baseInterfaceId = baseInterfaceId;
        this.root = RSInterface.addInterface(baseInterfaceId);
        this.root.totalChildren(0);
        this.init();
    }

    public void init() {
        this.nextChildId = 0;
        this.nextInterfaceId = this.baseInterfaceId + 1;
    }

    public void child(int x, int y) {
        this.root.child(this.nextChild(), this.nextInterfaceId - 1, x, y);
    }

    public void child(int interfaceId, int x, int y) {
        this.root.child(this.nextChild(), interfaceId, x, y);
    }

    public int getBaseInterfaceId() {
        return this.baseInterfaceId;
    }

    public int nextChild() {
        RSInterface.expandChildren(1, this.root);
        return this.nextChildId++;
    }

    public int lastInterface() {
        return this.nextInterfaceId - 1;
    }

    public int nextInterface() {
        return this.nextInterfaceId++;
    }

    public int getCurrentInterfaceId() {
        return this.nextInterfaceId;
    }

    public void setNextInterfaceId(int nextInterfaceId) {
        this.nextInterfaceId = nextInterfaceId;
    }

    public RSInterface getLastChild() {
        return RSInterface.get(this.nextInterfaceId - 1);
    }

    public RSInterface getRoot() {
        return this.root;
    }
}

