/*
 * Decompiled with CFR 0.152.
 */
package com.client.features.settings;

import com.client.Buffer;
import com.client.FileArchive;
import com.client.utilities.FileOperations;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;

public class InformationFile {
    private final Path FILE_LOCATION = Paths.get(System.getProperty("user.home"), "OblivionPk".toLowerCase() + "_account_data.dat");
    private boolean usernameRemembered;
    private boolean passwordRemembered;
    private boolean rememberRoof = false;
    private boolean rememberVisibleItemNames;
    private String storedUsername = new String();
    private String storedPassword = new String();

    public void write() throws IOException {
        Files.deleteIfExists(this.FILE_LOCATION);
        Files.createFile(this.FILE_LOCATION, new FileAttribute[0]);
        Buffer stream = Buffer.create();
        stream.writeByte(0);
        stream.writeByte(this.usernameRemembered ? 1 : 0);
        stream.writeByte(1);
        stream.writeHiddenString(this.storedUsername);
        stream.writeByte(2);
        stream.writeByte(this.rememberRoof ? 1 : 0);
        stream.writeByte(3);
        stream.writeByte(this.rememberVisibleItemNames ? 1 : 0);
        stream.writeByte(4);
        stream.writeByte(this.passwordRemembered ? 1 : 0);
        stream.writeByte(5);
        stream.writeHiddenString(this.storedPassword);
        FileOperations.writeFile(this.FILE_LOCATION.toString(), Arrays.copyOf(stream.payload, stream.currentPosition));
    }

    public void read() throws IOException, IllegalStateException {
        File file = this.FILE_LOCATION.toFile();
        if (!file.exists()) {
            return;
        }
        byte[] buffer = FileArchive.getBytesFromFile(file);
        Buffer stream = new Buffer(buffer);
        block8: while (stream.currentPosition < buffer.length) {
            byte opcode = stream.readSignedByte();
            switch (opcode) {
                case 0: {
                    this.usernameRemembered = stream.readSignedByte() == 1;
                    continue block8;
                }
                case 1: {
                    this.storedUsername = stream.readHiddenString();
                    continue block8;
                }
                case 2: {
                    this.rememberRoof = stream.readSignedByte() == 1;
                    continue block8;
                }
                case 3: {
                    this.rememberVisibleItemNames = stream.readSignedByte() == 1;
                    continue block8;
                }
                case 4: {
                    this.passwordRemembered = stream.readSignedByte() == 1;
                    continue block8;
                }
                case 5: {
                    this.storedPassword = stream.readHiddenString();
                    continue block8;
                }
            }
            throw new IllegalStateException("Opcode #" + opcode + " does not exist.");
        }
    }

    public void setStoredUsername(String storedUsername) {
        this.storedUsername = storedUsername;
    }

    public String getStoredUsername() {
        return this.storedUsername;
    }

    public void setStoredPassword(String storedPassword) {
        this.storedPassword = storedPassword;
    }

    public String getStoredPassword() {
        return this.storedPassword;
    }

    public void setUsernameRemembered(boolean usernameRemembered) {
        this.usernameRemembered = usernameRemembered;
    }

    public void setPasswordRemembered(boolean passwordRemembered) {
        this.passwordRemembered = passwordRemembered;
    }

    public boolean isUsernameRemembered() {
        return this.usernameRemembered;
    }

    public boolean isPasswordRemembered() {
        return this.passwordRemembered;
    }

    public boolean isRememberRoof() {
        return this.rememberRoof;
    }

    public void setRememberRoof(boolean rememberRoof) {
        this.rememberRoof = rememberRoof;
    }

    public boolean isRememberVisibleItemNames() {
        return this.rememberVisibleItemNames;
    }

    public void setRememberVisibleItemNames(boolean rememberVisibleItemNames) {
        this.rememberVisibleItemNames = rememberVisibleItemNames;
    }
}

