/*
 * Decompiled with CFR 0.152.
 */
package com.client.features.gametimers;

import com.client.Client;
import com.client.Rasterizer2D;
import com.client.Sprite;
import com.client.definitions.ItemDefinition;
import com.client.features.gametimers.GameTimer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class GameTimerHandler {
    private static final GameTimerHandler SINGLETON = new GameTimerHandler();
    private static final SimpleDateFormat SDF = new SimpleDateFormat("mm:ss");
    public static final byte AMOUNT_OF_TIMERS = 25;
    private final List<GameTimer> timers = new ArrayList<GameTimer>();
    public static final Sprite[] TIMER_IMAGES = new Sprite[25];

    private GameTimerHandler() {
    }

    public void startGameTimer(int id, TimeUnit unitOfTime, int duration, int itemId) throws IllegalArgumentException {
        if (itemId == 0 && (id < 0 || id > 24)) {
            throw new IllegalArgumentException("The id cannot exceed that of the allowed amount.");
        }
        GameTimer toAdd = itemId > 0 ? new GameTimer(id, ItemDefinition.lookup(itemId), unitOfTime, duration) : new GameTimer(id, unitOfTime, duration);
        for (int index = 0; index < this.timers.size(); ++index) {
            GameTimer timer = this.timers.get(index);
            if (timer == null || timer.getTimerId() != id) continue;
            this.timers.set(index, toAdd);
            return;
        }
        this.timers.add(toAdd);
    }

    public void stopAll() {
        this.timers.clear();
    }

    public boolean hasActiveGameTimers() {
        return Client.getUserSettings().isGameTimers() && !this.timers.isEmpty();
    }

    public void drawGameTimers(Client client, int x, int y) throws ParseException {
        int drawingWidth = 0;
        int drawingHeight = 44;
        for (GameTimer timer : this.timers) {
            if (timer == null || timer.isStopped()) continue;
            if (timer.isCompleted() || timer.getSprite() == null) {
                timer.stop();
                continue;
            }
            drawingWidth += 34;
        }
        if (drawingWidth == 0) {
            return;
        }
        Rasterizer2D.drawAlphaBox(x -= drawingWidth, y, drawingWidth, drawingHeight, 0, 63);
        Rasterizer2D.drawAlphaBox(x, y, drawingWidth, 1, 0xCBBB99, 80);
        Rasterizer2D.drawAlphaBox(x + drawingWidth - 1, y, 1, drawingHeight, 0xCBBB99, 80);
        Rasterizer2D.drawAlphaBox(x, y + 1, 1, drawingHeight - 1, 0xCBBB99, 80);
        x += 2;
        for (GameTimer timer : this.timers) {
            if (timer == null || timer.isStopped() || timer.getSprite() == null) continue;
            timer.getSprite().drawCenteredSprite(x + 15, y + 17);
            client.newSmallFont.drawCenteredString(SDF.format(timer.getSecondsRemaining() * 1000), x + 15, y + 42, 0xFFFFFF, 0);
            x += 34;
        }
    }

    public static final GameTimerHandler getSingleton() {
        return SINGLETON;
    }
}

