/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions.server;

import com.client.model.EquipmentModelType;
import com.client.model.SkillLevel;
import com.client.sign.Signlink;
import com.client.utilities.JsonUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ItemDef {
    private static final Logger log = Logger.getLogger(ItemDef.class.getName());
    private static Map<Integer, ItemDef> definitions = null;
    private static final List<SkillLevel> EMPTY_REQUIREMENTS = Lists.newArrayList();
    private final int id;
    private final String name;
    private final String description;
    private final int shopValue;
    private final int noteId;
    private final boolean noted;
    private final boolean stackable;
    private final boolean untradeable;
    private final boolean deletedOnDeath;
    private final boolean checkBeforeDrop;
    private final boolean undroppable;
    private final EquipmentModelType equipmentModelType;
    private final List<SkillLevel> requirements;

    public static Map<Integer, ItemDef> getDefinitions() {
        return definitions;
    }

    public static void load() throws Exception {
        definitions = new HashMap<Integer, ItemDef>();
        List list = (List)JsonUtil.fromYaml(Signlink.getCacheDirectory() + "etc/item_definitions.yaml", new TypeReference<List<ItemDef>>(){});
        list.forEach(it -> definitions.put(it.getId(), (ItemDef)it));
        log.info("Loaded " + list.size() + " item definitions.");
    }

    public static ItemDef forId(int itemId) {
        Preconditions.checkState(definitions != null, "Item definitions weren't loaded.");
        return definitions.getOrDefault(itemId, ItemDef.builder().id(itemId).build());
    }

    public static ItemDefBuilder builderOf(ItemDef def) {
        ItemDefBuilder builder = new ItemDefBuilder().id(def.id).name(def.name).description(def.description).shopValue(def.shopValue).noteId(def.noteId).noted(def.noted).stackable(def.stackable).untradeable(def.untradeable).deletedOnDeath(def.deletedOnDeath).checkBeforeDrop(def.checkBeforeDrop).undroppable(def.undroppable).equipmentModelType(def.equipmentModelType).requirements(def.requirements);
        Preconditions.checkState(builder.build().equals(def));
        return builder;
    }

    public ItemDef(int id, String name, String description2, int shopValue, int noteId, boolean noted, boolean stackable, boolean untradeable, boolean deletedOnDeath, boolean checkBeforeDrop, boolean undroppable, EquipmentModelType equipmentModelType, List<SkillLevel> requirements) {
        this.id = id;
        this.name = name;
        this.description = description2;
        this.shopValue = shopValue;
        this.noteId = noteId;
        this.noted = noted;
        this.stackable = stackable;
        this.untradeable = untradeable;
        this.deletedOnDeath = deletedOnDeath;
        this.checkBeforeDrop = checkBeforeDrop;
        this.undroppable = undroppable;
        this.equipmentModelType = equipmentModelType;
        this.requirements = requirements;
    }

    private ItemDef() {
        this.id = -1;
        this.name = "";
        this.description = "";
        this.shopValue = 0;
        this.noteId = 0;
        this.noted = false;
        this.stackable = false;
        this.untradeable = false;
        this.deletedOnDeath = false;
        this.checkBeforeDrop = false;
        this.undroppable = false;
        this.equipmentModelType = null;
        this.requirements = null;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            return "unknown item " + this.getId();
        }
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getShopValue() {
        if (this.noted && !ItemDef.forId(this.noteId).isNoted()) {
            return ItemDef.forId(this.noteId).getShopValue();
        }
        return this.shopValue;
    }

    public int getRawShopValue() {
        return this.shopValue;
    }

    public int getNoteId() {
        return this.noteId;
    }

    public boolean isNoted() {
        return this.noted;
    }

    public boolean isStackable() {
        return this.stackable || this.isNoted();
    }

    @JsonIgnore
    public boolean isTradable() {
        return !this.untradeable;
    }

    public boolean isDeletedOnDeath() {
        return this.deletedOnDeath;
    }

    public boolean isCheckBeforeDrop() {
        return this.checkBeforeDrop;
    }

    @JsonIgnore
    public boolean isDroppable() {
        return !this.undroppable;
    }

    public List<SkillLevel> getRequirements() {
        return this.requirements == null ? EMPTY_REQUIREMENTS : this.requirements;
    }

    public EquipmentModelType getEquipmentModelType() {
        return this.equipmentModelType;
    }

    public String toString() {
        return "ItemDef{id=" + this.id + ", name='" + this.name + "', description='" + this.description + "', shopValue=" + this.shopValue + ", noteId=" + this.noteId + ", noted=" + this.noted + ", stackable=" + this.stackable + ", untradeable=" + this.untradeable + ", deletedOnDeath=" + this.deletedOnDeath + ", checkBeforeDrop=" + this.checkBeforeDrop + ", undroppable=" + this.undroppable + ", equipmentModelType=" + this.equipmentModelType + ", requirements=" + this.requirements + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDef itemDef = (ItemDef)o;
        return this.id == itemDef.id && this.shopValue == itemDef.shopValue && this.noteId == itemDef.noteId && this.noted == itemDef.noted && this.stackable == itemDef.stackable && this.untradeable == itemDef.untradeable && this.deletedOnDeath == itemDef.deletedOnDeath && this.checkBeforeDrop == itemDef.checkBeforeDrop && this.undroppable == itemDef.undroppable && Objects.equals(this.name, itemDef.name) && Objects.equals(this.description, itemDef.description) && this.equipmentModelType == itemDef.equipmentModelType && Objects.equals(this.requirements, itemDef.requirements);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.shopValue, this.noteId, this.noted, this.stackable, this.untradeable, this.deletedOnDeath, this.checkBeforeDrop, this.undroppable, this.equipmentModelType, this.requirements});
    }

    public static ItemDefBuilder builder() {
        return new ItemDefBuilder();
    }

    public static class ItemDefBuilder {
        private int id;
        private String name;
        private String description;
        private int shopValue;
        private int noteId;
        private boolean noted;
        private boolean stackable;
        private boolean untradeable;
        private boolean deletedOnDeath;
        private boolean checkBeforeDrop;
        private boolean undroppable;
        private EquipmentModelType equipmentModelType;
        private List<SkillLevel> requirements;

        ItemDefBuilder() {
        }

        public ItemDefBuilder id(int id) {
            this.id = id;
            return this;
        }

        public ItemDefBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ItemDefBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        public ItemDefBuilder shopValue(int shopValue) {
            this.shopValue = shopValue;
            return this;
        }

        public ItemDefBuilder noteId(int noteId) {
            this.noteId = noteId;
            return this;
        }

        public ItemDefBuilder noted(boolean noted) {
            this.noted = noted;
            return this;
        }

        public ItemDefBuilder stackable(boolean stackable) {
            this.stackable = stackable;
            return this;
        }

        public ItemDefBuilder untradeable(boolean untradeable) {
            this.untradeable = untradeable;
            return this;
        }

        public ItemDefBuilder deletedOnDeath(boolean deletedOnDeath) {
            this.deletedOnDeath = deletedOnDeath;
            return this;
        }

        public ItemDefBuilder checkBeforeDrop(boolean checkBeforeDrop) {
            this.checkBeforeDrop = checkBeforeDrop;
            return this;
        }

        public ItemDefBuilder undroppable(boolean undroppable) {
            this.undroppable = undroppable;
            return this;
        }

        public ItemDefBuilder equipmentModelType(EquipmentModelType equipmentModelType) {
            this.equipmentModelType = equipmentModelType;
            return this;
        }

        public ItemDefBuilder requirements(List<SkillLevel> requirements) {
            this.requirements = requirements;
            return this;
        }

        public ItemDef build() {
            return new ItemDef(this.id, this.name, this.description, this.shopValue, this.noteId, this.noted, this.stackable, this.untradeable, this.deletedOnDeath, this.checkBeforeDrop, this.undroppable, this.equipmentModelType, this.requirements);
        }

        public String toString() {
            return "ItemDef.ItemDefBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", shopValue=" + this.shopValue + ", noteId=" + this.noteId + ", noted=" + this.noted + ", stackable=" + this.stackable + ", untradeable=" + this.untradeable + ", deletedOnDeath=" + this.deletedOnDeath + ", checkBeforeDrop=" + this.checkBeforeDrop + ", undroppable=" + this.undroppable + ", equipmentModelType=" + this.equipmentModelType + ", requirements=" + this.requirements + ")";
        }
    }
}

