/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions.anims.defs;

import com.client.definitions.SeqBase;
import com.client.definitions.SeqFrame;
import com.client.definitions.anims.decoder.impl.SeqFrameDecoderOSRS;
import com.client.definitions.anims.defs.SeqBaseDefs;
import com.client.osrs.CacheWrapper;
import com.displee.cache.index.Index;
import com.displee.cache.index.archive.file.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeqFrameDefs {
    private final Map<Integer, List<SeqFrame>> definitions;
    private final CacheWrapper cacheWrapper;
    private final SeqBaseDefs seqBaseDefs;
    private static Index frameIndex;

    public SeqFrame forID(int frameId) {
        List<SeqFrame> frames;
        SeqFrame frame;
        int frameGroupId = frameId >> 16;
        int frameFileId = frameId & 0xFFFF;
        if (this.definitions.get(frameGroupId) == null) {
            this.loadGroup(frameGroupId);
        }
        SeqFrame seqFrame = frame = frameFileId >= (frames = this.definitions.get(frameGroupId)).size() ? null : frames.get(frameFileId);
        if (frame == null) {
            System.out.println(frameFileId + " doesn't exist for " + frameGroupId + " | Has: " + frames.size() + " frames");
        }
        return frame;
    }

    public void loadGroup(int frameGroupId) {
        this.loadGroupOSRS(frameGroupId);
    }

    private void loadGroupOSRS(int frameGroupId) {
        if (frameIndex.archive(frameGroupId) == null) {
            return;
        }
        Collection<File> frameFiles = frameIndex.archive(frameGroupId).getFiles().values();
        int frameCount = Collections.max(frameFiles, Comparator.comparingInt(File::getId)).getId() + 1;
        this.definitions.put(frameGroupId, new ArrayList<Object>(Collections.nCopies(frameCount, null)));
        for (File file : frameFiles) {
            byte[] data2 = file.getData();
            if (data2.length == 0) continue;
            int baseGroupId = (data2[0] & 0xFF) << 8 | data2[1] & 0xFF;
            SeqBase transform2 = this.seqBaseDefs.get(baseGroupId);
            SeqFrameDecoderOSRS decoder = new SeqFrameDecoderOSRS();
            decoder.decode(data2, transform2, this.definitions, frameGroupId, file.getId());
        }
    }

    public static SeqFrameDefs load(CacheWrapper cacheWrapper, SeqBaseDefs seqBaseDefs) {
        frameIndex = cacheWrapper.getIndex(0);
        int count2 = frameIndex.archives().length;
        HashMap<Integer, List<SeqFrame>> definitions = new HashMap<Integer, List<SeqFrame>>(count2);
        SeqFrameDefs seqFrameDefs = new SeqFrameDefs(definitions, cacheWrapper, seqBaseDefs);
        return seqFrameDefs;
    }

    public Map<Integer, List<SeqFrame>> getDefinitions() {
        return this.definitions;
    }

    public CacheWrapper getCacheWrapper() {
        return this.cacheWrapper;
    }

    public SeqBaseDefs getSeqBaseDefs() {
        return this.seqBaseDefs;
    }

    public SeqFrameDefs(Map<Integer, List<SeqFrame>> definitions, CacheWrapper cacheWrapper, SeqBaseDefs seqBaseDefs) {
        this.definitions = definitions;
        this.cacheWrapper = cacheWrapper;
        this.seqBaseDefs = seqBaseDefs;
    }

    public static Index getFrameIndex() {
        return frameIndex;
    }
}

