/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions.anims.decoder.impl;

import com.client.InputBuffer;
import com.client.definitions.SeqBase;
import com.client.definitions.SeqFrame;
import com.client.definitions.anims.decoder.Decoder;
import com.client.definitions.anims.decoder.other.TransformType;
import java.util.List;
import java.util.Map;

public class SeqFrameDecoderOSRS
implements Decoder<SeqFrame> {
    @Override
    public void decode(byte[] data2, SeqBase transform2, Map<Integer, List<SeqFrame>> definitions, int frameGroupId, int frameFileId) {
        try {
            InputBuffer dataBuffer = new InputBuffer(data2);
            InputBuffer indicesBuffer = new InputBuffer(data2);
            SeqFrame def = new SeqFrame();
            definitions.get(frameGroupId).set(frameFileId, def);
            def.setBase(transform2);
            int transformGroupId = indicesBuffer.readUnsignedShort();
            int frameCount = indicesBuffer.readUnsignedByte();
            def.setFrameFileId(frameFileId);
            def.getBase().setGroupId(transformGroupId);
            def.setFrameCount(frameCount);
            dataBuffer.incrementPosition(3 + frameCount);
            int[] groups2 = new int[frameCount];
            int[] xDeltas = new int[frameCount];
            int[] yDeltas = new int[frameCount];
            int[] zDeltas = new int[frameCount];
            int lastI = -1;
            int groupCount = 0;
            for (int i = 0; i < frameCount; ++i) {
                int flag = indicesBuffer.readUnsignedByte();
                if (flag <= 0) continue;
                if (def.getBase().getTypes()[i] != TransformType.ORIGIN.getValue()) {
                    for (int var10 = i - 1; var10 > lastI; --var10) {
                        if (def.getBase().getTypes()[var10] != TransformType.ORIGIN.getValue()) continue;
                        groups2[groupCount] = var10;
                        xDeltas[groupCount] = 0;
                        yDeltas[groupCount] = 0;
                        zDeltas[groupCount] = 0;
                        ++groupCount;
                        break;
                    }
                }
                groups2[groupCount] = i;
                int defaultValue = 0;
                if (def.getBase().getTypes()[i] == TransformType.SCALE.getValue()) {
                    defaultValue = 128;
                }
                xDeltas[groupCount] = (flag & 1) != 0 ? dataBuffer.readSignedSmart() : defaultValue;
                yDeltas[groupCount] = (flag & 2) != 0 ? dataBuffer.readSignedSmart() : defaultValue;
                zDeltas[groupCount] = (flag & 4) != 0 ? dataBuffer.readSignedSmart() : defaultValue;
                if (def.getBase().getTypes()[i] == TransformType.ROTATION.getValue()) {
                    xDeltas[groupCount] = ((xDeltas[groupCount] & 0xFF) << 3) + (xDeltas[groupCount] >> 8 & 7);
                    yDeltas[groupCount] = ((yDeltas[groupCount] & 0xFF) << 3) + (yDeltas[groupCount] >> 8 & 7);
                    zDeltas[groupCount] = ((zDeltas[groupCount] & 0xFF) << 3) + (zDeltas[groupCount] >> 8 & 7);
                }
                lastI = i;
                ++groupCount;
            }
            if (dataBuffer.getPosition() != dataBuffer.getArray().length) {
                throw new RuntimeException();
            }
            def.setBaseCount(groupCount);
            def.setBases(groups2);
            def.setXModifier(xDeltas);
            def.setYModifier(yDeltas);
            def.setZModifier(zDeltas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

